---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：52-Intl

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Intl/Intl.php`
- E-02: `src/Symfony/Component/Intl/Countries.php`
- E-03: `src/Symfony/Component/Intl/Currencies.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BUFFER_SIZE = 10 でバッファリング | E-01 (25行目) | ○ |
| C-02 | ICUスタブバージョンは78.1 | E-01 (109行目) | ○ |
| C-03 | データディレクトリは__DIR__/Resources/data | E-01 (117行目) | ○ |
| C-04 | isExtensionLoaded()でintl拡張の有無を確認 | E-01 (63-66行目) | ○ |
| C-05 | Countries::getCountryCodes()はwithUserAssignedに応じて結果を切り替え | E-02 (38-45行目) | ○ |
| C-06 | alpha-2/alpha-3/numeric間の変換メソッドを提供 | E-02 (85-132行目) | ○ |
| C-07 | withUserAssigned()は環境変数SYMFONY_INTL_WITH_USER_ASSIGNEDで制御 | E-02 (234-241行目) | ○ |
| C-08 | 名前取得時にMissingResourceExceptionをスロー | E-02 (172行目), E-03 (52行目) | ○ |
| C-09 | Currencies::getFractionDigits()はDEFAULTにフォールバック | E-03 (90-97行目) | ○ |
| C-10 | Currencies::forCountry()で国別通貨を取得可能 | E-03 (152-175行目) | ○ |
| C-11 | 通貨のlegalTenderフィルタリングが可能 | E-03 (210-213行目) | ○ |
| C-12 | 通貨の有効期間(from/to)フィルタリングが可能 | E-03 (220-235行目) | ○ |
| C-13 | cashFractionDigitsとcashRoundingIncrementを提供 | E-03 (108-124行目) | ○ |
| C-14 | 全データはResources/dataのPHPファイルから読み取り専用 | E-01 (117行目) | ○ |
| C-15 | getNames()はasort()でロケール順ソートして返却 | E-02 (199-206行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用データの提供であり、コードとの整合性は高い

## 6) レビュアーチェックリスト（最小）
- [ ] ResourceBundle基底クラスのreadEntry()実装が正確に記述されているか確認
- [ ] ICUデータバージョンとスタブバージョンの整合性を確認
