---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：55-Uid

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Uid/AbstractUid.php`
- E-02: `src/Symfony/Component/Uid/Uuid.php`
- E-03: `src/Symfony/Component/Uid/UuidV7.php`
- E-04: `src/Symfony/Component/Uid/Ulid.php`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AbstractUidは\JsonSerializable、\Stringable、HashableInterfaceを実装 | E-01 (19行目) | ○ |
| C-02 | $uidプロパティに正規形文字列を保持 | E-01 (24行目) | ○ |
| C-03 | toBinary()は16バイトのバイナリ文字列を返す | E-01 (93行目) | ○ |
| C-04 | toBase58()は22文字の文字列を返す | E-01 (102-105行目) | ○ |
| C-05 | toBase32()は26文字の文字列を返す | E-01 (116-130行目) | ○ |
| C-06 | toRfc4122()は36文字のハイフン区切り文字列を返す | E-01 (141-150行目) | ○ |
| C-07 | Uuid名前空間定数(DNS, URL, OID, X500)を定義 | E-02 (23-26行目) | ○ |
| C-08 | fromString()はバージョンに応じた具象クラスを返す | E-02 (54-84行目) | ○ |
| C-09 | v3はMD5ハッシュベース | E-02 (91-97行目) | ○ |
| C-10 | v5はSHA-1ハッシュベース | E-02 (104-110行目) | ○ |
| C-11 | isValid()はフォーマットマスクで柔軟検証 | E-02 (130-153行目) | ○ |
| C-12 | FORMAT_RFC_9562はFORMAT_RFC_4122のエイリアス | E-02 (32行目) | ○ |
| C-13 | UuidV7はTYPE=7を定義 | E-03 (27行目) | ○ |
| C-14 | v7はsha512シードベースのインクリメント(21回ごとに再計算) | E-03 (87-96行目) | ○ |
| C-15 | オーバーフロー時にusleep(1)で待機 | E-03 (111行目) | ○ |
| C-16 | ULIDはCrockford Base32(ABCDEFGHJKMNPQRSTVWXYZ)を使用 | E-04 (88, 126行目) | ○ |
| C-17 | ULIDのgenerate()は80ビットランダム+タイムスタンプ | E-04 (187-243行目) | ○ |
| C-18 | ULIDのgetDateTime()はミリ秒精度のDateTimeImmutableを返す | E-04 (165-185行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主要クラスのコードを確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] UUID v7のサブミリ秒精度(10ビット)の記述が正確か確認
- [ ] ULIDの単調増加性保証メカニズムが正しく説明されているか確認
