---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：56-Filesystem

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Filesystem/Filesystem.php`
- E-02: `src/Symfony/Component/Filesystem/Path.php`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | copy()はターゲットが新しい場合にコピーをスキップ(デフォルト) | E-01 (47-49行目) | ○ |
| C-02 | copy()は実行権限ビットを保持する | E-01 (73行目) | ○ |
| C-03 | copy()はファイル更新日時を保持する | E-01 (76行目) | ○ |
| C-04 | copy()はストリームコピーのバイト数を検証する | E-01 (78-79行目) | ○ |
| C-05 | mkdir()はモード0o777がデフォルト | E-01 (90行目) | ○ |
| C-06 | mkdir()は再帰的ディレクトリ作成(true) | E-01 (97行目) | ○ |
| C-07 | FTPストリームラッパー対応(上書きオプション) | E-01 (58行目) | ○ |
| C-08 | $lastErrorでPHP warningメッセージをキャプチャ | E-01 (25行目) | ○ |
| C-09 | FileNotFoundExceptionをスロー(コピー元不在時) | E-01 (41行目) | ○ |
| C-10 | IOExceptionをスロー(操作失敗時) | E-01 (54, 59, 68, 79, 98行目) | ○ |
| C-11 | Path::canonicalize()のバッファサイズ(CLEANUP_THRESHOLD=1250) | E-02 (33行目) | ○ |
| C-12 | バッファクリーンアップ後のサイズ(CLEANUP_SIZE=1000) | E-02 (38行目) | ○ |
| C-13 | "~"をホームディレクトリに展開 | E-02 (80行目) | ○ |
| C-14 | 画面No.7(ソースファイル表示)と関連 | E-04 (ソースファイル表示行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要メソッドのロジックをコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] dumpFile()のアトミック書き込み実装の詳細が必要か判断
- [ ] remove()の再帰的削除ロジックの記述精度を確認
