---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-DomCrawler

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特に根拠不足の項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/DomCrawler/Crawler.php` - Crawlerクラス（行23-100）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧No.6
- E-03: ファイル一覧（DomCrawlerディレクトリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CrawlerはCountableとIteratorAggregateを実装 | E-01 (行23) | ○ |
| C-02 | 内部にDOMNode配列を保持する | E-01 (行51) | ○ |
| C-03 | isHtmlプロパティが存在する | E-01 (行56) | ○ |
| C-04 | CssSelectorConverterを使用する | E-01 (行14, importステートメント) | ○ |
| C-05 | DOMDocumentを保持する | E-01 (行46) | ○ |
| C-06 | 名前空間マップを持つ | E-01 (行34-42) | ○ |
| C-07 | baseHrefプロパティが存在する | E-01 (行44) | ○ |
| C-08 | Form.phpが存在する | E-03 | ○ |
| C-09 | Link.phpが存在する | E-03 | ○ |
| C-10 | Image.phpが存在する | E-03 | ○ |
| C-11 | UriResolver.phpが存在する | E-03 | ○ |
| C-12 | Field/ディレクトリが存在する | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Crawlerクラスの構造記述はコードに忠実
- 0: 低リスク - ファイル一覧はディレクトリ確認で検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] Crawlerクラスの主要メソッド（filter, filterXPath, text, html, attr）の動作確認
- [ ] Form/Linkクラスの機能が正確に記述されているか
