---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：60-WebLink

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/WebLink/Link.php`
- E-02: `src/Symfony/Component/WebLink/GenericLinkProvider.php`
- E-03: `src/Symfony/Component/WebLink/HttpHeaderSerializer.php`
- E-04: `src/Symfony/Component/WebLink/EventListener/AddLinkHeaderListener.php`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LinkクラスはEvolvableLinkInterfaceを実装 | E-01 (16行目) | ○ |
| C-02 | 約140のREL_*定数を定義 | E-01 (19-148行目) | ○ |
| C-03 | isTemplated()は{,}の存在でチェック | E-01 (242-244行目) | ○ |
| C-04 | withHref/withRel/withAttributeはイミュータブル(clone) | E-01 (194-240行目) | ○ |
| C-05 | $relプロパティはキー=値の連想配列で重複排除 | E-01 (153行目, 205行目) | ○ |
| C-06 | GenericLinkProviderはEvolvableLinkProviderInterfaceを実装 | E-02 (17行目) | ○ |
| C-07 | withLink()はspl_object_idをキーに使用 | E-02 (59行目) | ○ |
| C-08 | getLinksByRel()でリレーションフィルタ | E-02 (43-54行目) | ○ |
| C-09 | テンプレートURLはserializeでスキップ | E-03 (34-36行目) | ○ |
| C-10 | ダブルクォートのエスケープ処理 | E-03 (42, 49行目) | ○ |
| C-11 | ブール属性trueは名前のみ出力 | E-03 (54-56行目) | ○ |
| C-12 | 配列属性は複数回出力 | E-03 (40-45行目) | ○ |
| C-13 | 出力形式は<URL>; rel="..."; attr="..." | E-03 (59行目) | ○ |
| C-14 | 複数リンクはカンマ区切り | E-03 (62行目) | ○ |
| C-15 | REL_PRELOAD, REL_PREFETCH, REL_PRECONNECT等の定数が存在 | E-01 (97-100行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ソースファイルを確認済み、シンプルなコンポーネント

## 6) レビュアーチェックリスト（最小）
- [ ] AddLinkHeaderListenerの実装詳細(イベント優先度等)が必要か判断
- [ ] HttpHeaderParserの記述を追加すべきか判断
