---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：61-VarDumper

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **本番環境での非推奨の詳細**：明示的なドキュメント根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/VarDumper/VarDumper.php` - メインクラス
- E-02: `src/Symfony/Component/VarDumper/Cloner/VarCloner.php` - クローナー実装
- E-03: `src/Symfony/Component/VarDumper/Cloner/AbstractCloner.php` - キャスターマップ、cloneVar
- E-04: `src/Symfony/Component/VarDumper/Cloner/Data.php` - Dataクラス
- E-05: `src/Symfony/Component/VarDumper/Dumper/HtmlDumper.php` - HTML出力
- E-06: `src/Symfony/Component/VarDumper/Dumper/CliDumper.php` - CLI出力
- E-07: `src/Symfony/Component/VarDumper/Dumper/ServerDumper.php` - サーバー送信
- E-08: `src/Symfony/Component/VarDumper/Server/DumpServer.php` - ダンプサーバー
- E-09: `src/Symfony/Component/VarDumper/Dumper/ContextualizedDumper.php` - コンテキスト付加
- E-10: `src/Symfony/Component/VarDumper/composer.json` - 依存関係
- E-11: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | dump()関数がResources/functions/dump.phpで定義される | E-01 (28行目), E-10 (autoload.files) | ○ |
| C-02 | VarDumper::dump()がhandler nullならregister()を呼ぶ | E-01 (42-44行目) | ○ |
| C-03 | VAR_DUMPER_FORMAT環境変数でhtml/cli/serverを選択 | E-01 (68-86行目) | ○ |
| C-04 | HTTP_ACCEPTヘッダーでHTML/CLI出力を判定 | E-01 (79-85行目) | ○ |
| C-05 | VarClonerが幅優先探索で変数をクローン | E-02 (44-214行目) | ○ |
| C-06 | maxItemsデフォルト値が2500 | E-03 (207行目) | ○ |
| C-07 | maxStringデフォルト値が-1 | E-03 (208行目) | ○ |
| C-08 | minDepthデフォルト値が1 | E-03 (209行目) | ○ |
| C-09 | クローン処理中にGCを無効化 | E-03 (312-320行目) | ○ |
| C-10 | AbstractClonerに100以上のデフォルトキャスター定義 | E-03 (24-205行目) | ○ |
| C-11 | HtmlDumperにdark/lightテーマ定義 | E-05 (27-62行目) | ○ |
| C-12 | HtmlDumperのJavaScriptに検索・折りたたみ機能 | E-05 (150-627行目) | ○ |
| C-13 | ServerDumperがwrappedDumperにフォールバック | E-07 (47-48行目) | ○ |
| C-14 | DumpServerがunserialize時にallowed_classesを制限 | E-08 (61行目) | ○ |
| C-15 | DumpServerがstream_socket_serverでTCP起動 | E-08 (47行目) | ○ |
| C-16 | ContextualizedDumperがコンテキスト情報を付加 | E-09 (31-39行目) | ○ |
| C-17 | Dataクラスがimmutable（offsetSetで例外） | E-04 (150-153行目) | ○ |
| C-18 | ReflectionReferenceでハードリファレンス検出 | E-02 (58行目) | ○ |
| C-19 | 画面No.37 Dumpパネルとの関連 | E-12 (97-99行目) | ○ |
| C-20 | 本番環境での使用は非推奨 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20について：本番環境での使用非推奨は一般的なベストプラクティスだが、VarDumperコンポーネント自体に明示的な警告コードはない（DebugBundleにはある）
  - 候補：公式ドキュメント / DebugBundle::boot()

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードから直接確認可能な技術仕様が主体

## 6) レビュアーチェックリスト（最小）
- [ ] VAR_DUMPER_FORMAT環境変数の選択肢（html/cli/server/tcp://...）が正しいか
- [ ] maxItems/maxString/minDepthのデフォルト値がコードと一致するか
- [ ] DumpServerのセキュリティ対策（allowed_classes）が正確に記述されているか
