---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：62-DebugBundle

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし。全主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/DebugBundle/DebugBundle.php` - バンドルクラス
- E-02: `src/Symfony/Bundle/DebugBundle/DependencyInjection/DebugExtension.php` - DI拡張
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | kernel.debugがtrueの場合のみハンドラ設定 | E-01 (27行目) | ○ |
| C-02 | VarDumper::setHandlerで遅延初期化ハンドラ設定 | E-01 (35行目) | ○ |
| C-03 | data_collector.dumpサービスを遅延取得 | E-01 (36行目) | ○ |
| C-04 | var_dumper.clonerサービスを遅延取得 | E-01 (37行目) | ○ |
| C-05 | 2回目以降のハンドラ差し替え | E-01 (46行目) | ○ |
| C-06 | DumpDataCollectorPassコンパイラパスを追加 | E-01 (56行目) | ○ |
| C-07 | maxItems, minDepth, maxStringLength設定注入 | E-02 (37-41行目) | ○ |
| C-08 | darkテーマがデフォルト | E-02 (43行目) | ○ |
| C-09 | dump_destination=null時のサーバーコマンドプレースホルダー化 | E-02 (48-51行目) | ○ |
| C-10 | dump_destination=tcp://時のサーバー接続設定 | E-02 (52-64行目) | ○ |
| C-11 | dump_destination=ファイルパス時のCliDumper設定 | E-02 (65-75行目) | ○ |
| C-12 | fileLinkFormat設定の注入 | E-02 (77-81行目) | ○ |
| C-13 | ServerLogCommand未存在時のサービス削除 | E-02 (83-85行目) | ○ |
| C-14 | 画面No.37 Dumpパネルとの関連 | E-04 (97-99行目) | ○ |
| C-15 | registerCommands()がnoop | E-01 (59-62行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な内容

## 6) レビュアーチェックリスト（最小）
- [ ] 遅延初期化パターンの説明が正確か
- [ ] dump_destinationの3パターン分岐が正しく記述されているか
