---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：63-WebProfilerBundle

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **JetBrainsMono.woff2フォント内蔵**：ファイル存在未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/WebProfilerBundle.php` - バンドルクラス
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` - コントローラー
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 本番環境でE_USER_WARNING | E-01 (23-25行目) | ○ |
| C-02 | homeActionが最新プロファイルにリダイレクト | E-02 (53-58行目) | ○ |
| C-03 | panelActionでProfiler::loadProfile使用 | E-02 (79行目) | ○ |
| C-04 | トークン不明時にinfo.html.twig表示 | E-02 (80行目) | ○ |
| C-05 | latestトークンを最新トークンに置換 | E-02 (75-77行目) | ○ |
| C-06 | 例外パネル自動選択 | E-02 (88-93行目) | ○ |
| C-07 | Dumpパネル自動選択 | E-02 (95-97行目) | ○ |
| C-08 | profiler_markup_version=3 | E-02 (114行目) | ○ |
| C-09 | toolbarActionでFlashBag保持 | E-02 (130-135行目) | ○ |
| C-10 | ツールバーCSSにmax-age=600 | E-02 (181行目) | ○ |
| C-11 | searchActionで検索条件をSession保存 | E-02 (278-289行目) | ○ |
| C-12 | openActionでパス検証（..防止） | E-02 (391行目) | ○ |
| C-13 | phpinfoAction | E-02 (316-327行目) | ○ |
| C-14 | xdebugAction | E-02 (334-349行目) | ○ |
| C-15 | CSP nonce管理 | E-02 (419-431行目) | ○ |
| C-16 | Profiler無効時NotFoundHttpException | E-02 (410-417行目) | ○ |
| C-17 | 画面マッピング（画面1-36） | E-03 | ○ |
| C-18 | JetBrainsMono.woff2フォント内蔵 | **根拠なし（ファイル存在未確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18について：fontAction()のコード（359-371行目）で参照されるが、実際のフォントファイル存在はls等で未確認
  - 候補：`src/Symfony/Bundle/WebProfilerBundle/Resources/fonts/JetBrainsMono.woff2`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラーの各アクションはソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 画面マッピングの画面No一覧が漏れなく記載されているか
- [ ] CSP対応のnonce管理が正確に記述されているか
- [ ] パネル自動選択ロジック（例外 > Dump > デフォルト）が正確か
