---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：64-Ldap

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **ページネーション対応**：Query実装の詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Ldap/Ldap.php` - ファサードクラス
- E-02: `src/Symfony/Component/Ldap/LdapInterface.php` - インターフェース
- E-03: `src/Symfony/Component/Ldap/Entry.php` - エントリモデル
- E-04: `src/Symfony/Component/Ldap/Adapter/AdapterInterface.php` - アダプターIF
- E-05: `src/Symfony/Component/Ldap/Adapter/EntryManagerInterface.php` - エントリ管理IF
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ext_ldapアダプターのみサポート | E-01 (68-70行目) | ○ |
| C-02 | bind()がAdapter::getConnection()::bind()にデリゲート | E-01 (30-33行目) | ○ |
| C-03 | saslBind()でSASL認証対応 | E-01 (35-38行目) | ○ |
| C-04 | whoami()メソッド | E-01 (40-43行目) | ○ |
| C-05 | query()がAdapter::createQuery()にデリゲート | E-01 (45-48行目) | ○ |
| C-06 | escape()がAdapter::escape()にデリゲート | E-01 (55-58行目) | ○ |
| C-07 | SensitiveParameterアトリビュートのbind | E-01 (30行目) | ○ |
| C-08 | SensitiveParameterアトリビュートのsaslBind | E-01 (35行目) | ○ |
| C-09 | ESCAPE_FILTER=0x01, ESCAPE_DN=0x02 | E-02 (23-24行目) | ○ |
| C-10 | Entry::getAttribute()のcaseSensitive引数 | E-03 (76行目) | ○ |
| C-11 | Entry::setAttribute()でlowerMap更新 | E-03 (98-102行目) | ○ |
| C-12 | AdapterInterfaceの4メソッド | E-04 (22-37行目) | ○ |
| C-13 | DriverNotFoundExceptionの発生条件 | E-01 (68-70行目) | ○ |
| C-14 | create()ファクトリメソッド | E-01 (66-73行目) | ○ |
| C-15 | Entryのdn+attributesモデル | E-03 (33-40行目) | ○ |
| C-16 | ページネーション対応（pageSizeオプション） | **根拠なし（Query実装未詳細確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16について：ページネーションはQuery.phpの実装を詳細確認する必要がある
  - 候補：`src/Symfony/Component/Ldap/Adapter/ExtLdap/Query.php`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェースとファサードパターンの設計でコードが明確

## 6) レビュアーチェックリスト（最小）
- [ ] ext_ldap以外のアダプターが追加されていないか確認
- [ ] SensitiveParameterアトリビュートの記載が正確か
- [ ] ページネーション機能の詳細を確認
