---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：65-DoctrineBridge

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **DoctrineTransactionMiddlewareの詳細**：Middleware実装未確認
  2. **DoctrineExtractorの詳細**：PropertyInfo統合の実装未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bridge/Doctrine/ManagerRegistry.php` - ManagerRegistry
- E-02: `src/Symfony/Bridge/Doctrine/Form/Type/EntityType.php` - EntityType
- E-03: `src/Symfony/Bridge/Doctrine/Validator/Constraints/UniqueEntity.php` - UniqueEntity制約
- E-04: `src/Symfony/Bridge/Doctrine/Form/` - Formディレクトリ一覧
- E-05: `src/Symfony/Bridge/Doctrine/Validator/` - Validatorディレクトリ一覧
- E-06: `src/Symfony/Bridge/Doctrine/` - トップレベルディレクトリ一覧
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ManagerRegistry::getService()がDIコンテナからサービス取得 | E-01 (27-29行目) | ○ |
| C-02 | ManagerRegistry::resetService()がLazyObjectInterface対応 | E-01 (39-45行目) | ○ |
| C-03 | EntityType::configureOptions()でquery_builderノーマライザー | E-02 (30-43行目) | ○ |
| C-04 | EntityType::getLoader()がORMQueryBuilderLoaderを返す | E-02 (51-58行目) | ○ |
| C-05 | UniqueEntityがATTRIBUTE::TARGET_CLASS | E-03 (22行目) | ○ |
| C-06 | UniqueEntityのNOT_UNIQUE_ERROR UUID | E-03 (25行目) | ○ |
| C-07 | UniqueEntityのデフォルトmessage | E-03 (31行目) | ○ |
| C-08 | UniqueEntityのrepositoryMethod=findBy | E-03 (35行目) | ○ |
| C-09 | UniqueEntityのignoreNull=true | E-03 (38行目) | ○ |
| C-10 | DoctrineOrmTypeGuesserの存在 | E-04 | ○ |
| C-11 | DoctrineChoiceLoader, IdReader, ORMQueryBuilderLoaderの存在 | E-04 | ○ |
| C-12 | DoctrineInitializer, DoctrineLoaderの存在 | E-05 | ○ |
| C-13 | EntityValueResolverの存在 | E-06 (ArgumentResolver/) | ○ |
| C-14 | DoctrineDataCollectorの存在 | E-06 (DataCollector/) | ○ |
| C-15 | ProxyCacheWarmerの存在 | E-06 (CacheWarmer/) | ○ |
| C-16 | 画面No.18 Doctrineパネルとの関連 | E-07 | ○ |
| C-17 | DoctrineTransactionMiddleware | **根拠なし（Middleware実装未確認）** | △ |
| C-18 | DoctrineExtractor（PropertyInfo統合） | **根拠なし（PropertyInfo実装未確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17について：Middlewareディレクトリは存在確認済みだが、中身の実装は未読
  - 候補：`src/Symfony/Bridge/Doctrine/Middleware/`
- C-18について：PropertyInfoディレクトリは存在確認済みだが、中身の実装は未読
  - 候補：`src/Symfony/Bridge/Doctrine/PropertyInfo/`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 広範な統合ブリッジのため、一部機能の実装詳細未確認

## 6) レビュアーチェックリスト（最小）
- [ ] Middleware統合（DoctrineTransactionMiddleware等）の詳細を確認
- [ ] PropertyInfo統合（DoctrineExtractor）の詳細を確認
- [ ] EntityValueResolverのMapEntityアトリビュート対応が正確か
- [ ] CompilerPass一覧が網羅されているか
