---
generated_at: 2026-02-04 11:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：67-PsrHttpMessageBridge

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし。全主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bridge/PsrHttpMessage/HttpFoundationFactoryInterface.php` - PSR-7→SymfonyIF
- E-02: `src/Symfony/Bridge/PsrHttpMessage/HttpMessageFactoryInterface.php` - Symfony→PSR-7IF
- E-03: `src/Symfony/Bridge/PsrHttpMessage/Factory/HttpFoundationFactory.php` - PSR-7→Symfony実装
- E-04: `src/Symfony/Bridge/PsrHttpMessage/Factory/PsrHttpFactory.php` - Symfony→PSR-7実装
- E-05: `src/Symfony/Bridge/PsrHttpMessage/Factory/UploadedFile.php` - ファイルラッパー（ディレクトリ一覧確認）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HttpFoundationFactoryInterface::createRequest(ServerRequestInterface, bool) | E-01 (29行目) | ○ |
| C-02 | HttpFoundationFactoryInterface::createResponse(ResponseInterface, bool) | E-01 (34行目) | ○ |
| C-03 | HttpMessageFactoryInterface::createRequest(Request) | E-02 (29行目) | ○ |
| C-04 | HttpMessageFactoryInterface::createResponse(Response) | E-02 (34行目) | ○ |
| C-05 | createRequest()のURI解析(host, port, path, query) | E-03 (40-49行目) | ○ |
| C-06 | streamed=trueでbody->detach() | E-03 (69行目) | ○ |
| C-07 | streamed=falseでbody->__toString() | E-03 (69行目) | ○ |
| C-08 | Set-Cookieヘッダー分離とCookie::fromString() | E-03 (112-133行目) | ○ |
| C-09 | StreamedResponseでのストリーミング出力 | E-03 (116-120行目) | ○ |
| C-10 | responseBufferMaxLengthデフォルト16372 | E-03 (33行目) | ○ |
| C-11 | PSR-17自動検出（Nyholm, php-http/discovery） | E-04 (50-54行目) | ○ |
| C-12 | JSON Content-TypeでparsedBody設定 | E-04 (90-98行目) | ○ |
| C-13 | BinaryFileResponse→createStreamFromFile | E-04 (157-160行目) | ○ |
| C-14 | StreamedResponse→ob_start()キャプチャ | E-04 (163-174行目) | ○ |
| C-15 | 無効ヘッダーをcatchして無視 | E-04 (82-85行目) | ○ |
| C-16 | PsrHttpFactory::createResponse()のprotocolVersion設定 | E-04 (200-202行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コンパクトなコンポーネントで全ファイルを確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] PSR-17自動検出の優先順位（DiscoveryPsr17Factory > NyholmPsr17Factory）が正しいか
- [ ] ストリーミングモードの動作が正確に記述されているか
