---
generated_at: 2026-02-04 11:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：68-Clock

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし。全主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Clock/ClockInterface.php` - ClockIF
- E-02: `src/Symfony/Component/Clock/Clock.php` - グローバルクロック
- E-03: `src/Symfony/Component/Clock/NativeClock.php` - システム時刻クロック
- E-04: `src/Symfony/Component/Clock/MockClock.php` - テスト用クロック
- E-05: `src/Symfony/Component/Clock/DatePoint.php` - 不変日時クラス
- E-06: `src/Symfony/Component/Clock/ClockAwareTrait.php` - DI自動注入trait
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ClockInterfaceがPsrClockInterfaceを拡張 | E-01 (19行目) | ○ |
| C-02 | ClockInterfaceにsleep()メソッド | E-01 (21行目) | ○ |
| C-03 | ClockInterfaceにwithTimeZone()メソッド | E-01 (23行目) | ○ |
| C-04 | Clock::get()でglobalClock未設定時NativeClock生成 | E-02 (39行目) | ○ |
| C-05 | Clock::set()でPsrClockInterface→ClockInterfaceラップ | E-02 (44行目) | ○ |
| C-06 | Clock::now()で内部clockまたはglobalClock使用 | E-02 (49行目) | ○ |
| C-07 | Clock::now()でtimezone適用 | E-02 (55行目) | ○ |
| C-08 | NativeClockのtimezoneデフォルト=date_default_timezone_get | E-03 (28行目) | ○ |
| C-09 | NativeClock::now()でDatePoint::createFromInterface | E-03 (33行目) | ○ |
| C-10 | NativeClock::sleep()でsleep+usleep分離 | E-03 (38-44行目) | ○ |
| C-11 | MockClockのデフォルトnow='now' | E-04 (29行目) | ○ |
| C-12 | MockClockのデフォルトtimezone=UTC（string指定時） | E-04 (36行目) | ○ |
| C-13 | MockClock::now()でclone返却 | E-04 (46行目) | ○ |
| C-14 | MockClock::sleep()で仮想スリープ（内部時刻加算） | E-04 (49-60行目) | ○ |
| C-15 | MockClock::modify()で相対時刻変更 | E-04 (67行目) | ○ |
| C-16 | DatePointがDateTimeImmutable継承 | E-05 (19行目) | ○ |
| C-17 | DatePoint::createFromFormat()でエラー時例外 | E-05 (53行目) | ○ |
| C-18 | DatePoint::setMicrosecond()の範囲チェック | E-05 (121-123行目) | ○ |
| C-19 | ClockAwareTrait::setClock()に#[Required] | E-06 (26-30行目) | ○ |
| C-20 | ClockAwareTrait::now()でclock未設定時にnew Clock() | E-06 (34行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コンパクトなコンポーネントで全ファイルの全行を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] MockClock::sleep()のマイクロ秒精度の計算ロジックが正確か
- [ ] DatePointコンストラクタの'now'以外での時刻リセットロジックが正確か
- [ ] Clock::set()のPsrClockInterface→ClockInterfaceラップが正確か
