---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-HtmlSanitizer

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特に根拠不足の項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/HtmlSanitizer/HtmlSanitizer.php` - HtmlSanitizerクラス（行23-135）
- E-02: `src/Symfony/Component/HtmlSanitizer/HtmlSanitizerConfig.php` - 設定クラス（行20-77）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧No.8
- E-04: ファイル一覧（HtmlSanitizerディレクトリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sanitize()がsanitizeFor(CONTEXT_BODY)を呼ぶ | E-01 (行39-42) | ○ |
| C-02 | テキストコンテキストではHTMLエンティティエンコードのみ | E-01 (行51-53) | ○ |
| C-03 | maxInputLengthチェックが行われる | E-01 (行59-61) | ○ |
| C-04 | UTF-8妥当性チェックが行われる | E-01 (行65-67) | ○ |
| C-05 | NULL文字がU+FFFDに置換される | E-01 (行70) | ○ |
| C-06 | NativeParserでHTMLをパースする | E-01 (行73) | ○ |
| C-07 | DomVisitorがDOMツリーを走査する | E-01 (行78) | ○ |
| C-08 | DomVisitorがコンテキストごとにキャッシュされる | E-01 (行56) | ○ |
| C-09 | デフォルトアクションがDrop | E-02 (行22) | ○ |
| C-10 | 許可リンクスキームのデフォルトがhttp,https,mailto,tel | E-02 (行57) | ○ |
| C-11 | 許可メディアスキームのデフォルトがhttp,https,data | E-02 (行76) | ○ |
| C-12 | allowRelativeLinksのデフォルトがfalse | E-02 (行69) | ○ |
| C-13 | Head/Body分離でDomVisitorが生成される | E-01 (行87-134) | ○ |
| C-14 | Allow/Block/Dropの3種類のアクション | E-01 (行101, 107), E-02 (行29-43) | ○ |
| C-15 | forcedAttributes設定が存在する | E-02 (行48-50) | ○ |
| C-16 | allowedLinkHosts/allowedMediaHosts設定が存在する | E-02 (行63-64) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - HtmlSanitizer.phpの処理フローはコードに忠実に記述
- 0: 低リスク - HtmlSanitizerConfig.phpの設定項目は正確に列挙

## 6) レビュアーチェックリスト（最小）
- [ ] HtmlSanitizer.phpのsanitizeFor()処理フローが最新コードと一致するか
- [ ] HtmlSanitizerConfig.phpのデフォルト値が正確か
- [ ] W3CReference.phpの要素リファレンスが最新W3C仕様と整合するか
