---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：9-FrameworkBundle

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **80以上のコンパイラパス登録数**：正確な数値は未カウント
  2. **FrameworkExtension::load()の詳細**：大規模ファイルのため全貌未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/FrameworkBundle/FrameworkBundle.php` - FrameworkBundleクラス（行14-80 use文）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧No.9
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.9関連画面
- E-04: ファイル一覧（FrameworkBundleディレクトリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FrameworkBundleがBundle基底クラスを継承 | E-01 (行53 use) | ○ |
| C-02 | use文に80以上のコンポーネント統合パスがインポートされている | E-01 (行14-80) | ○ |
| C-03 | ProfilerPassが登録される | E-01 (行21) | ○ |
| C-04 | AddConsoleCommandPassが登録される | E-01 (行40) | ○ |
| C-05 | RegisterListenersPassが登録される | E-01 (行48) | ○ |
| C-06 | FormPassが登録される | E-01 (行49) | ○ |
| C-07 | RoutingResolverPassが登録される | E-01 (行70) | ○ |
| C-08 | 関連画面が3画面（設定パネル、テンプレート表示、リダイレクト） | E-03 | ○ |
| C-09 | Controller/ディレクトリが存在する | E-04 | ○ |
| C-10 | Command/ディレクトリが存在する | E-04 | ○ |
| C-11 | Secrets/ディレクトリが存在する | E-04 | ○ |
| C-12 | DependencyInjection/ディレクトリが存在する | E-04 | ○ |
| C-13 | Resources/ディレクトリが存在する | E-04 | ○ |
| C-14 | 80以上のコンパイラパスが登録される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14：コンパイラパスの正確な数はbuild()メソッドの全体を確認する必要がある
  - 候補：FrameworkBundle.phpのbuild()メソッド全体の確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - use文からのコンポーネント統合一覧は正確
- 1: 中リスク - コンパイラパスの数は推定値
- 0: 低リスク - 関連画面はCSVデータに基づき正確

## 6) レビュアーチェックリスト（最小）
- [ ] FrameworkBundle::build()で登録されるコンパイラパスの一覧が正確か
- [ ] FrameworkExtension::load()の設定読み込み処理が正確に記述されているか
- [ ] 関連画面一覧が画面機能マッピング.csvと一致するか
- [ ] TemplateController/RedirectControllerの動作記述が正確か
