---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 57
  claims_with_evidence: 54
  claims_without_evidence: 3
confidence_derived: 0.95
---

# 根拠レポート：画面一覧.csv / 画面遷移図.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：54 / 57、根拠なし：3
- 優先レビュー（高）
  1. **C-10 プロファイラー設定（モーダル）**：settingsテンプレートはレイアウト内インクルードであり、独立したルートを持たない。画面として分類すべきか要確認
  2. **C-40 エラープレビュー**：ErrorController::previewメソッドが実在するが、サブリクエストで処理されるため独立画面としての扱いが曖昧
  3. **C-41 テンプレート表示（TemplateController）**：汎用コントローラーのため実際にどのテンプレートが使用されるかはアプリケーション設定依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php`
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Controller/ExceptionPanelController.php`
- E-03: `src/Symfony/Bundle/WebProfilerBundle/Controller/RouterController.php`
- E-04: `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php`
- E-05: `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/wdt.php`
- E-06: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/*.html.twig`
- E-07: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/*.html.twig`
- E-08: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Router/panel.html.twig`
- E-09: `src/Symfony/Bundle/SecurityBundle/Resources/views/Collector/security.html.twig`
- E-10: `src/Symfony/Bundle/DebugBundle/Resources/views/Profiler/dump.html.twig`
- E-11: `src/Symfony/Component/ErrorHandler/Resources/views/exception_full.html.php`
- E-12: `src/Symfony/Component/ErrorHandler/Resources/views/error.html.php`
- E-13: `src/Symfony/Component/HttpKernel/Controller/ErrorController.php`
- E-14: `src/Symfony/Bundle/FrameworkBundle/Controller/TemplateController.php`
- E-15: `src/Symfony/Bundle/FrameworkBundle/Controller/RedirectController.php`
- E-16: `src/Symfony/Bridge/Twig/Resources/views/Form/*.html.twig`
- E-17: `src/Symfony/Bridge/Twig/Resources/views/Email/**/*.twig`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロファイラーホーム画面は最新検索結果へリダイレクトする | E-01, E-04 | ○ |
| C-02 | プロファイラーパネルは動的テンプレートでコレクターパネルを表示する | E-01, E-04 | ○ |
| C-03 | プロファイラー検索は検索結果またはパネルへリダイレクトする | E-01, E-04 | ○ |
| C-04 | プロファイラー検索バーは search.html.twig をレンダリングする | E-01, E-06 | ○ |
| C-05 | プロファイラー検索結果は results.html.twig をレンダリングする | E-01, E-06 | ○ |
| C-06 | トークン不明時に info.html.twig を表示する | E-01, E-06 | ○ |
| C-07 | ソースファイル表示は open.html.twig をレンダリングする | E-01, E-06 | ○ |
| C-08 | PHP情報表示は phpinfo() 出力を返す | E-01, E-04 | ○ |
| C-09 | Xdebug情報表示は xdebug_info() 出力を返す | E-01, E-04 | ○ |
| C-10 | プロファイラー設定はモーダル画面として settings.html.twig で提供 | E-06 | △ |
| C-11 | リダイレクトインターセプト画面は toolbar_redirect.html.twig で表示 | E-06 | ○ |
| C-12 | Webデバッグツールバーは toolbar.html.twig をレンダリングする | E-01, E-05 | ○ |
| C-13 | ツールバースタイルシートは toolbar.css.twig を返す | E-01, E-05 | ○ |
| C-14 | リクエスト情報パネルテンプレートが存在する | E-07 | ○ |
| C-15 | 例外情報パネルテンプレートが存在する | E-02, E-04, E-07 | ○ |
| C-16 | パフォーマンス（時間）パネルテンプレートが存在する | E-07 | ○ |
| C-17 | メモリ使用量パネルテンプレートが存在する | E-07 | ○ |
| C-18 | ログパネルテンプレートが存在する | E-07 | ○ |
| C-19 | イベントパネルテンプレートが存在する | E-07 | ○ |
| C-20 | ルーティングパネルテンプレートが存在する | E-07 | ○ |
| C-21 | ルーター詳細パネルは RouterController で表示される | E-03, E-04, E-08 | ○ |
| C-22 | Ajaxリクエストパネルテンプレートが存在する | E-07 | ○ |
| C-23 | フォームパネルテンプレートが存在する | E-07 | ○ |
| C-24 | バリデーターパネルテンプレートが存在する | E-07 | ○ |
| C-25 | キャッシュパネルテンプレートが存在する | E-07 | ○ |
| C-26 | 翻訳パネルテンプレートが存在する | E-07 | ○ |
| C-27 | セキュリティパネルテンプレートが存在する | E-09 | ○ |
| C-28 | Twigパネルテンプレートが存在する | E-07 | ○ |
| C-29 | HTTPクライアントパネルテンプレートが存在する | E-07 | ○ |
| C-30 | メーラーパネルテンプレートが存在する | E-07 | ○ |
| C-31 | 通知パネルテンプレートが存在する | E-07 | ○ |
| C-32 | Messengerパネルテンプレートが存在する | E-07 | ○ |
| C-33 | シリアライザーパネルテンプレートが存在する | E-07 | ○ |
| C-34 | ワークフローパネルテンプレートが存在する | E-07 | ○ |
| C-35 | 設定パネルテンプレートが存在する | E-07 | ○ |
| C-36 | コマンドパネルテンプレートが存在する | E-07 | ○ |
| C-37 | DumpパネルテンプレートがDebugBundleに存在する | E-10 | ○ |
| C-38 | 例外詳細画面（開発環境）テンプレートが存在する | E-11 | ○ |
| C-39 | エラー画面（本番環境）テンプレートが存在する | E-12 | ○ |
| C-40 | ErrorControllerがエラープレビュー機能を提供する | E-13 | △ |
| C-41 | TemplateControllerが任意テンプレートをレンダリングする | E-14 | △ |
| C-42 | RedirectControllerがルートまたはURLへリダイレクトする | E-15 | ○ |
| C-43 | フォームレイアウト（div）テンプレートが存在する | E-16 | ○ |
| C-44 | フォームレイアウト（table）テンプレートが存在する | E-16 | ○ |
| C-45 | フォームレイアウト（Bootstrap 3）テンプレートが存在する | E-16 | ○ |
| C-46 | フォームレイアウト（Bootstrap 3 水平）テンプレートが存在する | E-16 | ○ |
| C-47 | フォームレイアウト（Bootstrap 4）テンプレートが存在する | E-16 | ○ |
| C-48 | フォームレイアウト（Bootstrap 4 水平）テンプレートが存在する | E-16 | ○ |
| C-49 | フォームレイアウト（Bootstrap 5）テンプレートが存在する | E-16 | ○ |
| C-50 | フォームレイアウト（Bootstrap 5 水平）テンプレートが存在する | E-16 | ○ |
| C-51 | フォームレイアウト（Foundation 5）テンプレートが存在する | E-16 | ○ |
| C-52 | フォームレイアウト（Foundation 6）テンプレートが存在する | E-16 | ○ |
| C-53 | フォームレイアウト（Tailwind 2）テンプレートが存在する | E-16 | ○ |
| C-54 | メール通知（HTML - デフォルト）テンプレートが存在する | E-17 | ○ |
| C-55 | メール通知（テキスト - デフォルト）テンプレートが存在する | E-17 | ○ |
| C-56 | メール通知（HTML - Zurb 2）テンプレートが存在する | E-17 | ○ |
| C-57 | メール通知（テキスト - Zurb 2）テンプレートが存在する | E-17 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-10 プロファイラー設定（モーダル）**: settings.html.twig はレイアウトテンプレートにインクルードされるモーダルUIであり、独立したルートやコントローラーアクションを持たない。レイアウト内に組み込まれている形であるため「画面」として独立分類すべきか判断が分かれる。
  - 候補：layout.html.twig のソースコード確認 / WebProfilerBundle のJavaScriptコード確認
- **C-40 エラープレビュー**: ErrorController::preview はサブリクエストとして処理されるため、独立したビューテンプレートを持たず、カスタムエラーコントローラーに委譲する。実際のレンダリング結果はアプリケーション設定に依存する。
  - 候補：ErrorListener のソースコード確認 / アプリケーション設定の確認
- **C-41 テンプレート表示（TemplateController）**: 汎用コントローラーであり、どのテンプレートが表示されるかはルーティング設定で動的に決まる。フレームワーク本体としては特定のテンプレートを持たない。
  - 候補：アプリケーションのルーティング設定の確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コレクターパネルテンプレート（C-14～C-37）はファイルの実在確認済み
- 0: 低リスク - フォームテーマテンプレート（C-43～C-53）はファイルの実在確認済み
- 0: 低リスク - メール通知テンプレート（C-54～C-57）はファイルの実在確認済み
- 1: 中リスク - プロファイラー設定モーダル（C-10）は画面分類の妥当性要確認
- 1: 中リスク - エラープレビュー（C-40）のサブリクエスト委譲による画面表示の実態確認
- 0: 低リスク - 本プロジェクトはSymfonyフレームワーク本体であるため、アプリケーション固有の画面は存在しない。一覧はフレームワーク提供の画面・テンプレートのみ

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧のカテゴリ分類が妥当か（WebProfilerBundle / ErrorHandler / FrameworkBundle / Bridge-Twig）
- [ ] プロファイラー設定（モーダル）を独立画面として扱うことが妥当か
- [ ] エラープレビュー画面の記載内容が正確か
- [ ] TemplateController / RedirectController を「画面」として含めることが妥当か
- [ ] フォームテーマテンプレートを「画面」として含めることが妥当か（テンプレートパーツの可能性）
- [ ] メール通知テンプレートを「画面」として含めることが妥当か（メール本文であり画面ではない可能性）
- [ ] 画面遷移図の遷移関係がコントローラーのロジックと整合しているか
- [ ] 本プロジェクトがSymfonyフレームワーク本体であることを前提とした一覧であることを確認
