# 画面遷移図

## 概要

本ドキュメントは Symfony 8.1 フレームワーク本体が提供する画面間の遷移関係を Mermaid 形式で図示したものです。

## 1. WebProfilerBundle - プロファイラー画面遷移

```mermaid
flowchart TD
    subgraph WebProfilerBundle["WebProfilerBundle - プロファイラー"]
        HOME["プロファイラーホーム<br/>_profiler_home"]
        SEARCH["プロファイラー検索<br/>_profiler_search"]
        SEARCH_BAR["プロファイラー検索バー<br/>_profiler_search_bar"]
        SEARCH_RESULTS["プロファイラー検索結果<br/>_profiler_search_results"]
        PANEL["プロファイラーパネル<br/>_profiler"]
        INFO["プロファイラー情報<br/>（トークン不明時）"]
        OPEN_FILE["ソースファイル表示<br/>_profiler_open_file"]
        PHPINFO["PHP情報表示<br/>_profiler_phpinfo"]
        XDEBUG["Xdebug情報表示<br/>_profiler_xdebug"]
        REDIRECT_INTERCEPT["リダイレクトインターセプト"]
        SETTINGS["プロファイラー設定<br/>（モーダル）"]
    end

    HOME -->|"リダイレクト"| SEARCH_RESULTS
    SEARCH_BAR -->|"検索実行"| SEARCH
    SEARCH -->|"トークン指定時"| PANEL
    SEARCH -->|"トークン未指定時<br/>リダイレクト"| SEARCH_RESULTS
    SEARCH_RESULTS -->|"トークン選択"| PANEL
    PANEL -->|"トークン不明"| INFO
    PANEL -->|"ファイルリンク"| OPEN_FILE
    PANEL -->|"設定ボタン"| SETTINGS
    PANEL -->|"PHP情報リンク"| PHPINFO
    PANEL -->|"Xdebugリンク"| XDEBUG
```

## 2. WebProfilerBundle - ツールバーとパネル遷移

```mermaid
flowchart TD
    subgraph Toolbar["Webデバッグツールバー"]
        WDT["Webデバッグツールバー<br/>_wdt"]
    end

    subgraph ProfilerPanels["プロファイラーパネル（コレクター）"]
        PANEL_MAIN["プロファイラーパネル<br/>_profiler"]
        REQUEST["リクエスト情報パネル"]
        EXCEPTION["例外情報パネル<br/>_profiler_exception"]
        TIME["パフォーマンス（時間）パネル"]
        MEMORY["メモリ使用量パネル"]
        LOG["ログパネル"]
        EVENTS["イベントパネル"]
        ROUTER_PANEL["ルーティングパネル"]
        ROUTER_DETAIL["ルーター詳細パネル<br/>_profiler_router"]
        AJAX["Ajaxリクエストパネル"]
        FORM["フォームパネル"]
        VALIDATOR["バリデーターパネル"]
        CACHE["キャッシュパネル"]
        TRANSLATION["翻訳パネル"]
        SECURITY["セキュリティパネル"]
        TWIG["Twigパネル"]
        HTTP_CLIENT["HTTPクライアントパネル"]
        MAILER["メーラーパネル"]
        NOTIFIER["通知パネル"]
        MESSENGER["Messengerパネル"]
        SERIALIZER["シリアライザーパネル"]
        WORKFLOW["ワークフローパネル"]
        CONFIG["設定パネル"]
        COMMAND["コマンドパネル"]
        DUMP["Dumpパネル"]
    end

    WDT -->|"クリック"| PANEL_MAIN
    PANEL_MAIN -->|"パネル切替"| REQUEST
    PANEL_MAIN -->|"パネル切替"| EXCEPTION
    PANEL_MAIN -->|"パネル切替"| TIME
    PANEL_MAIN -->|"パネル切替"| MEMORY
    PANEL_MAIN -->|"パネル切替"| LOG
    PANEL_MAIN -->|"パネル切替"| EVENTS
    PANEL_MAIN -->|"パネル切替"| ROUTER_PANEL
    PANEL_MAIN -->|"パネル切替"| AJAX
    PANEL_MAIN -->|"パネル切替"| FORM
    PANEL_MAIN -->|"パネル切替"| VALIDATOR
    PANEL_MAIN -->|"パネル切替"| CACHE
    PANEL_MAIN -->|"パネル切替"| TRANSLATION
    PANEL_MAIN -->|"パネル切替"| SECURITY
    PANEL_MAIN -->|"パネル切替"| TWIG
    PANEL_MAIN -->|"パネル切替"| HTTP_CLIENT
    PANEL_MAIN -->|"パネル切替"| MAILER
    PANEL_MAIN -->|"パネル切替"| NOTIFIER
    PANEL_MAIN -->|"パネル切替"| MESSENGER
    PANEL_MAIN -->|"パネル切替"| SERIALIZER
    PANEL_MAIN -->|"パネル切替"| WORKFLOW
    PANEL_MAIN -->|"パネル切替"| CONFIG
    PANEL_MAIN -->|"パネル切替"| COMMAND
    PANEL_MAIN -->|"パネル切替"| DUMP
    ROUTER_PANEL -->|"詳細表示"| ROUTER_DETAIL
```

## 3. ErrorHandler - エラー画面遷移

```mermaid
flowchart TD
    subgraph ErrorHandling["ErrorHandler - エラー画面"]
        ERROR_CTRL["ErrorController"]
        EXCEPTION_FULL["例外詳細画面<br/>（開発環境）"]
        ERROR_SIMPLE["エラー画面<br/>（本番環境）"]
        ERROR_PREVIEW["エラープレビュー"]
    end

    ERROR_CTRL -->|"開発環境"| EXCEPTION_FULL
    ERROR_CTRL -->|"本番環境"| ERROR_SIMPLE
    ERROR_CTRL -->|"プレビュー"| ERROR_PREVIEW
```

## 4. FrameworkBundle - 汎用コントローラー

```mermaid
flowchart TD
    subgraph FrameworkBundle["FrameworkBundle - 汎用コントローラー"]
        TEMPLATE_CTRL["TemplateController<br/>（テンプレート表示）"]
        REDIRECT_CTRL["RedirectController<br/>（リダイレクト）"]
        TARGET_ROUTE["リダイレクト先ルート"]
        TARGET_URL["リダイレクト先URL"]
        RENDERED_PAGE["レンダリングされたテンプレート"]
    end

    TEMPLATE_CTRL -->|"テンプレートレンダリング"| RENDERED_PAGE
    REDIRECT_CTRL -->|"ルート指定"| TARGET_ROUTE
    REDIRECT_CTRL -->|"URL指定"| TARGET_URL
```

## 5. 全体の画面遷移概要

```mermaid
flowchart LR
    subgraph UserPage["ユーザーページ"]
        ANY_PAGE["任意のページ"]
    end

    subgraph WDT_Area["デバッグツールバー"]
        TOOLBAR["Webデバッグツールバー"]
    end

    subgraph Profiler_Area["プロファイラー"]
        PROF_HOME["ホーム"]
        PROF_SEARCH["検索"]
        PROF_RESULTS["検索結果"]
        PROF_PANEL["パネル表示"]
        PROF_COLLECTORS["各コレクターパネル"]
    end

    subgraph Error_Area["エラー処理"]
        ERROR_DEV["例外詳細（開発）"]
        ERROR_PROD["エラー（本番）"]
    end

    ANY_PAGE -->|"ツールバー表示"| TOOLBAR
    TOOLBAR -->|"クリック"| PROF_PANEL
    PROF_HOME -->|"リダイレクト"| PROF_RESULTS
    PROF_SEARCH -->|"検索"| PROF_RESULTS
    PROF_RESULTS -->|"選択"| PROF_PANEL
    PROF_PANEL -->|"パネル切替"| PROF_COLLECTORS
    ANY_PAGE -->|"例外発生（開発）"| ERROR_DEV
    ANY_PAGE -->|"例外発生（本番）"| ERROR_PROD
```
