---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 130
  claims_with_evidence: 121
  claims_without_evidence: 9
confidence_derived: 0.93
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された画面機能マッピング.csvの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：121 / 130、根拠なし：9
- 優先レビュー（高）
  1. **プロファイラー設定（画面No.10）のマッピング**：settings.html.twigはレイアウト内インクルードであり、直接のコントローラーアクションが不明確
  2. **リダイレクトインターセプト（画面No.11）のマッピング**：toolbar_redirect.html.twigの使用箇所がEventListener経由であり、コントローラーとの直接対応が不明確
  3. **Ajaxリクエストパネル（画面No.22）とHttpClient機能の関連**：AjaxパネルはJavaScript側のXHR情報収集であり、HttpClientコンポーネントとの直接関連は要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（57画面）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（68機能）
- E-03: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` - プロファイラーコントローラー
- E-04: `src/Symfony/Bundle/WebProfilerBundle/Controller/RouterController.php` - ルーターコントローラー
- E-05: `src/Symfony/Bundle/WebProfilerBundle/Controller/ExceptionPanelController.php` - 例外パネルコントローラー
- E-06: `src/Symfony/Bundle/FrameworkBundle/Controller/TemplateController.php` - テンプレートコントローラー
- E-07: `src/Symfony/Bundle/FrameworkBundle/Controller/RedirectController.php` - リダイレクトコントローラー
- E-08: `src/Symfony/Component/HttpKernel/Controller/ErrorController.php` - エラーコントローラー
- E-09: `src/Symfony/Component/ErrorHandler/ErrorRenderer/HtmlErrorRenderer.php` - HTMLエラーレンダラー
- E-10: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/*.html.twig` - コレクターパネルテンプレート群（21ファイル）
- E-11: `src/Symfony/Bundle/SecurityBundle/Resources/views/Collector/security.html.twig` - セキュリティパネルテンプレート
- E-12: `src/Symfony/Bundle/DebugBundle/Resources/views/Profiler/dump.html.twig` - Dumpパネルテンプレート
- E-13: `src/Symfony/Bridge/Twig/Resources/views/Form/*.html.twig` - フォームレイアウトテンプレート群
- E-14: `src/Symfony/Bridge/Twig/Resources/views/Email/` - メール通知テンプレート群
- E-15: `src/Symfony/Component/ErrorHandler/Resources/views/exception_full.html.php` - 開発環境用例外詳細テンプレート
- E-16: `src/Symfony/Component/ErrorHandler/Resources/views/error.html.php` - 本番環境用エラーテンプレート

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.1「プロファイラーホーム」はRouting（UrlGenerator）でリダイレクトURLを生成する | E-03 (ProfilerController::homeAction L57) | ○ |
| C-02 | 画面No.1はHttpFoundationのRedirectResponseを使用する | E-03 (ProfilerController::homeAction L57) | ○ |
| C-03 | 画面No.1はWebProfilerBundleのProfilerController::homeActionが処理する | E-03 (ProfilerController::homeAction L53) | ○ |
| C-04 | 画面No.2「プロファイラーパネル」はWebProfilerBundleのProfilerController::panelActionが処理する | E-03 (ProfilerController::panelAction L65) | ○ |
| C-05 | 画面No.2はHttpKernelのProfilerでプロファイルデータを読み込む | E-03 (ProfilerController::panelAction L79) | ○ |
| C-06 | 画面No.2はTwigBundleでテンプレートをレンダリングする | E-03 (ProfilerController::panelAction L105) | ○ |
| C-07 | 画面No.2はHttpFoundationのRequestからクエリパラメータを取得する | E-03 (ProfilerController::panelAction L71-73) | ○ |
| C-08 | 画面No.3「プロファイラー検索」はRoutingでリダイレクトURLを生成する | E-03 (ProfilerController::searchAction L298) | ○ |
| C-09 | 画面No.3はHttpKernelのProfilerで検索を実行する | E-03 (ProfilerController::searchAction L296) | ○ |
| C-10 | 画面No.3はHttpFoundationのSessionに検索条件を保存する | E-03 (ProfilerController::searchAction L281-289) | ○ |
| C-11 | 画面No.3はWebProfilerBundleのProfilerController::searchActionが処理する | E-03 (ProfilerController::searchAction L264) | ○ |
| C-12 | 画面No.4「プロファイラー検索バー」はWebProfilerBundleのsearchBarActionが処理する | E-03 (ProfilerController::searchBarAction L191) | ○ |
| C-13 | 画面No.4はTwigBundleでsearch.html.twigをレンダリングする | E-03 (ProfilerController::searchBarAction L203) | ○ |
| C-14 | 画面No.4はHttpFoundationのRequest/Sessionから検索条件を取得する | E-03 (ProfilerController::searchBarAction L204-213) | ○ |
| C-15 | 画面No.5「プロファイラー検索結果」はWebProfilerBundleのsearchResultsActionが処理する | E-03 (ProfilerController::searchResultsAction L225) | ○ |
| C-16 | 画面No.5はHttpKernelのProfilerで検索・読み込みを行う | E-03 (ProfilerController::searchResultsAction L231, L246) | ○ |
| C-17 | 画面No.5はTwigBundleでresults.html.twigをレンダリングする | E-03 (ProfilerController::searchResultsAction L242) | ○ |
| C-18 | 画面No.6「プロファイラー情報」はpanelActionでinfo.html.twigを表示する | E-03 (ProfilerController::panelAction L80) | ○ |
| C-19 | 画面No.7「ソースファイル表示」はopenActionが処理する | E-03 (ProfilerController::openAction L378) | ○ |
| C-20 | 画面No.7はTwigBundleでopen.html.twigをレンダリングする | E-03 (ProfilerController::openAction L395) | ○ |
| C-21 | 画面No.7はFilesystemのSplFileInfoでファイル情報を取得する | E-03 (ProfilerController::openAction L396) | ○ |
| C-22 | 画面No.8「PHP情報表示」はphpinfoActionが処理する | E-03 (ProfilerController::phpinfoAction L316) | ○ |
| C-23 | 画面No.9「Xdebug情報表示」はxdebugActionが処理する | E-03 (ProfilerController::xdebugAction L334) | ○ |
| C-24 | 画面No.10「プロファイラー設定」はレイアウト内インクルードで表示される | E-01 (画面一覧「レイアウト内インクルード」) | △ |
| C-25 | 画面No.11「リダイレクトインターセプト」はデバッグ時のリダイレクトをインターセプトする | E-01 (画面一覧「デバッグ時のリダイレクト確認用」) | △ |
| C-26 | 画面No.12「Webデバッグツールバー」はtoolbarActionが処理する | E-03 (ProfilerController::toolbarAction L124) | ○ |
| C-27 | 画面No.12はHttpKernelのProfilerでプロファイルデータを読み込む | E-03 (ProfilerController::toolbarAction L143) | ○ |
| C-28 | 画面No.12はTwigBundleでtoolbar.html.twigをレンダリングする | E-03 (ProfilerController::toolbarAction L154) | ○ |
| C-29 | 画面No.12はRoutingでプロファイラーパネルへのURLを生成する | E-03 (ProfilerController::toolbarAction L149) | ○ |
| C-30 | 画面No.13「ツールバースタイルシート」はtoolbarStylesheetActionが処理する | E-03 (ProfilerController::toolbarStylesheetAction L170) | ○ |
| C-31 | 画面No.14「リクエスト情報パネル」はRequestDataCollectorの情報を表示する | E-10 (request.html.twig) | ○ |
| C-32 | 画面No.15「例外情報パネル」はExceptionPanelControllerが処理する | E-05 (ExceptionPanelController::body) | ○ |
| C-33 | 画面No.15はHtmlErrorRendererで例外スタックトレースをレンダリングする | E-05 (ExceptionPanelController L48), E-09 | ○ |
| C-34 | 画面No.16「パフォーマンスパネル」はStopwatchの計測データを表示する | E-10 (time.html.twig) | ○ |
| C-35 | 画面No.17「メモリ使用量パネル」はMemoryDataCollectorのデータを表示する | E-10 (memory.html.twig) | ○ |
| C-36 | 画面No.18「ログパネル」はMonolog Bridgeのログデータを表示する | E-10 (logger.html.twig) | ○ |
| C-37 | 画面No.19「イベントパネル」はEventDispatcherのイベント情報を表示する | E-10 (events.html.twig) | ○ |
| C-38 | 画面No.20「ルーティングパネル」はRoutingのルートマッチング結果を表示する | E-10 (router.html.twig) | ○ |
| C-39 | 画面No.21「ルーター詳細パネル」はRouterController::panelActionが処理する | E-04 (RouterController::panelAction L53) | ○ |
| C-40 | 画面No.21はTraceableUrlMatcherでトレース情報を生成する | E-04 (RouterController L93) | ○ |
| C-41 | 画面No.22「Ajaxリクエストパネル」はAjaxリクエスト情報を表示する | E-10 (ajax.html.twig) | ○ |
| C-42 | 画面No.22とHttpClientコンポーネントの関連 | **根拠なし** | △ |
| C-43 | 画面No.23「フォームパネル」はFormコンポーネントの構造情報を表示する | E-10 (form.html.twig) | ○ |
| C-44 | 画面No.23はValidatorのバリデーション制約を表示する | E-10 (form.html.twig) | ○ |
| C-45 | 画面No.24「バリデーターパネル」はValidatorの制約・結果を表示する | E-10 (validator.html.twig) | ○ |
| C-46 | 画面No.25「キャッシュパネル」はCacheのヒット/ミス統計を表示する | E-10 (cache.html.twig) | ○ |
| C-47 | 画面No.26「翻訳パネル」はTranslationの使用状況を表示する | E-10 (translation.html.twig) | ○ |
| C-48 | 画面No.27「セキュリティパネル」はSecurityBundleが提供するテンプレートで表示する | E-11 (security.html.twig) | ○ |
| C-49 | 画面No.27はSecurity Coreの認証ユーザー情報を表示する | E-11 (security.html.twig) | ○ |
| C-50 | 画面No.27はSecurity HTTPのファイアウォール情報を表示する | E-11 (security.html.twig) | ○ |
| C-51 | 画面No.28「Twigパネル」はTwig Bridgeのレンダリング統計を表示する | E-10 (twig.html.twig) | ○ |
| C-52 | 画面No.29「HTTPクライアントパネル」はHttpClientのトレース情報を表示する | E-10 (http_client.html.twig) | ○ |
| C-53 | 画面No.30「メーラーパネル」はMailerの送信メール情報を表示する | E-10 (mailer.html.twig) | ○ |
| C-54 | 画面No.30はMimeのメッセージ構造を表示する | E-10 (mailer.html.twig) | ○ |
| C-55 | 画面No.31「通知パネル」はNotifierの通知情報を表示する | E-10 (notifier.html.twig) | ○ |
| C-56 | 画面No.32「Messengerパネル」はMessengerのディスパッチ情報を表示する | E-10 (messenger.html.twig) | ○ |
| C-57 | 画面No.33「シリアライザーパネル」はSerializerの処理情報を表示する | E-10 (serializer.html.twig) | ○ |
| C-58 | 画面No.34「ワークフローパネル」はWorkflowの状態遷移情報を表示する | E-10 (workflow.html.twig) | ○ |
| C-59 | 画面No.35「設定パネル」はFrameworkBundleの設定情報を表示する | E-10 (config.html.twig) | ○ |
| C-60 | 画面No.35はConfigコンポーネントの設定値を表示する | E-10 (config.html.twig) | △ |
| C-61 | 画面No.36「コマンドパネル」はConsoleのコマンド実行情報を表示する | E-10 (command.html.twig) | ○ |
| C-62 | 画面No.37「Dumpパネル」はDebugBundleが提供するテンプレートで表示する | E-12 (dump.html.twig) | ○ |
| C-63 | 画面No.37はVarDumperのdump()出力データを表示する | E-12 (dump.html.twig) | ○ |
| C-64 | 画面No.38「例外詳細画面（開発環境）」はHtmlErrorRendererが処理する | E-09 (HtmlErrorRenderer L125), E-15 | ○ |
| C-65 | 画面No.38はHttpKernelのErrorControllerが処理する | E-08 (ErrorController::__invoke) | ○ |
| C-66 | 画面No.39「エラー画面（本番環境）」はHtmlErrorRendererが処理する | E-09 (HtmlErrorRenderer L42, L132), E-16 | ○ |
| C-67 | 画面No.39はHttpKernelのErrorControllerが処理する | E-08 (ErrorController::__invoke) | ○ |
| C-68 | 画面No.40「エラープレビュー」はErrorController::previewが処理する | E-08 (ErrorController::preview L42) | ○ |
| C-69 | 画面No.41「テンプレート表示」はTemplateControllerが処理する | E-06 (TemplateController::templateAction) | ○ |
| C-70 | 画面No.41はTwigBundleでテンプレートをレンダリングする | E-06 (TemplateController L48) | ○ |
| C-71 | 画面No.41はCacheのレスポンスキャッシュ設定を管理する | E-06 (TemplateController L50-62) | ○ |
| C-72 | 画面No.42「リダイレクト」はRedirectControllerが処理する | E-07 (RedirectController) | ○ |
| C-73 | 画面No.42はRoutingでURLを生成してリダイレクトする | E-07 (RedirectController::redirectAction L85) | ○ |
| C-74 | 画面No.42はHttpFoundationのRedirectResponseを生成する | E-07 (RedirectController L85, L126) | ○ |
| C-75 | 画面No.43-53のフォームレイアウトはFormコンポーネントと関連する | E-13 (フォームテンプレート群) | ○ |
| C-76 | 画面No.43-53のフォームレイアウトはTwig Bridgeのフォーム拡張と関連する | E-13 (フォームテンプレート群) | ○ |
| C-77 | 画面No.54-57のメール通知テンプレートはNotifierコンポーネントと関連する | E-14 (メール通知テンプレート群) | ○ |
| C-78 | 画面No.54-57のメール通知テンプレートはMailerコンポーネントと関連する | E-14 (メール通知テンプレート群) | ○ |
| C-79 | 画面No.54-57のメール通知テンプレートはMimeコンポーネントと関連する | E-14 (メール通知テンプレート群) | ○ |
| C-80 | 画面No.54-57のメール通知テンプレートはTwig Bridgeと関連する | E-14 (メール通知テンプレート群) | ○ |
| C-81 | 画面No.10のプロファイラー設定はTwigBundleでレンダリングされる | **根拠なし**（直接のコントローラーアクション確認不可） | △ |
| C-82 | 画面No.11のリダイレクトインターセプトはTwigBundleでレンダリングされる | **根拠なし**（EventListener経由の間接的な表示） | △ |
| C-83 | 画面No.18「ログパネル」とMonolog Bridge機能No.66の直接的な関連 | E-10 (logger.html.twig) | ○ |
| C-84 | 画面No.35「設定パネル」とConfig機能No.11の直接的な補助機能としての関連 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **画面No.10「プロファイラー設定」の表示メカニズム**: settings.html.twigがどのアクションからインクルードされるかの明示的なコード根拠が不足。レイアウトテンプレート内でのインクルードであるため、直接のコントローラーアクションが存在しない可能性がある。
  - 候補：`@WebProfiler/Profiler/layout.html.twig` / WebProfilerBundle設定ファイル / Twigインクルード機構
- **画面No.11「リダイレクトインターセプト」の表示トリガー**: toolbar_redirect.html.twigの表示がEventListenerから行われるため、直接のコントローラーアクションではない。
  - 候補：`WebProfilerBundle EventListener` / `HttpKernel KernelEvents::RESPONSE`
- **画面No.22「Ajaxリクエストパネル」とHttpClient機能の関連**: AjaxパネルはブラウザのXMLHttpRequestの情報を収集するもので、サーバーサイドのHttpClientコンポーネントとの直接的な関連は不明確。
  - 候補：JavaScript側のXHR情報収集 / HttpClientとは無関連の可能性
- **画面No.35「設定パネル」とConfig機能の補助機能としての関連**: config.html.twigが直接Configコンポーネントを使用しているかの明示的根拠が不足。
  - 候補：ConfigDataCollector / FrameworkBundle設定 / Symfony Kernel設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面No.1-9, 12-13, 14-21, 23-34, 36-42のマッピングはコントローラーコードおよびテンプレートファイルの存在から高い確度で確認済み
- 0: 低リスク - 画面No.43-57のフォームレイアウトおよびメール通知テンプレートはTwig Bridgeのリソースディレクトリに実在するテンプレートファイルから確認済み
- 1: 中リスク - 画面No.10, 11のマッピングはレイアウト内インクルードやEventListener経由の間接的表示のため、正確な機能関連の確認が必要
- 1: 中リスク - 画面No.22「Ajaxリクエストパネル」とHttpClient（機能No.4）の関連は要再検証。Ajaxパネルはブラウザ側のXHR情報を扱うため、サーバーサイドのHttpClientとは直接関連しない可能性がある
- 0: 低リスク - 画面No.35「設定パネル」とConfig（機能No.11）の補助機能としての関連は妥当な推定だが、明示的な直接参照の確認は必要

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧の全57画面がマッピングに含まれているか確認
- [ ] 画面No.10「プロファイラー設定」の機能関連が正確か確認（レイアウト内インクルードの仕組み）
- [ ] 画面No.11「リダイレクトインターセプト」の表示トリガーとなるEventListenerの確認
- [ ] 画面No.22「Ajaxリクエストパネル」のHttpClient関連を削除するか、より適切な機能との関連に修正するか判断
- [ ] 各コレクターパネル（画面No.14-36）と対応するデータコレクターの正確な対応関係の確認
- [ ] フォームレイアウトテンプレート（画面No.43-53）の機能関連がForm/Twig Bridgeで適切か確認
- [ ] メール通知テンプレート（画面No.54-57）のNotifier/Mailer/Mime/Twig Bridgeとの関連が適切か確認
- [ ] 関連種別（主機能/補助機能/遷移先機能/API連携）の分類が適切か確認
