# 画面設計書 1-プロファイラーホーム

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する「プロファイラーホーム」画面の設計書である。本画面はプロファイラーのトップページとして機能し、アクセスすると自動的に最新のプロファイル検索結果画面へリダイレクトする。

### 本画面の処理概要

本画面は、Symfonyプロファイラーのエントリーポイントとして、開発者がプロファイラーに最初にアクセスした際に、直近のプロファイリング結果を素早く確認できるようにするためのリダイレクト画面である。

**業務上の目的・背景**：開発者がプロファイラーのルートURL（`/_profiler/`）にアクセスした際、空のページを表示するのではなく、直近10件のプロファイルデータを含む検索結果画面へ自動的に転送することで、開発者のデバッグ作業を効率化する。Webアプリケーション開発において、パフォーマンスやリクエストの状態を迅速に把握するための起点となる。

**画面へのアクセス方法**：ブラウザで `/_profiler/` にアクセスすることで本画面が呼び出される。Webデバッグツールバーのロゴリンクや、プロファイラー内のヘッダーに表示される「Symfony Profiler」リンクからもアクセス可能である。

**主要な操作・処理内容**：
1. ProfilerControllerのhomeActionメソッドが呼び出される
2. プロファイラーが有効であることを確認する（無効な場合は404エラーを返す）
3. プロファイラーの計測を無効化する（プロファイラー自身のアクセスは記録しない）
4. UrlGeneratorを使用して検索結果画面（`_profiler_search_results`）のURLを生成する（パラメータ: token=empty, limit=10）
5. HTTP 302ステータスコードでリダイレクトレスポンスを返す

**画面遷移**：
- 遷移元：Webデバッグツールバーのロゴリンク、プロファイラーヘッダーの「Symfony Profiler」リンク、ブラウザ直接アクセス
- 遷移先：プロファイラー検索結果画面（No.5）（token=empty, limit=10パラメータ付き）

**権限による表示制御**：特定の権限制御は実装されていない。ただし、プロファイラーが有効な環境（通常は開発環境のみ）でのみ動作する。プロファイラーが無効な場合は`NotFoundHttpException`がスローされ、404エラーが返される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | ProfilerController::homeActionによるプロファイラーホーム画面の処理 |
| 3 | Routing | 主機能 | 最新プロファイル検索結果へのリダイレクトURLをRouting（UrlGenerator）で生成する |
| 1 | HttpFoundation | 補助機能 | RedirectResponseを生成してHTTPリダイレクトを実行する |

## 画面種別

リダイレクト（画面描画なし）

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| ルート名 | `_profiler_home` |
| URLパターン | `/_profiler/` |
| HTTPメソッド | GET |
| コントローラー | `web_profiler.controller.profiler::homeAction` |

## 入出力項目

本画面はリダイレクト処理のみを行うため、入力フォームや出力表示は存在しない。

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| なし | - | - | リダイレクト処理のみ |

## 表示項目

本画面はHTMLを描画しない（リダイレクトレスポンスを返却するのみ）。

## イベント仕様

### 1-画面アクセス時リダイレクト

画面にアクセスすると、以下の処理が実行される。

1. `denyAccessIfProfilerDisabled()`メソッドにより、プロファイラーの有効性を確認
2. プロファイラーの計測を無効化（`$this->profiler->disable()`）
3. `UrlGeneratorInterface`を使用して`_profiler_search_results`ルートのURLを生成（パラメータ: `token=empty`, `limit=10`）
4. HTTP 302レスポンスとして`RedirectResponse`を返却（Content-Type: text/html）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面アクセス | なし | なし | リダイレクトのみのため、データベース操作は発生しない |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| - | エラー | "The profiler must be enabled." | プロファイラーが無効な場合にNotFoundHttpExceptionとしてスロー |

## 例外処理

| 例外クラス | 発生条件 | ユーザーへの影響 |
|-----------|---------|----------------|
| `NotFoundHttpException` | プロファイラーが無効（`$this->profiler`がnull）の場合 | HTTP 404エラーページが表示される |

## 備考

- 本画面は開発環境（`dev`環境）でのみ利用可能であり、本番環境では通常ルーティングが登録されないため到達不可である
- リダイレクト先の検索結果画面では`token=empty`により空のトークンとして扱われ、直近10件のプロファイルが表示される
- Content-Typeヘッダーとして`text/html`が明示的に設定される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面はリダイレクト処理のみであるが、リダイレクト先URLの構築に必要なルーティング情報を理解する必要がある。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | profiler.php | `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` | ルート名`_profiler_home`（15行目）と`_profiler_search_results`（33行目）の定義を確認する |

**読解のコツ**: Symfony のルーティング設定ファイルは PHP による`RoutingConfigurator`を使用した宣言的記法である。`$routes->add()`の第1引数がルート名、第2引数がURLパターンである。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | `homeAction`メソッド（53-58行目）がエントリーポイント。コンストラクタ（38-46行目）で注入される依存関係も確認する |

**主要処理フロー**:
1. **55行目**: `denyAccessIfProfilerDisabled()` - プロファイラーの有効性確認と計測の無効化
2. **57行目**: `$this->generator->generate('_profiler_search_results', ...)` - リダイレクト先URLの生成
3. **57行目**: `new RedirectResponse(...)` - HTTP 302リダイレクトレスポンスの生成

#### Step 3: アクセス制御の仕組みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | `denyAccessIfProfilerDisabled`メソッド（410-417行目）でプロファイラー無効時にNotFoundHttpExceptionをスローする仕組み |

**主要処理フロー**:
- **412行目**: `$this->profiler`がnullかどうかを確認
- **413行目**: nullの場合は`NotFoundHttpException`をスロー
- **416行目**: プロファイラーの計測を無効化（プロファイラー自身のリクエストを記録しない）

### プログラム呼び出し階層図

```
ProfilerController::homeAction()
    |
    +-- denyAccessIfProfilerDisabled()
    |       +-- Profiler::disable()
    |
    +-- UrlGeneratorInterface::generate('_profiler_search_results', [...])
    |
    +-- new RedirectResponse($url, 302)
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTPリクエスト   --> ProfilerController        --> RedirectResponse
(GET /_profiler/)    ::homeAction()                (302 -> /_profiler/empty/search/results?limit=10)
                         |
                         +-- UrlGenerator
                             ::generate()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | ソース | homeActionメソッドを含むコントローラー |
| profiler.php | `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` | 設定 | ルーティング定義（_profiler_homeルート） |
| header.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/header.html.twig` | テンプレート | プロファイラーホームへのリンクを含むヘッダー |
