# 画面設計書 11-リダイレクトインターセプト

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する「リダイレクトインターセプト」画面の設計書である。HTTPリダイレクト応答を開発時にインターセプト（中断）し、リダイレクト先URLを開発者に明示する画面を定義する。

### 本画面の処理概要

**業務上の目的・背景**：Web開発において、HTTPリダイレクト（302等）が発生するとブラウザが即座にリダイレクト先に遷移するため、リダイレクト前のレスポンスに含まれるデバッグ情報（プロファイラートークン、ヘッダー情報等）の確認が困難になる。本画面はリダイレクトを一時的にインターセプトし、開発者がリダイレクト前のプロファイルデータを確認できる機会を提供するために存在する。WebProfilerBundleの`intercept-redirects`オプションが有効な場合にのみ動作する。

**画面へのアクセス方法**：本画面は直接URLでアクセスするものではなく、WebDebugToolbarListenerがHTTPレスポンスのリダイレクトを検知した際に自動的に表示される。具体的には、`intercept-redirects: true`の設定時に、リダイレクトレスポンス（302等）がHTML形式のリクエストに対して返される場合にインターセプトされる。

**主要な操作・処理内容**：
1. リダイレクト先URLの確認 -- 画面上にリダイレクト先の絶対URLが表示される
2. リダイレクトの実行 -- 「Follow redirect」ボタンをクリックすると、元のリダイレクト先URLへ遷移する
3. プロファイラーへのアクセス -- ヘッダー部分からプロファイラーの各機能にアクセス可能

**画面遷移**：
- 遷移元：任意のページでリダイレクトレスポンスが返された場合に自動表示
- 遷移先：「Follow redirect」ボタンクリックでリダイレクト先URLへ遷移。ヘッダー部分からプロファイラーホーム、検索画面等へも遷移可能

**権限による表示制御**：本画面は開発環境（debug=true）でのみ利用可能であり、本番環境ではインターセプト機能自体が無効化される。特別なロール・権限による表示制御は行われない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | デバッグ時のリダイレクトをインターセプトしてリダイレクト先URLを表示 |
| 35 | TwigBundle | 補助機能 | Twig Environmentによるtoolbar_redirect.html.twigテンプレートのレンダリング |

## 画面種別

情報表示（リダイレクトインターセプト画面）

## URL/ルーティング

本画面は専用のルートを持たない。WebDebugToolbarListenerがリダイレクトレスポンスをインターセプトし、レスポンスのコンテンツを本画面のHTMLに置き換える。リダイレクト元のURLがそのままブラウザに表示される。

## 入出力項目

| 項目名 | 種別 | 型 | 説明 |
|--------|------|-----|------|
| location | 入力（テンプレート変数） | string | 元のリダイレクト先URL（Locationヘッダーの値） |
| host | 入力（テンプレート変数） | string | リクエスト元のスキーム＋ホスト名 |

## 表示項目

| 表示項目 | データソース | 表示形式 | 説明 |
|----------|-------------|---------|------|
| ページタイトル | 固定文字列 | テキスト | "Redirection Intercepted" |
| リダイレクト先URL | location変数（absolute_url関数で絶対URL化） | テキスト・リンク | リダイレクト先の絶対URL |
| Follow redirectボタン | location変数 | ボタン（aタグ） | クリックするとリダイレクト先に遷移 |
| ヘルプメッセージ | 固定文字列 | テキスト | リダイレクトがインターセプトされた理由の説明 |
| プロファイラーヘッダー | header.html.twigインクルード | HTML | プロファイラーのナビゲーションヘッダー |

## イベント仕様

### 1-Follow redirectボタン押下

「Follow redirect」ボタン（`<a class="btn">`タグ）をクリックすると、`absolute_url(location)`で生成された絶対URLへブラウザが遷移する。通常のHTMLリンクによる遷移であり、JavaScript処理は介在しない。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面はデータベース操作を行わない |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 情報 | "This request redirects to {URL}" | 常時表示 |
| ヘルプ | "The redirect was intercepted by the Symfony Web Debug toolbar to help debugging. For more information, see the 'intercept-redirects' option of the Profiler." | 常時表示 |

## 例外処理

本画面はWebDebugToolbarListenerにより生成されるため、画面自体の例外処理は存在しない。テンプレートレンダリング時にTwigの例外が発生した場合は、Symfonyの標準例外処理機構により処理される。

## 備考

- 本画面のレンダリングは`WebDebugToolbarListener::onKernelResponse`メソッド（109行目）で行われる
- レスポンスのステータスコードは200に変更され、Locationヘッダーが除去される
- `AutoExpireFlashBag`使用時はフラッシュメッセージが1リクエスト分延長される（110-112行目）
- CSSはテンプレート内に直接記述されている（インラインスタイル）
- テンプレートは`base.html.twig`を継承しており、プロファイラーの基本レイアウト（テーマ切替対応含む）が適用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面で扱うデータは非常にシンプルで、リダイレクト先のURL文字列のみである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | toolbar_redirect.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar_redirect.html.twig` | テンプレート変数`location`がリダイレクト先URL。`absolute_url()`Twig関数で絶対URLに変換 |

**読解のコツ**: Twigテンプレートの`{% extends %}`による継承構造に注意。`base.html.twig`が基盤テンプレート。

#### Step 2: エントリーポイントを理解する

処理の起点はEventListenerであり、コントローラーを経由しない。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | WebDebugToolbarListener.php | `src/Symfony/Bundle/WebProfilerBundle/EventListener/WebDebugToolbarListener.php` | `onKernelResponse`メソッドがエントリーポイント。109行目でリダイレクトインターセプト条件を判定 |

**主要処理フロー**:
1. **71行目**: `onKernelResponse`メソッドが`kernel.response`イベントで呼び出される
2. **87行目**: メインリクエストでない場合はリターン
3. **109行目**: リダイレクトインターセプト条件の判定（X-Debug-Tokenヘッダー存在、リダイレクトレスポンス、interceptRedirectsが有効、HTML形式、Locationヘッダー存在）
4. **115行目**: `toolbar_redirect.html.twig`をレンダリングしてレスポンスコンテンツを置換
5. **116行目**: ステータスコードを200に変更
6. **117行目**: Locationヘッダーを除去

#### Step 3: テンプレートレンダリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | toolbar_redirect.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar_redirect.html.twig` | 画面の実体。`base.html.twig`を継承し、`head`と`body`ブロックをオーバーライド |
| 3-2 | base.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/base.html.twig` | 基盤HTML構造、CSS読み込み、テーマ設定 |
| 3-3 | header.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/header.html.twig` | プロファイラー共通ヘッダー（ナビゲーション） |

### プログラム呼び出し階層図

```
kernel.response イベント
    |
    +-- WebDebugToolbarListener::onKernelResponse()  [71行目]
            |
            +-- リダイレクトインターセプト判定  [109行目]
            |
            +-- Environment::render()  [115行目]
            |       |
            |       +-- toolbar_redirect.html.twig
            |               |
            |               +-- extends base.html.twig
            |               +-- include header.html.twig
            |
            +-- Response::setContent()  [115行目]
            +-- Response::setStatusCode(200)  [116行目]
            +-- HeaderBag::remove('Location')  [117行目]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Response (302)           WebDebugToolbarListener          Response (200)
  Location: /target  --> ::onKernelResponse()          -->  Content: HTML
  X-Debug-Token: xxx                                       (toolbar_redirect.html.twig)
                              |
                              v
                     Twig::render()
                     location=/target
                     host=http://localhost
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| WebDebugToolbarListener.php | `src/Symfony/Bundle/WebProfilerBundle/EventListener/WebDebugToolbarListener.php` | ソース | リダイレクトインターセプトのロジック |
| toolbar_redirect.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar_redirect.html.twig` | テンプレート | リダイレクトインターセプト画面のHTML |
| base.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/base.html.twig` | テンプレート | プロファイラー基盤テンプレート |
| header.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/header.html.twig` | テンプレート | プロファイラーヘッダー |
| profiler.php | `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` | 設定 | ルーティング定義 |
