# 画面設計書 12-Webデバッグツールバー

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する「Webデバッグツールバー」画面の設計書である。ページ下部に表示される固定ツールバーで、リクエスト/レスポンスのサマリー情報を各コレクターから収集して表示する。

### 本画面の処理概要

**業務上の目的・背景**：Webアプリケーション開発において、リクエストごとのパフォーマンス、メモリ使用量、ルーティング情報、ログ、例外等のデバッグ情報に素早くアクセスできることは開発効率の向上に不可欠である。Webデバッグツールバーは、ページ下部に常時表示される固定バーとして、各DataCollectorが収集した情報のサマリーをコンパクトに表示し、詳細なプロファイラーパネルへのリンクを提供する。

**画面へのアクセス方法**：本画面はWebDebugToolbarListenerにより、HTMLレスポンスの`</body>`タグの前に自動的にJavaScript経由で注入される。ブラウザが`/_wdt/{token}`にAjaxリクエストを送信し、ツールバーHTMLを取得して表示する。直接`/_wdt/{token}`にアクセスすることも技術的には可能である。

**主要な操作・処理内容**：
1. ツールバーアイコンのホバー -- 各コレクターブロックにマウスをホバーすると、詳細情報がポップアップ表示される
2. プロファイラーパネルへの遷移 -- 各ブロックをクリックすると、対応するプロファイラーパネルが開く
3. ツールバーの開閉 -- トグルボタン（アクセスキー: D）でツールバーの表示/非表示を切り替え
4. Ajaxリクエストのモニタリング -- Ajaxリクエストの結果をリアルタイムで追跡・表示

**画面遷移**：
- 遷移元：任意のHTMLページ（WebDebugToolbarListenerによる自動注入）
- 遷移先：各コレクターブロッククリックでプロファイラーパネル（`_profiler`）へ遷移

**権限による表示制御**：開発環境（debug=true）でのみ表示される。WebDebugToolbarListenerの`mode`がDISABLEDの場合、XMLHttpRequest、非HTMLレスポンス、添付ファイルダウンロード時には注入されない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | ProfilerController::toolbarActionによるWebデバッグツールバーのレンダリング |
| 2 | HttpKernel | 主機能 | Profilerサービスによるプロファイルデータの読み込みとDataCollector情報の取得 |
| 35 | TwigBundle | 補助機能 | Twig Environmentによるtoolbar.html.twigテンプレートのレンダリング |
| 3 | Routing | 補助機能 | Routing（UrlGenerator）によるプロファイラーパネルへのリンクURL生成 |
| 1 | HttpFoundation | 補助機能 | Requestからのトークン取得・Session処理、Responseの生成 |

## 画面種別

ツールバー（固定表示UI）

## URL/ルーティング

| ルート名 | URL | コントローラー |
|---------|-----|--------------|
| _wdt | `/_wdt/{token}` | `web_profiler.controller.profiler::toolbarAction` |
| _wdt_stylesheet | `/_wdt/styles` | `web_profiler.controller.profiler::toolbarStylesheetAction` |

## 入出力項目

| 項目名 | 種別 | 型 | 説明 |
|--------|------|-----|------|
| token | 入力（URLパラメータ） | string/null | プロファイラートークン。nullまたは'empty'の場合は空レスポンスを返却 |
| full_stack | テンプレート変数 | bool | symfony/symfonyパッケージ使用の判定 |
| profile | テンプレート変数 | Profile | プロファイルオブジェクト |
| templates | テンプレート変数 | array | 各コレクターのテンプレート名マップ |
| profiler_url | テンプレート変数 | string/null | プロファイラーパネルの絶対URL |
| profiler_markup_version | テンプレート変数 | int | マークアップバージョン（現在: 3） |

## 表示項目

| 表示項目 | データソース | 表示形式 | 説明 |
|----------|-------------|---------|------|
| コレクターブロック群 | 各DataCollectorのtoolbarブロック | HTML（動的） | 各コレクターが定義するツールバーアイコンとサマリー |
| Full Stackワーニング | full_stack変数 | ステータスバー | symfony/symfony使用時の警告表示 |
| トグルボタン | 固定 | ボタン | ツールバー開閉ボタン（アクセスキー: D） |
| ツールバークリアラー | 固定 | div | ツールバー分のページ下部余白 |

## イベント仕様

### 1-コレクターブロックホバー

各コレクターブロック（`.sf-toolbar-block`）にマウスをホバーすると、`.sf-toolbar-info`要素がCSS `display: block`で表示される。最大幅525px、最大高さ480pxのポップアップとして詳細情報が表示される。

### 2-コレクターブロッククリック

各ブロック内のリンク（`profiler_url`を基にした`<a>`タグ）をクリックすると、プロファイラーパネル画面（`_profiler`ルート）へ遷移する。

### 3-トグルボタン押下

トグルボタンのクリックにより、ツールバーの`.sf-toolbar-opened` / `.sf-toolbar-closed`クラスが切り替わり、ツールバーの表示/非表示が切り替わる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面はデータベース操作を行わない |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 警告 | "Using symfony/symfony is NOT supported" | full_stack変数がtrueの場合 |
| 情報 | "This project is using Symfony via the 'symfony/symfony' package..." | full_stack変数がtrueの場合 |

## 例外処理

| 例外条件 | 処理 | レスポンス |
|---------|------|----------|
| profilerがnull | NotFoundHttpException発生 | 404エラー |
| tokenが'empty'またはnull | 空レスポンスを返却 | 200（空body） |
| プロファイルが見つからない | 空レスポンスを返却 | 404（空body） |
| UrlGenerator例外 | profiler_urlをnullに設定 | 正常レスポンス（URL表示なし） |

## 備考

- ツールバーはレスポンスの`</body>`タグの前にJavaScript（toolbar_js.html.twig）として注入される
- CSSはtoolbar.css.twigにより、`/_wdt/styles`から個別に読み込まれる
- CSS変数によるダークテーマのカラースキームが定義されている
- レスポンシブ対応：768pxと1024pxのブレークポイントで表示が変化
- 印刷時はツールバーが非表示になる（`@media print`）
- AutoExpireFlashBag使用時のフラッシュメッセージ延長処理あり（130-135行目）
- CSP（Content Security Policy）対応のためnonce値が処理される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | toolbarActionメソッド（124-163行目）のテンプレート変数を確認 |
| 1-2 | TemplateManager.php | `src/Symfony/Bundle/WebProfilerBundle/Profiler/TemplateManager.php` | getNames()メソッドでコレクター名とテンプレートの対応関係を理解 |

**読解のコツ**: ProfilerControllerは複数のアクションメソッドを持つが、ツールバー関連は`toolbarAction`と`toolbarStylesheetAction`のみ。

#### Step 2: エントリーポイントを理解する（注入メカニズム）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | WebDebugToolbarListener.php | `src/Symfony/Bundle/WebProfilerBundle/EventListener/WebDebugToolbarListener.php` | `injectToolbar`メソッド（157-177行目）で`</body>`前にJSが注入される仕組み |
| 2-2 | toolbar_js.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar_js.html.twig` | 注入されるJavaScriptの実体。`/_wdt/{token}`へのAjaxリクエストを発行 |

**主要処理フロー**:
1. **71行目**: `onKernelResponse`が`kernel.response`イベントで呼出し
2. **141-149行目**: ツールバー注入条件の判定
3. **151行目**: `injectToolbar`メソッド呼出し
4. **160行目**: `</body>`タグの位置を検出
5. **163-173行目**: toolbar_js.html.twigをレンダリングして注入

#### Step 3: ツールバーレンダリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | `toolbarAction`（124-163行目）: トークンからプロファイルを読み込み、テンプレート変数を構築 |
| 3-2 | toolbar.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar.html.twig` | ツールバーのHTML構造。`templates`変数をループしてコレクターのtoolbarブロックをレンダリング |
| 3-3 | toolbar.css.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar.css.twig` | ツールバーのCSS。CSS変数、レスポンシブ対応、ポップアップスタイルを定義 |

#### Step 4: ルーティングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | wdt.php | `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/wdt.php` | `_wdt`と`_wdt_stylesheet`ルートの定義 |

### プログラム呼び出し階層図

```
HTMLレスポンス生成
    |
    +-- WebDebugToolbarListener::onKernelResponse()
            |
            +-- injectToolbar()
                    |
                    +-- Twig::render(toolbar_js.html.twig)
                            |
                            [ブラウザ側]
                            +-- Ajax GET /_wdt/{token}
                                    |
                                    +-- ProfilerController::toolbarAction()
                                            |
                                            +-- Profiler::loadProfile()
                                            +-- TemplateManager::getNames()
                                            +-- Twig::render(toolbar.html.twig)
                                                    |
                                                    +-- 各コレクターのtoolbarブロック
```

### データフロー図

```
[入力]                    [処理]                         [出力]

HTMLレスポンス       WebDebugToolbarListener        HTMLレスポンス
(</body>あり)   -->  ::injectToolbar()          -->  (toolbar_js注入済み)
                          |
                    [ブラウザ側Ajax]
                          |
X-Debug-Token   -->  ProfilerController         -->  toolbar.html
                     ::toolbarAction()               (各コレクターサマリー)
                          |
                     Profiler::loadProfile()
                          |
                     TemplateManager::getNames()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | ソース | toolbarAction, toolbarStylesheetActionメソッド |
| WebDebugToolbarListener.php | `src/Symfony/Bundle/WebProfilerBundle/EventListener/WebDebugToolbarListener.php` | ソース | ツールバー注入ロジック |
| TemplateManager.php | `src/Symfony/Bundle/WebProfilerBundle/Profiler/TemplateManager.php` | ソース | コレクターテンプレート管理 |
| toolbar.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar.html.twig` | テンプレート | ツールバーHTML構造 |
| toolbar.css.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar.css.twig` | テンプレート | ツールバーCSS |
| toolbar_js.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar_js.html.twig` | テンプレート | ツールバー注入JavaScript |
| toolbar_item.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar_item.html.twig` | テンプレート | コレクターブロック共通テンプレート |
| wdt.php | `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/wdt.php` | 設定 | ルーティング定義 |
