# 画面設計書 13-ツールバースタイルシート

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する「ツールバースタイルシート」画面の設計書である。Webデバッグツールバー用のCSSスタイルシートを動的に生成して配信するエンドポイントを定義する。

### 本画面の処理概要

**業務上の目的・背景**：Webデバッグツールバーのスタイル（配色、レイアウト、レスポンシブ対応等）をTwigテンプレートによる動的CSSとして管理し、プロファイラーの設定やテーマに応じたスタイルを配信する。CSSをTwigテンプレートで管理することで、Symfonyのテンプレート機構と統合されたスタイル管理が可能になる。このエンドポイントは通常ユーザーが直接アクセスするものではなく、ツールバーの注入JavaScriptが自動的にスタイルシートとして読み込む。

**画面へのアクセス方法**：ブラウザがツールバーのJavaScriptを実行する際に、`/_wdt/styles`URLから自動的にCSSスタイルシートが読み込まれる。Content-Typeは`text/css`で、Cache-Controlは`max-age=600, private`が設定される。

**主要な操作・処理内容**：
1. CSSスタイルシートの生成 -- Twigテンプレート`toolbar.css.twig`をレンダリングしてCSS出力
2. キャッシュヘッダーの設定 -- max-age=600（10分間）のキャッシュ制御

**画面遷移**：
- 遷移元：Webデバッグツールバーの自動読み込み
- 遷移先：なし（CSSリソースのため画面遷移は発生しない）

**権限による表示制御**：プロファイラーが無効の場合はNotFoundHttpExceptionが発生する。開発環境でのみ利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | ProfilerController::toolbarStylesheetActionによるCSSスタイルシートの出力 |
| 35 | TwigBundle | 補助機能 | Twig Environmentによるtoolbar.css.twigテンプレートのレンダリング |

## 画面種別

リソース配信（CSSスタイルシート）

## URL/ルーティング

| ルート名 | URL | コントローラー |
|---------|-----|--------------|
| _wdt_stylesheet | `/_wdt/styles` | `web_profiler.controller.profiler::toolbarStylesheetAction` |

## 入出力項目

| 項目名 | 種別 | 型 | 説明 |
|--------|------|-----|------|
| - | - | - | 入力パラメータなし |

## 表示項目

本画面はCSSスタイルシートを出力するため、視覚的な表示項目はなく、CSSルールセットが出力される。主な内容は以下の通り。

| CSS定義 | 説明 |
|---------|------|
| CSS変数定義 | フォントファミリ、カラーパレット（グレー/赤/黄/緑系統） |
| .sf-toolbarreset | ツールバー本体のスタイル（position: fixed, bottom: 0） |
| .sf-toolbar-block | コレクターブロックのスタイル（float, height: 36px） |
| .sf-toolbar-icon | ブロックアイコンのスタイル |
| .sf-toolbar-info | ポップアップ情報のスタイル（z-index: 100000） |
| .sf-toolbar-status | ステータスバッジのスタイル（green/red/yellow） |
| .sf-toolbar-toggle-button | 開閉ボタンのスタイル |
| レスポンシブ対応 | @media (min-width: 768px), @media (min-width: 1024px) |
| 印刷対応 | @media print { .sf-toolbar { display: none } } |
| エラーツールバー | .sf-error-toolbar のスタイル |

## イベント仕様

本画面はCSSリソースの配信であるため、ユーザーイベントは発生しない。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面はデータベース操作を行わない |

## メッセージ仕様

本画面はCSSリソースであるため、メッセージ表示は行わない。

## 例外処理

| 例外条件 | 処理 | レスポンス |
|---------|------|----------|
| profilerがnull | NotFoundHttpException発生 | 404エラー |

## 備考

- Cache-Controlヘッダーは`max-age=600, private`で設定される（10分間のブラウザキャッシュ）
- CSP（Content Security Policy）はこのアクション内で無効化される（174行目）
- CSS変数を用いたデザインシステムにより、ダークテーマのような視覚的カスタマイズが容易
- ツールバーの高さは36px固定で、z-indexは99999

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面は入力データを必要としないCSSリソース配信であるため、データ構造の理解は最小限でよい。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | toolbar.css.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar.css.twig` | CSS変数の定義（1-47行目）とスタイルルールの全体構造 |

**読解のコツ**: Twigテンプレートだが、内容はほぼ純粋なCSS。Twig構文が含まれる可能性はあるが、現在のバージョンでは静的CSS。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | `toolbarStylesheetAction`メソッド（170-184行目）。テンプレートのレンダリングとレスポンスヘッダーの設定 |

**主要処理フロー**:
1. **172行目**: `denyAccessIfProfilerDisabled()`でプロファイラー有効確認
2. **174行目**: CSPハンドラーによるCSP無効化
3. **176-184行目**: toolbar.css.twigをレンダリングし、Content-Type: text/css、Cache-Control: max-age=600で返却

#### Step 3: ルーティングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | wdt.php | `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/wdt.php` | `_wdt_stylesheet`ルート定義（15-17行目） |

### プログラム呼び出し階層図

```
GET /_wdt/styles
    |
    +-- ProfilerController::toolbarStylesheetAction()  [170行目]
            |
            +-- denyAccessIfProfilerDisabled()  [172行目]
            |
            +-- cspHandler->disableCsp()  [174行目]
            |
            +-- Environment::render('toolbar.css.twig')  [177行目]
            |
            +-- new Response(css, 200, headers)  [176-184行目]
```

### データフロー図

```
[入力]              [処理]                         [出力]

GET /_wdt/styles --> ProfilerController          --> Response
                     ::toolbarStylesheetAction()      Content-Type: text/css
                          |                           Cache-Control: max-age=600
                          v
                     Twig::render()
                     (toolbar.css.twig)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | ソース | toolbarStylesheetActionメソッド |
| toolbar.css.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar.css.twig` | テンプレート | CSS定義本体 |
| wdt.php | `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/wdt.php` | 設定 | ルーティング定義 |
