# 画面設計書 14-リクエスト情報パネル

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する「リクエスト情報パネル」画面の設計書である。HTTPリクエスト/レスポンスの詳細情報（ヘッダー、パラメータ、Cookie、セッション等）を表示するプロファイラーのコレクターパネルを定義する。

### 本画面の処理概要

**業務上の目的・背景**：Web開発において、HTTPリクエストとレスポンスの内容を詳細に確認することは、APIのデバッグ、認証問題の調査、パラメータの検証等に不可欠である。本パネルは、RequestDataCollectorが収集したHTTPリクエスト/レスポンスの全情報を構造化して表示し、開発者が通信内容を効率的にデバッグできるようにする。

**画面へのアクセス方法**：プロファイラーパネル画面（`/_profiler/{token}`）の左サイドメニューから「Request / Response」を選択、またはWebデバッグツールバーのHTTPステータスコード表示部分をクリックしてアクセスする。

**主要な操作・処理内容**：
1. リクエスト情報の確認 -- GET/POSTパラメータ、アップロードファイル、リクエスト属性、ヘッダー、リクエストコンテンツの表示
2. レスポンス情報の確認 -- レスポンスヘッダーの表示
3. Cookie情報の確認 -- リクエスト/レスポンスCookieの表示
4. セッション情報の確認 -- セッションメタデータ、属性、使用状況（トレース付き）の表示
5. フラッシュメッセージの確認 -- フラッシュメッセージの表示
6. サーバーパラメータの確認 -- .env定義変数と通常環境変数の表示
7. 親リクエスト/サブリクエストの確認 -- リクエスト階層の表示

**画面遷移**：
- 遷移元：プロファイラーパネル（_profiler）のメニュー選択、Webデバッグツールバーからのクリック
- 遷移先：リダイレクト元プロファイル、フォワード先プロファイル、親リクエストプロファイル、サブリクエストプロファイルへのリンク

**権限による表示制御**：開発環境でのみ利用可能。ロール・権限による差異はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | HTTPリクエスト/レスポンスの詳細情報を表示するコレクターパネル |
| 2 | HttpKernel | 主機能 | RequestDataCollectorによるHTTPリクエスト/レスポンス情報の収集・表示 |
| 1 | HttpFoundation | 補助機能 | Request/Responseオブジェクトの詳細データ（ヘッダー、クエリ、Cookie等）の表示 |

## 画面種別

詳細（コレクターパネル）

## URL/ルーティング

| ルート名 | URL | コントローラー |
|---------|-----|--------------|
| _profiler | `/_profiler/{token}?panel=request` | `web_profiler.controller.profiler::panelAction` |

## 入出力項目

| 項目名 | 種別 | 型 | 説明 |
|--------|------|-----|------|
| token | 入力（URLパラメータ） | string | プロファイラートークン |
| panel | 入力（クエリパラメータ） | string | "request"固定 |
| collector | テンプレート変数 | RequestDataCollector | リクエスト情報コレクター |
| profile | テンプレート変数 | Profile | プロファイルオブジェクト |

## 表示項目

### ツールバーブロック表示

| 表示項目 | データソース | 表示形式 | 説明 |
|----------|-------------|---------|------|
| HTTPステータスコード | collector.statuscode | バッジ（色分け） | 400以上=赤、300以上=黄、その他=緑 |
| HTTPメソッド | collector.method | テキスト | GET以外の場合に表示 |
| ルート名 | collector.route | テキスト | マッチしたルート名 |
| リダイレクトアイコン | collector.redirect | SVGアイコン | リダイレクトがあった場合に表示 |
| フォワードアイコン | collector.forwardtoken | SVGアイコン | フォワードがあった場合に表示 |

### パネル表示（タブ構成）

| タブ名 | 表示内容 | 表示条件 |
|--------|---------|---------|
| Request | GETパラメータ、POSTパラメータ、アップロードファイル、リクエスト属性、リクエストヘッダー、リクエストコンテンツ | 常時 |
| Response | レスポンスヘッダー | 常時 |
| Cookies | リクエストCookie、レスポンスCookie | Cookie存在時のみタブ有効 |
| Session | セッションメタデータ、セッション属性、セッション使用状況 | セッション存在時のみタブ有効 |
| Flashes | フラッシュメッセージ | フラッシュ存在時のみタブ有効 |
| Server Parameters | .env定義変数、通常環境変数 | 常時 |
| Parent Request | 親リクエストの属性 | 親リクエスト存在時 |
| Sub Requests | サブリクエストの属性（複数） | サブリクエスト存在時 |

## イベント仕様

### 1-タブ切り替え

タブナビゲーションの各タブをクリックすると、対応するタブコンテンツが表示される。sf-tabsクラスによるCSS/JavaScriptベースのタブ切り替え。

### 2-セッション使用状況のトレース表示

「Show trace」ボタンをクリックすると、`sf-toggle`によりセッション使用箇所のスタックトレースが展開表示される。「Hide trace」で折りたたみ可能。

### 3-リクエストコンテンツのPretty/Raw切り替え

JSONリクエストの場合、PrettyタブとRawタブでフォーマット済み/生のリクエストコンテンツを切り替え表示できる。

### 4-プロファイルリンクの遷移

リダイレクト元トークン、フォワード先トークン、親リクエストトークン、サブリクエストトークンへのリンクをクリックすると、対応するプロファイルのパネル画面に遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面はデータベース操作を行わない（プロファイルストレージからの読み取りのみ） |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 情報 | "None" | GET/POST/ファイルが空の場合 |
| 情報 | "No GET parameters" | GETパラメータが空の場合 |
| 情報 | "No POST parameters" | POSTパラメータが空の場合 |
| 情報 | "No files were uploaded" | アップロードファイルがない場合 |
| 情報 | "No attributes" | リクエスト属性がない場合 |
| 情報 | "Request content not available (it was retrieved as a resource)." | コンテンツがリソースとして取得された場合 |
| 情報 | "No content" | リクエストコンテンツがない場合 |
| 情報 | "No request cookies" / "No response cookies" | Cookieがない場合 |
| 情報 | "No session metadata" / "No session attributes" | セッション情報がない場合 |
| 情報 | "Session not used." | セッション使用がない場合 |
| 情報 | "No flash messages were created." | フラッシュメッセージがない場合 |

## 例外処理

プロファイラーパネル共通の例外処理（ProfilerController::panelAction）に準ずる。パネル固有の例外処理はない。

## 備考

- マクロ`set_handler`でコントローラー情報をフォーマットして表示する（414-431行目）
- JSONリクエスト時はPretty JSON表示機能あり（209-219行目）
- Stateless Check機能により、セッション使用のステートレスチェック結果が表示される
- bag.html.twigインクルードでパラメータバッグの一覧表示を統一的に行う
- table.html.twigインクルードでkey-value形式のデータ表示を統一的に行う

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | request.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/request.html.twig` | テンプレートで使用されるcollector変数のプロパティ群（statuscode, method, route, requestquery等） |

**読解のコツ**: テンプレート内の`collector.`プレフィックスのプロパティはすべてRequestDataCollectorのゲッターに対応する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | `panelAction`メソッド（65-117行目）でプロファイルを読み込み、テンプレートをレンダリング |

**主要処理フロー**:
1. **67行目**: プロファイラー有効確認
2. **75-77行目**: `latest`トークンの処理
3. **79-80行目**: プロファイルの読み込み（存在しない場合はinfo画面表示）
4. **85-98行目**: デフォルトパネルの決定（例外 > dump > リクエスト）
5. **105-117行目**: テンプレートのレンダリング

#### Step 3: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | request.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/request.html.twig` | `toolbar`ブロック（26-120行目）: ツールバー表示、`menu`ブロック（122-127行目）: メニュー表示、`panel`ブロック（129-412行目）: パネル本体 |
| 3-2 | layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | パネル共通レイアウト |
| 3-3 | bag.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/bag.html.twig` | パラメータバッグ表示コンポーネント |
| 3-4 | table.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/table.html.twig` | テーブル表示コンポーネント |

### プログラム呼び出し階層図

```
GET /_profiler/{token}?panel=request
    |
    +-- ProfilerController::panelAction()  [65行目]
            |
            +-- Profiler::loadProfile()  [79行目]
            |
            +-- TemplateManager::getName()  [105行目]
            |
            +-- Twig::render(request.html.twig)
                    |
                    +-- extends layout.html.twig
                    |       +-- extends base.html.twig
                    |
                    +-- include bag.html.twig  [164, 174等]
                    +-- include table.html.twig  [285, 295等]
                    +-- macro set_handler()  [414行目]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

token (URL)          ProfilerController              request.html.twig
panel=request   -->  ::panelAction()             -->  (タブ構成パネル)
                          |
                     Profiler::loadProfile()
                          |
                     Profile::getCollector('request')
                          |
                     RequestDataCollector
                     - statuscode, method, route
                     - requestquery, requestrequest
                     - requestheaders, responseheaders
                     - requestcookies, responsecookies
                     - sessionmetadata, sessionattributes
                     - flashes, dotenvvars
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | ソース | panelActionメソッド |
| request.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/request.html.twig` | テンプレート | リクエスト情報パネルのHTML |
| layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | テンプレート | パネル共通レイアウト |
| bag.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/bag.html.twig` | テンプレート | パラメータバッグ表示 |
| table.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/table.html.twig` | テンプレート | テーブル表示 |
| profiler.php | `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` | 設定 | ルーティング定義 |
