# 画面設計書 16-パフォーマンス（時間）パネル

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する「パフォーマンス（時間）パネル」画面の設計書である。リクエスト処理時間のタイムライン・パフォーマンス情報を表示するプロファイラーのコレクターパネルを定義する。

### 本画面の処理概要

**業務上の目的・背景**：Webアプリケーションのパフォーマンスチューニングにおいて、リクエスト処理の各フェーズでの所要時間を可視化することは極めて重要である。本パネルは、Stopwatchコンポーネントによって計測された実行時間データをタイムライン形式で視覚化し、ボトルネックとなっている処理を特定する手助けを提供する。初期化時間、合計実行時間、メモリ使用量、サブリクエスト時間等の主要メトリクスを一目で確認できる。

**画面へのアクセス方法**：プロファイラーパネル画面の左サイドメニューから「Performance」を選択、またはWebデバッグツールバーの時間表示部分をクリックしてアクセスする。

**主要な操作・処理内容**：
1. パフォーマンスメトリクスの確認 -- 合計実行時間、Symfony初期化時間、ピークメモリ使用量、サブリクエスト数とその合計時間
2. タイムラインの閲覧 -- SVGベースのインタラクティブなタイムライングラフで各イベントの開始・終了時間と持続時間を視覚化
3. しきい値フィルタリング -- テキストフィールドで最小表示時間（ミリ秒）を指定し、短時間のイベントをフィルタリング
4. カテゴリ別レジェンド -- イベントカテゴリ別のレジェンドで表示/非表示を切り替え
5. サブリクエストのタイムライン確認 -- 各サブリクエストのタイムラインを個別に表示

**画面遷移**：
- 遷移元：プロファイラーパネルのメニュー選択、Webデバッグツールバーの時間表示クリック
- 遷移先：サブリクエストプロファイルのtimeパネルへのリンク、親リクエストのtimeパネルへのリンク

**権限による表示制御**：開発環境でのみ利用可能。特別な権限制御はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | リクエスト処理時間のタイムライン・パフォーマンス情報の表示 |
| 46 | Stopwatch | 主機能 | Stopwatchコンポーネントで計測した実行時間データの表示 |
| 2 | HttpKernel | 補助機能 | TimeDataCollectorによるパフォーマンスデータの収集 |

## 画面種別

詳細（コレクターパネル）

## URL/ルーティング

| ルート名 | URL | コントローラー |
|---------|-----|--------------|
| _profiler | `/_profiler/{token}?panel=time` | `web_profiler.controller.profiler::panelAction` |

## 入出力項目

| 項目名 | 種別 | 型 | 説明 |
|--------|------|-----|------|
| token | 入力（URLパラメータ） | string | プロファイラートークン |
| panel | 入力（クエリパラメータ） | string | "time"固定 |
| threshold | 入力（クエリパラメータ） | number | タイムライン表示の最小時間しきい値（ms）。デフォルト1 |
| collector | テンプレート変数 | TimeDataCollector | 時間データコレクター |
| profile | テンプレート変数 | Profile | プロファイルオブジェクト |

## 表示項目

### ツールバーブロック表示

| 表示項目 | データソース | 表示形式 | 説明 |
|----------|-------------|---------|------|
| 合計時間 | collector.duration | テキスト | "xxx ms"形式 |
| ステータス色 | collector.duration | CSS色 | 1000ms超=yellow、それ以外=なし |

### パネル表示

| 表示項目 | データソース | 表示形式 | 説明 |
|----------|-------------|---------|------|
| Total execution time | collector.duration | メトリクス | ミリ秒単位 |
| Symfony initialization | collector.inittime | メトリクス | ミリ秒単位 |
| Peak memory usage | profile.collectors.memory.memory | メトリクス | MiB単位（memoryコレクター存在時） |
| サブリクエスト数 | profile.children.length | メトリクス | サブリクエスト存在時 |
| サブリクエスト合計時間 | profile.childrenのtime計算 | メトリクス | サブリクエスト存在時 |
| しきい値入力フォーム | threshold | input[type=number] | デフォルト1ms |
| タイムラインSVG | collector.events | SVGグラフ | JavaScript（TimelineEngine）によるインタラクティブ描画 |
| レジェンド | イベントカテゴリ | ボタン群 | カテゴリ別の表示切替 |
| サブリクエスト別タイムライン | profile.children | SVGグラフ群 | 各サブリクエストのタイムライン |

## イベント仕様

### 1-しきい値変更

しきい値入力フィールド（`#threshold`）の値を変更すると、タイムラインが再描画され、指定ミリ秒未満のイベントが非表示になる。

### 2-レジェンドクリック

レジェンドのカテゴリボタンをクリックすると、そのカテゴリのイベントの表示/非表示が切り替わる。

### 3-サブリクエストリンククリック

サブリクエストのリンクをクリックすると、そのサブリクエストのプロファイラーtimeパネルに遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面はデータベース操作を行わない |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 情報 | "The Stopwatch component is not installed..." | Stopwatchが未インストールの場合 |
| 情報 | "No timing events have been recorded..." | タイミングイベントが空の場合 |
| ヘルプ | "Note: sections with a striped background correspond to sub-requests." | サブリクエスト存在時 |
| ヘルプ | "(timeline only displays events with a duration longer than this threshold)" | しきい値入力欄の横 |

## 例外処理

プロファイラーパネル共通の例外処理に準ずる。パネル固有の例外処理はない。

## 備考

- タイムラインはSVGとJavaScript（time.js）で描画される（187-188行目）
- タイムラインのデータはTwigマクロ`dump_request_data`でJSON形式に変換される（191-200行目）
- サブリクエスト部分はストライプ背景パターン（SVG pattern）で区別される（176-182行目）
- CSSは`time.css.twig`でインクルードされる
- profiler_markup_versionは3（Symfony 6.2+）
- サブリクエスト存在時、親リクエストへの「Return to parent request」リンクが表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | time.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/time.html.twig` | collector変数のプロパティ（duration, inittime, events）とevent構造（name, category, origin, starttime, endtime, duration, memory, periods） |

**読解のコツ**: `dump_events`マクロ（202-229行目）を読むとイベントのデータ構造が明確になる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | panelAction共通処理 |

#### Step 3: テンプレート構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | time.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/time.html.twig` | `toolbar`ブロック（41-65行目）、`menu`ブロック（67-72行目）、`panel`ブロック（74-134行目）、`panelContent`ブロック（136-189行目） |

**主要処理フロー**:
- **74-134行目**: パフォーマンスメトリクス表示とStopwatch確認
- **136-189行目**: タイムラインコントロール、メイン/サブリクエストのタイムライン描画
- **191-249行目**: Twigマクロ（dump_request_data, dump_events, display_timeline）でJSデータ生成とSVG描画

### プログラム呼び出し階層図

```
GET /_profiler/{token}?panel=time
    |
    +-- ProfilerController::panelAction()
            |
            +-- Twig::render(time.html.twig)
                    |
                    +-- extends layout.html.twig
                    |
                    +-- panelContent ブロック
                    |       +-- display_timeline マクロ
                    |               +-- dump_request_data マクロ
                    |               +-- dump_events マクロ
                    |               +-- JavaScript: TimelineEngine
                    |               +-- JavaScript: SvgRenderer
                    |               +-- JavaScript: Legend
                    |
                    +-- include time.css.twig
                    +-- source time.js
```

### データフロー図

```
[入力]                    [処理]                         [出力]

token (URL)          ProfilerController              time.html.twig
panel=time      -->  ::panelAction()             -->  (パフォーマンスパネル)
                          |
                     TimeDataCollector
                     - duration (ms)
                     - inittime (ms)
                     - events (StopwatchEvent[])
                          |
                     TwigマクロでイベントデータをJSON変換
                          |
                     TimelineEngine (JavaScript)
                          |
                     SVGタイムライン描画
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | ソース | panelActionメソッド |
| time.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/time.html.twig` | テンプレート | パフォーマンスパネルHTML・JS |
| time.css.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/time.css.twig` | テンプレート | タイムラインCSS |
| layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | テンプレート | パネル共通レイアウト |
