# 画面設計書 17-メモリ使用量パネル

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する「メモリ使用量パネル」画面の設計書である。リクエスト処理中のメモリ使用量情報を表示するプロファイラーのコレクターパネルを定義する。

### 本画面の処理概要

**業務上の目的・背景**：Webアプリケーションのメモリ消費量を監視することは、メモリリークの検出やパフォーマンス最適化において重要である。本パネルは、MemoryDataCollectorが収集したピークメモリ使用量とPHPのメモリ制限値を表示し、メモリ使用状況を開発者にフィードバックする。パネルは主にツールバーブロックとしての役割を持ち、独自のパネル表示は持たない。

**画面へのアクセス方法**：Webデバッグツールバーのメモリ表示部分（"xx.x MiB"）にマウスをホバーすると、ポップアップでメモリ詳細が表示される。専用のプロファイラーパネルは定義されておらず、ツールバーブロックのみの表示。

**主要な操作・処理内容**：
1. ピークメモリ使用量の確認 -- ツールバーにMiB単位でピークメモリ使用量を表示
2. メモリ制限の確認 -- ポップアップでPHPのメモリ制限値を表示

**画面遷移**：
- 遷移元：Webデバッグツールバーの表示
- 遷移先：ツールバーブロッククリックでtimeパネルへのリンク（name: 'time'指定）

**権限による表示制御**：開発環境でのみ利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | メモリ使用量情報の表示パネル |
| 2 | HttpKernel | 補助機能 | MemoryDataCollectorによるメモリ使用量データの収集 |

## 画面種別

ツールバーブロック（メトリクス表示）

## URL/ルーティング

独自のルーティングは持たない。ツールバーの一部として`/_wdt/{token}`内で表示される。ツールバーブロッククリック時はtimeパネル（`/_profiler/{token}?panel=time`）にリンクされる。

## 入出力項目

| 項目名 | 種別 | 型 | 説明 |
|--------|------|-----|------|
| collector | テンプレート変数 | MemoryDataCollector | メモリデータコレクター |
| profiler_url | テンプレート変数 | string | プロファイラーパネルURL |

## 表示項目

### ツールバーブロック表示

| 表示項目 | データソース | 表示形式 | 説明 |
|----------|-------------|---------|------|
| メモリアイコン | SVG | アイコン | メモリアイコン（memory.svg） |
| ピークメモリ使用量 | collector.memory | テキスト | "xx.x MiB"形式（小数第1位） |
| ステータス色 | collector.memory | CSS色 | 50MiB超=yellow |

### ツールバーポップアップ表示

| 表示項目 | データソース | 表示形式 | 説明 |
|----------|-------------|---------|------|
| Peak memory usage | collector.memory | テキスト | "xx.x MiB"形式 |
| PHP memory limit | collector.memoryLimit | テキスト | MiB形式、-1の場合は"Unlimited" |

## イベント仕様

### 1-ツールバーブロックホバー

メモリブロックにマウスをホバーすると、ピークメモリ使用量とPHPメモリ制限のポップアップが表示される。

### 2-ツールバーブロッククリック

ブロッククリックでtimeパネルに遷移する（`link: profiler_url, name: 'time'`が指定されているため）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面はデータベース操作を行わない |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| - | "Unlimited" | メモリ制限が-1（無制限）の場合 |

## 例外処理

ツールバーブロックとしての表示であり、固有の例外処理はない。

## 備考

- memory.html.twigはtoolbarブロックのみを定義し、menuブロックとpanelブロックは定義していない
- toolbar_item.html.twigのインクルード時に`name: 'time'`を指定しているため、クリック先はtimeパネルになる
- ステータス色の閾値は50MiB（5行目）
- メモリ値はバイトからMiB（1024*1024）に変換して表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | memory.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/memory.html.twig` | collector.memoryとcollector.memoryLimitの2つのプロパティ |

**読解のコツ**: テンプレートは25行と非常にシンプル。toolbarブロックのみで完結。

#### Step 2: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | memory.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/memory.html.twig` | `toolbar`ブロック（3-24行目）: アイコン部分（4-9行目）とテキスト部分（11-21行目） |

**主要処理フロー**:
- **5行目**: ステータス色判定（50MiB超でyellow）
- **7行目**: メモリ値のMiB変換（/ 1024 / 1024、小数第1位）
- **19行目**: メモリ制限の表示（-1ならUnlimited、それ以外はMiB変換）
- **23行目**: toolbar_item.html.twigインクルード（link: profiler_url, name: 'time'）

### プログラム呼び出し階層図

```
/_wdt/{token} ツールバーレンダリング
    |
    +-- toolbar.html.twig
            |
            +-- memory.html.twig の toolbarブロック
                    |
                    +-- collector.memory (ピーク使用量)
                    +-- collector.memoryLimit (制限値)
                    +-- include toolbar_item.html.twig
```

### データフロー図

```
[入力]                    [処理]                         [出力]

MemoryDataCollector  --> memory.html.twig           --> ツールバーブロック
  .memory (bytes)        (MiB変換・表示)                  (アイコン+値)
  .memoryLimit (bytes)   (制限値表示)                     (ポップアップ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| memory.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/memory.html.twig` | テンプレート | メモリ使用量ツールバーブロック |
| toolbar_item.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar_item.html.twig` | テンプレート | ツールバーアイテム共通テンプレート |
| layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | テンプレート | パネル共通レイアウト |
