# 画面設計書 18-ログパネル

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する「ログパネル」画面の設計書である。リクエスト処理中に記録されたログメッセージの一覧を表示するプロファイラーのコレクターパネルを定義する。

### 本画面の処理概要

**業務上の目的・背景**：アプリケーションのデバッグにおいて、ログメッセージの確認は最も基本的で重要な手段である。本パネルは、LoggerDataCollectorおよびMonolog Bridgeを通じて収集されたログメッセージを、タイプ別（エラー/非推奨/全体）、優先度別、チャネル別にフィルタリングしながら閲覧する機能を提供する。エラーや非推奨ログを優先表示することで、問題の早期発見を支援する。

**画面へのアクセス方法**：プロファイラーパネル画面の左サイドメニューから「Logs」を選択、またはWebデバッグツールバーのログアイコン部分をクリックしてアクセスする。

**主要な操作・処理内容**：
1. ログタイプのフィルタリング -- タブ切替で全メッセージ/エラー/非推奨を選択
2. 優先度フィルタリング -- ドロップダウンでログレベル（DEBUG/INFO/WARNING/ERROR等）の表示/非表示を切替
3. チャネルフィルタリング -- ドロップダウンでログチャネル（app/doctrine/event等）の表示/非表示を切替
4. コンテキストの確認 -- 各ログメッセージの「Show context」ボタンでコンテキスト情報を展開表示
5. トレースの確認 -- 例外ログの「Show trace」ボタンでスタックトレースを展開表示
6. コンテナコンパイルログの確認 -- 折りたたみセクションでサービスコンテナコンパイル時のログを確認

**画面遷移**：
- 遷移元：プロファイラーパネルのメニュー選択、ツールバーのログアイコンクリック
- 遷移先：プロファイラーの他パネルへの遷移

**権限による表示制御**：開発環境でのみ利用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | ログメッセージの一覧を表示するパネル |
| 66 | Monolog Bridge | 主機能 | MonologBridgeを通じて収集されたログデータの表示 |
| 2 | HttpKernel | 補助機能 | LoggerDataCollectorによるログデータの収集 |

## 画面種別

一覧（コレクターパネル・フィルタ付きテーブル）

## URL/ルーティング

| ルート名 | URL | コントローラー |
|---------|-----|--------------|
| _profiler | `/_profiler/{token}?panel=logger` | `web_profiler.controller.profiler::panelAction` |

## 入出力項目

| 項目名 | 種別 | 型 | 説明 |
|--------|------|-----|------|
| token | 入力（URLパラメータ） | string | プロファイラートークン |
| panel | 入力（クエリパラメータ） | string | "logger"固定 |
| collector | テンプレート変数 | LoggerDataCollector | ログデータコレクター |

## 表示項目

### ツールバーブロック表示

| 表示項目 | データソース | 表示形式 | 説明 |
|----------|-------------|---------|------|
| ログアイコン | SVG | アイコン | logger.svg |
| エラー/警告/非推奨カウント | collector.counterrors, countwarnings, countdeprecations | テキスト | エラーがあればエラー数、なければ警告+非推奨数 |
| ステータス色 | collector.counterrors/countwarnings | CSS色 | エラーあり=red、警告あり=yellow |
| Errors | collector.counterrors | ステータスバッジ | エラー数 |
| Warnings | collector.countwarnings | ステータスバッジ | 警告数 |
| Deprecations | collector.countdeprecations | ステータスバッジ | 非推奨数 |

### パネル表示

| 表示項目 | データソース | 表示形式 | 説明 |
|----------|-------------|---------|------|
| タイプフィルタ（ラジオボタンタブ） | collector.processedLogs | タブ | All messages / Errors / Deprecations |
| 優先度フィルタ | collector.filters.priority | チェックボックスドロップダウン | DEBUGはデフォルト非表示 |
| チャネルフィルタ | collector.filters.channel | チェックボックスドロップダウン | eventチャネルはデフォルト非表示 |
| ログテーブル | collector.processedLogs | テーブル | 時刻、メッセージ、チャネル、ログタイプバッジ |
| ログコンテキスト | log.context | 展開パネル | profiler_dumpによるダンプ表示 |
| ログトレース | log.context.exception.trace | 展開パネル | 例外トレースダンプ |
| コンテナコンパイルログ | collector.compilerLogs | 折りたたみテーブル | クラス別のコンパイルログ |

## イベント仕様

### 1-タイプフィルタ切替

ラジオボタンタブ（All messages / Errors / Deprecations）をクリックすると、`SymfonyProfilerLoggerPanel`クラスの`#updateLogsTable()`メソッドが呼び出され、テーブル行のdata-type属性に基づいてフィルタリングされる。

### 2-優先度フィルタ変更

優先度フィルタのチェックボックスを変更すると、対応するログレベルの行がdata-priority属性に基づいて表示/非表示される。Select All / Select Noneボタンで一括操作も可能。

### 3-チャネルフィルタ変更

チャネルフィルタのチェックボックスを変更すると、対応するチャネルの行がdata-channel属性に基づいて表示/非表示される。

### 4-コンテキスト/トレース展開

「Show context」「Show trace」ボタンをクリックすると、`sf-toggle`機構により対応するコンテンツが展開/折りたたみされる。

### 5-コンテナコンパイルログの展開

`<details>`要素のクリックでコンテナコンパイルログのセクションが展開される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面はデータベース操作を行わない |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 情報 | "No log messages available." | ログメッセージがない場合 |
| 情報 | "There are no log messages." | フィルタ後にログが0件の場合 |
| 情報 | "There are no compiler log messages." | コンパイルログがない場合 |

## 例外処理

プロファイラーパネル共通の例外処理に準ずる。

## 備考

- フィルタリングはJavaScript（SymfonyProfilerLoggerPanel クラス）によりクライアントサイドで実行される
- DEBUGログとeventチャネルはデフォルトで非表示（初期フィルタ設定）
- エラーログがある場合はErrorsタブが、非推奨ログがある場合はDeprecationsタブが初期選択される
- ログテーブルの各行にはdata-type、data-priority、data-channel属性が設定されフィルタの基準として使用
- タイムスタンプはdata-convert-to-user-timezone, data-render-as-time属性でクライアント側でのタイムゾーン変換対応
- render_log_messageマクロ（540-581行目）でログメッセージのフォーマットを処理

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | logger.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/logger.html.twig` | collector.processedLogs配列の構造（type, priority, priorityName, channel, message, context, timestamp, errorCount） |

**読解のコツ**: `processedLogs`はフラット化された処理済みログ配列。各ログのtypeは'error', 'deprecation', 'silenced'等のいずれか。

#### Step 2: テンプレート構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | logger.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/logger.html.twig` | `stylesheets`ブロック（3-236行目）: 大量のCSS定義、`javascripts`ブロック（238-321行目）: SymfonyProfilerLoggerPanel JSクラス、`toolbar`ブロック（323-350行目）、`menu`ブロック（352-362行目）、`panel`ブロック（364-538行目） |

**主要処理フロー**:
- **364-538行目**: パネル本体。フィルタUI（376-440行目）、ログテーブル（442-488行目）、コンパイルログ（495-537行目）
- **244-318行目**: JavaScriptフィルタロジック（#updateLogsTable メソッド）
- **540-581行目**: render_log_messageマクロ

### プログラム呼び出し階層図

```
GET /_profiler/{token}?panel=logger
    |
    +-- ProfilerController::panelAction()
            |
            +-- Twig::render(logger.html.twig)
                    |
                    +-- extends layout.html.twig
                    |
                    +-- panel ブロック
                    |       +-- フィルタUI（タイプ/優先度/チャネル）
                    |       +-- ログテーブル
                    |       |       +-- macro render_log_message()
                    |       |               +-- profiler_dump_log()
                    |       |               +-- profiler_dump()
                    |       +-- コンテナコンパイルログ
                    |
                    +-- javascripts ブロック
                            +-- SymfonyProfilerLoggerPanel
                                    +-- #updateLogsTable()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

token (URL)          ProfilerController              logger.html.twig
panel=logger    -->  ::panelAction()             -->  (ログパネル)
                          |
                     LoggerDataCollector
                     - processedLogs[]
                     - counterrors
                     - countwarnings
                     - countdeprecations
                     - filters (priority, channel)
                     - compilerLogs
                          |
                     Twigテンプレートレンダリング
                          |
                     JavaScriptフィルタリング（クライアント側）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | ソース | panelActionメソッド |
| logger.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/logger.html.twig` | テンプレート | ログパネルHTML/CSS/JS |
| layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | テンプレート | パネル共通レイアウト |
