# 画面設計書 21-ルーター詳細パネル

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する「ルーター詳細パネル」画面の設計書である。URLマッチングのトレース詳細を表示するプロファイラーパネルの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：Symfonyアプリケーションの開発・デバッグにおいて、ルーティングの問題を診断することは重要な作業である。特に「なぜこのURLが意図したルートにマッチしなかったのか」「どのルートがマッチしたのか」を把握するために、URLマッチングのトレース情報を詳細に表示する画面が必要である。本パネルはTraceableUrlMatcherを使用して、登録されたすべてのルートに対するマッチング試行のログを提供し、ルーティングの問題解決を支援する。

**画面へのアクセス方法**：プロファイラーパネル画面（No.2）の左側メニューから「Routing」パネルを選択し、パネル内に表示されるルーティングパネル（No.20）の内容としてrenderコントローラー呼び出し経由で表示される。URLは `/_profiler/{token}/router` である。

**主要な操作・処理内容**：
1. マッチしたルート名の表示（メトリクス領域）
2. ルートパラメータの一覧表示（テーブル形式）
3. リダイレクト先の表示（リダイレクトが発生した場合）
4. URLマッチングのトレースログ一覧表示（各ルートのマッチ試行結果）

**画面遷移**：
- 遷移元：ルーティングパネル（No.20）から `render(controller())` で呼び出される
- 遷移元：プロファイラーパネル（No.2）の左メニュー「Routing」から間接的に遷移

**権限による表示制御**：本画面は開発環境でのみ利用可能であり、プロファイラーが有効な場合のみアクセスできる。特定のロールや権限による表示制御はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | RouterController::panelActionによるURLマッチングトレース詳細の表示 |
| 3 | Routing | 主機能 | TraceableUrlMatcherによるルーティングトレース情報の生成・表示 |
| 2 | HttpKernel | 補助機能 | Profilerサービスによるプロファイルデータの読み込み |

## 画面種別

詳細

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| ルート名 | `_profiler_router` |
| URLパターン | `/_profiler/{token}/router` |
| HTTPメソッド | GET |
| コントローラー | `web_profiler.controller.router::panelAction` |

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| token | 入力（URLパラメータ） | string | 必須 | プロファイルトークン |

## 表示項目

### メトリクス領域

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| Matched route | マッチしたルート名（マッチなしの場合は "(none)"） | request.route |

### Route Parameters テーブル

| 項目名 | 説明 |
|--------|------|
| Name | ルートパラメータ名 |
| Value | ルートパラメータ値 |

### Route Redirection セクション（リダイレクト時のみ表示）

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| リダイレクト先URL | リダイレクト先のURL | router.targetUrl |
| リダイレクト先ルート名 | リダイレクト先のルート名（存在する場合） | router.targetRoute |

### Route Matching Logs テーブル

| 項目名 | 説明 |
|--------|------|
| # | 行番号 |
| Route name | ルート名 |
| Path | ルートのパスパターン |
| Log | マッチング結果のログ（level=0: Path does not match, level=1: Path almost matches, level=2: マッチ成功） |

## イベント仕様

### 1-パネル表示

RouterController::panelAction が呼び出されると、以下の処理が行われる：
1. Profilerを無効化（プロファイラー自身のリクエストを記録しないため）
2. 指定トークンのプロファイルデータを読み込み
3. RequestDataCollectorからリクエスト情報を取得
4. RouterDataCollectorからルーター情報を取得
5. TraceableUrlMatcherを使用して現在のルート設定に基づくマッチングトレースを生成
6. テンプレート `@WebProfiler/Router/panel.html.twig` をレンダリング

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パネル表示 | （なし） | SELECT | Profilerストレージからプロファイルデータを読み込む（ファイルシステムベース） |

### テーブル別更新項目詳細

本画面ではデータベースの更新は行わない。プロファイルデータはファイルシステムベースのProfilerストレージから読み取り専用で取得される。

## メッセージ仕様

| 条件 | メッセージ | 種別 |
|------|-----------|------|
| Profilerが無効 | "The profiler must be enabled." | エラー（404） |
| Routerが無効 | "The Router is not enabled." | 情報 |
| ルートパラメータなし | "No parameters." | 情報 |
| マッチングログ注意 | "Note: These matching logs are based on the current router configuration, which might differ from the configuration used when profiling this request." | 注意 |

## 例外処理

| 例外 | 条件 | HTTPステータス |
|------|------|---------------|
| NotFoundHttpException | Profilerが無効（null）の場合 | 404 |

## 備考

- マッチングログは現在のルーター設定に基づいて生成されるため、プロファイリング時の設定と異なる場合がある
- ExpressionLanguageプロバイダーが設定されている場合、TraceableUrlMatcherに追加される
- マッチングログの各行は色分け表示される：level=1（警告色）、level=2（成功色）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ルーティングトレースデータの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RouterDataCollector.php | `src/Symfony/Component/HttpKernel/DataCollector/RouterDataCollector.php` | ルーターデータコレクターのデータ構造（redirect, url, route）を理解する。37行目のcollectメソッドでデータ収集ロジックを確認 |
| 1-2 | RequestDataCollector.php | `src/Symfony/Component/HttpKernel/DataCollector/RequestDataCollector.php` | リクエストデータコレクターからルートパラメータやパス情報を取得する仕組みを理解する |

**読解のコツ**: DataCollectorはDataCollectorインターフェースを実装し、`collect()`メソッドでデータを収集、`data`プロパティにシリアライズ可能な形で保存する。

#### Step 2: エントリーポイントを理解する

処理の起点となるRouterControllerを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RouterController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/RouterController.php` | panelActionメソッド（53行目）がエントリーポイント。プロファイルデータ読み込みからトレース生成までの流れ |

**主要処理フロー**:
1. **55-57行目**: Profilerのnullチェック。無効時はNotFoundHttpExceptionをスロー
2. **59行目**: `$this->profiler->disable()` でプロファイラーを無効化
3. **61-63行目**: Matcher/Routesのnullチェック
4. **65行目**: トークンからプロファイルを読み込み
5. **68行目**: RequestDataCollectorを取得
6. **70-74行目**: テンプレートをレンダリング。request、router、tracesをテンプレート変数として渡す

#### Step 3: トレース生成ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RouterController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/RouterController.php` | getTracesメソッド（80行目）でTraceableUrlMatcherを生成しトレースを取得する仕組み |

**主要処理フロー**:
- **82-89行目**: 元のリクエスト情報からRequestオブジェクトを再構築
- **91-93行目**: コンテキストを設定しTraceableUrlMatcherを生成
- **94-96行目**: ExpressionLanguageプロバイダーの追加
- **98行目**: `getTracesForRequest()`で全ルートに対するマッチングトレースを取得

#### Step 4: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | router.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/router.html.twig` | ルーティングパネルの親テンプレート。`render(controller())`でRouterController::panelActionを呼び出す（13行目） |
| 4-2 | panel.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Router/panel.html.twig` | ルーター詳細パネルの実際の表示テンプレート。メトリクス、ルートパラメータ、マッチングログの表示構造 |

### プログラム呼び出し階層図

```
ProfilerController::panelAction (プロファイラーパネル)
    |
    +-- router.html.twig (Routingパネルテンプレート)
           |
           +-- render(controller('web_profiler.controller.router::panelAction'))
                  |
                  +-- RouterController::panelAction (53行目)
                         |
                         +-- Profiler::loadProfile() (65行目)
                         |      +-- RequestDataCollector (68行目)
                         |      +-- RouterDataCollector (72行目)
                         |
                         +-- RouterController::getTraces() (80行目)
                         |      +-- TraceableUrlMatcher::getTracesForRequest() (98行目)
                         |
                         +-- Twig::render('@WebProfiler/Router/panel.html.twig') (70行目)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

token (URLパラメータ)
    |
    +---> Profiler::loadProfile()
             |
             +---> RequestDataCollector ---------> request変数（ルート名、パス、パラメータ）
             |
             +---> RouterDataCollector ----------> router変数（リダイレクト情報）
             |
             +---> TraceableUrlMatcher
                      |
                      +---> getTracesForRequest() --> traces変数（マッチングログ配列）
                                                          |
                                                          v
                                                    panel.html.twig
                                                          |
                                                          v
                                                    HTMLレスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RouterController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/RouterController.php` | ソース | ルーター詳細パネルのコントローラー |
| panel.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Router/panel.html.twig` | テンプレート | ルーター詳細パネルのTwigテンプレート |
| router.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/router.html.twig` | テンプレート | ルーティングパネルの親テンプレート（renderでRouterControllerを呼び出す） |
| RouterDataCollector.php | `src/Symfony/Component/HttpKernel/DataCollector/RouterDataCollector.php` | ソース | ルーティングデータの収集 |
| RequestDataCollector.php | `src/Symfony/Component/HttpKernel/DataCollector/RequestDataCollector.php` | ソース | リクエストデータの収集 |
| profiler.php | `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` | 設定 | ルーティング定義（42-44行目で `_profiler_router` を定義） |
| table.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/table.html.twig` | テンプレート | 汎用テーブル表示テンプレート（ルートパラメータ表示に使用） |
| layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | テンプレート | プロファイラーレイアウトテンプレート |
