# 画面設計書 22-Ajaxリクエストパネル

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する「Ajaxリクエストパネル」画面の設計書である。ブラウザ上で発生したAjaxリクエストの一覧と詳細情報を表示するツールバーパネルの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：シングルページアプリケーションやAjax多用のWebアプリケーション開発において、非同期HTTPリクエストのデバッグは頻繁に必要となる。本パネルはブラウザ上で発生したXMLHttpRequest（Ajax）リクエストをリアルタイムに追跡し、各リクエストのメソッド、ステータス、URL、レスポンス時間などの情報を一覧表示する。サーバーサイドではなく、クライアントサイドのJavaScriptによりデータ収集が行われる点が他のパネルと異なる特徴である。

**画面へのアクセス方法**：Webデバッグツールバー（No.12）のAjaxアイコンをクリックすることでツールバーのドロップダウンとして表示される。プロファイラーのパネル画面としては独立した詳細パネルは持たず、ツールバー上のみで表示される。

**主要な操作・処理内容**：
1. Ajaxリクエスト数のリアルタイム表示（ツールバーアイコンのバッジ）
2. Ajaxリクエスト一覧のテーブル表示（#, Profile, Method, Type, Status, URL, Time）
3. リクエスト一覧のクリア操作

**画面遷移**：
- 遷移元：Webデバッグツールバー（No.12）のAjaxアイコンクリック
- 遷移先：各Ajaxリクエストの「Profile」リンクからプロファイラーパネル（No.2）へ遷移可能

**権限による表示制御**：本画面は開発環境でのみ利用可能であり、Webデバッグツールバーが表示されている場合のみアクセスできる。特定のロールや権限による表示制御はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | Ajaxリクエストの一覧・詳細を表示するパネル |
| 4 | HttpClient | 補助機能 | HTTPクライアント経由のAjaxリクエスト情報の表示 |

## 画面種別

一覧（ツールバードロップダウン）

## URL/ルーティング

本パネルは独自のルートを持たない。ツールバーテンプレート `@WebProfiler/Collector/ajax.html.twig` としてレンダリングされ、`toolbar` ブロックのみを定義する。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| （なし） | - | - | - | クライアントサイドでデータ収集されるため、サーバーサイドの入力パラメータはない |

## 表示項目

### ツールバーアイコン領域

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| Ajaxアイコン | ajax.svgアイコン | 静的リソース |
| リクエスト数 | Ajaxリクエストの総数（初期値0） | クライアントサイドJavaScript |

### ツールバードロップダウン - ヘッダー

| 項目名 | 説明 |
|--------|------|
| Ajax情報 | Ajaxリクエストの概要情報 |
| Clearリンク | リクエスト一覧のクリア操作 |

### ツールバードロップダウン - Ajaxリクエストテーブル

| 項目名 | 説明 |
|--------|------|
| # | リクエスト番号 |
| Profile | プロファイラーへのリンク |
| Method | HTTPメソッド（GET, POST等） |
| Type | リクエストタイプ |
| Status | HTTPステータスコード |
| URL | リクエストURL |
| Time | レスポンス時間 |

## イベント仕様

### 1-Ajaxリクエスト検出

ブラウザ上のJavaScript（ツールバーのスクリプト）がXMLHttpRequestをフックし、以下を実行する：
1. リクエストの送信を検出
2. レスポンスの受信を検出
3. リクエスト情報（メソッド、URL、ステータス、時間等）をツールバーのテーブルに追加
4. カウンターをインクリメント

### 2-Clearボタン押下

Clearリンクをクリックすると、JavaScriptにより以下が実行される：
1. リクエスト一覧テーブルの内容がクリアされる
2. カウンターが0にリセットされる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| （なし） | （なし） | - | データベースへのアクセスは行わない |

### テーブル別更新項目詳細

本画面はクライアントサイドのみで動作するため、データベースの更新は一切行わない。

## メッセージ仕様

| 条件 | メッセージ | 種別 |
|------|-----------|------|
| Ajaxリクエストなし | （テーブルが空で表示） | 情報 |

## 例外処理

クライアントサイドで動作するため、サーバーサイドの例外処理は存在しない。AjaxDataCollectorのcollect()メソッドは空実装である（26行目コメント："all collecting is done client side"）。

## 備考

- 本パネルはサーバーサイドのデータ収集を一切行わない特殊なパネルである
- AjaxDataCollector（`src/Symfony/Component/HttpKernel/DataCollector/AjaxDataCollector.php`）はcollect()とreset()が空実装
- データの収集・表示はすべてブラウザ上のJavaScript（ツールバースクリプト）によって行われる
- ツールバーアイテムの `link: false` により、プロファイラーパネルへのリンクは無効化されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

AjaxDataCollectorはサーバーサイドでは何もデータを収集しないことを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AjaxDataCollector.php | `src/Symfony/Component/HttpKernel/DataCollector/AjaxDataCollector.php` | collect()とreset()が空実装であること（24-31行目）。getName()が'ajax'を返すこと（34-37行目） |

**読解のコツ**: このコレクターは他のコレクターと異なり、サーバーサイドでデータを収集しない。すべてのデータ収集はクライアントサイドのJavaScriptで行われる。

#### Step 2: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ajax.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/ajax.html.twig` | toolbarブロック（3行目）のみを定義。menuブロックやpanelブロックは未定義 |

**主要処理フロー**:
1. **4-7行目**: ツールバーアイコンの定義。ajax.svgとカウンター（初期値0）
2. **9-31行目**: ツールバードロップダウンの内容。ヘッダー（Ajax情報とClearリンク）とリクエストテーブル
3. **17-29行目**: Ajaxリクエストテーブルの定義。#, Profile, Method, Type, Status, URL, Time列
4. **34行目**: `toolbar_item.html.twig`をインクルード。`link: false`でプロファイラーリンクを無効化

#### Step 3: JavaScriptの動作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | toolbar_js.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar_js.html.twig` | ツールバーのJavaScriptでAjaxリクエストのインターセプトとテーブル更新が行われる |

### プログラム呼び出し階層図

```
WebDebugToolbarListener (サーバーサイド)
    |
    +-- toolbar.html.twig (ツールバーレンダリング)
           |
           +-- ajax.html.twig (toolbarブロック)
                  |
                  +-- toolbar_item.html.twig (ツールバーアイテム)
                         |
                         +-- [クライアントサイドJavaScript]
                                |
                                +-- XMLHttpRequest フック
                                +-- テーブル動的更新
                                +-- カウンター更新
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ブラウザ上のAjaxリクエスト
    |
    +---> JavaScript (XMLHttpRequestフック)
             |
             +---> リクエスト情報抽出 -------> テーブル行追加
             |        (method, url,            (DOM操作)
             |         status, time)
             |
             +---> カウンター更新 ----------> バッジ数値更新
                                              (DOM操作)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ajax.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/ajax.html.twig` | テンプレート | Ajaxリクエストパネルのテンプレート（toolbarブロックのみ） |
| AjaxDataCollector.php | `src/Symfony/Component/HttpKernel/DataCollector/AjaxDataCollector.php` | ソース | Ajaxデータコレクター（空実装） |
| toolbar_item.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar_item.html.twig` | テンプレート | ツールバーアイテムの汎用テンプレート |
| toolbar_js.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar_js.html.twig` | テンプレート | ツールバーのJavaScript（Ajaxインターセプト含む） |
| layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | テンプレート | プロファイラーレイアウトテンプレート |
