# 画面設計書 24-バリデーターパネル

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する「バリデーターパネル」画面の設計書である。Validatorコンポーネントによるバリデーション制約と結果を表示するプロファイラーパネルの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：アプリケーション開発においてバリデーションはデータの整合性を保つための重要な機能である。バリデーションルールの適用状況やバリデーション違反の詳細を把握することは、データ入力に関するバグの特定に不可欠である。本パネルは、リクエスト処理中に実行されたバリデーション呼び出しの一覧、各呼び出しの呼び出し元（ファイル、行番号）、バリデーション違反の詳細（パス、メッセージ、無効な値）を表示し、バリデーション関連の問題解決を支援する。

**画面へのアクセス方法**：プロファイラーパネル画面（No.2）の左側メニューから「Validator」パネルを選択する。バリデーション呼び出しが存在しない場合はメニューが無効表示される。ツールバー（No.12）にもバリデーション違反数または呼び出し数のバッジが表示される。

**主要な操作・処理内容**：
1. バリデーター呼び出し数・違反数のメトリクス表示（ツールバー）
2. バリデーション呼び出し一覧の表示（呼び出し元ファイル・行番号付き）
3. 呼び出し元のソースコード抜粋の表示/非表示切替
4. バリデーションコンテキストのダンプ表示/非表示切替
5. 各呼び出しのバリデーション違反テーブル表示

**画面遷移**：
- 遷移元：プロファイラーパネル（No.2）の左メニュー「Validator」から遷移
- 遷移元：Webデバッグツールバー（No.12）のValidatorアイコンクリック

**権限による表示制御**：本画面は開発環境でのみ利用可能である。特定のロールや権限による表示制御はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | バリデーション制約・結果を表示するパネル |
| 33 | Validator | 主機能 | Validatorコンポーネントによるバリデーション制約・結果の表示 |

## 画面種別

一覧

## URL/ルーティング

本パネルはプロファイラーパネル（`/_profiler/{token}?panel=validator`）の一部として表示される。独自のルートは持たない。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| token | 入力（URLパラメータ） | string | 必須 | プロファイルトークン（親パネル経由） |
| panel | 入力（クエリパラメータ） | string | 必須 | "validator"（親パネル経由） |

## 表示項目

### ツールバー領域

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| Validatorアイコン | validator.svgアイコン | 静的リソース |
| 数値バッジ | 違反数（違反あり時）または呼び出し数 | collector.violationsCount / collector.calls|length |
| Validator calls | バリデーション呼び出し数 | collector.calls|length |
| Number of violations | バリデーション違反数（違反あり時は赤色） | collector.violationsCount |

### メニュー領域

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| Validator | メニューラベル | 固定値 |
| 違反数バッジ | 違反数（違反あり時のみ赤色表示） | collector.violationsCount |

### パネル領域 - バリデーション呼び出し一覧

| 項目名 | 説明 |
|--------|------|
| 呼び出し元情報 | ファイル名、行番号（リンク付き）、コンテキストリンク |
| ソースコード抜粋 | 呼び出し元のソースコードの抜粋（トグル表示） |
| バリデーションコンテキスト | バリデーションコンテキストのダンプ（トグル表示） |

### パネル領域 - 違反テーブル（各呼び出しごと）

| 項目名 | 説明 |
|--------|------|
| Path | バリデーション違反のプロパティパス |
| Message | バリデーション違反メッセージ |
| Invalid value | 無効な値（profiler_dump表示） |
| Violation | 違反オブジェクトのダンプ |

## イベント仕様

### 1-ソースコード抜粋のトグル

行番号リンクをクリックすると、JavaScriptのsf-toggleにより以下が実行される：
1. 対応するソースコード抜粋領域の表示/非表示を切り替え

### 2-コンテキストのトグル

"context"リンクをクリックすると、JavaScriptのsf-toggleにより以下が実行される：
1. 対応するバリデーションコンテキストのダンプ表示/非表示を切り替え

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パネル表示 | （なし） | SELECT | Profilerストレージからプロファイルデータを読み込む |

### テーブル別更新項目詳細

本画面ではデータベースの更新は行わない。

## メッセージ仕様

| 条件 | メッセージ | 種別 |
|------|-----------|------|
| 呼び出しなし | "No calls to the validator were collected." | 情報 |
| 違反なし | "No violations" | 情報 |

## 例外処理

- バリデーション呼び出しが存在しない場合は空パネルメッセージを表示
- ツールバーはバリデーション呼び出しが0件の場合は表示されない（33行目の条件分岐）

## 備考

- ValidatorDataCollectorはLateDataCollectorInterfaceを実装しており、カーネル終了時にデータを収集する
- TraceableValidatorを使用してバリデーション呼び出しをトレースしている
- ソースコード抜粋のシンタックスハイライトはPHPのハイライト色をCSS変数に置換して表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ValidatorDataCollector.php | `src/Symfony/Component/Validator/DataCollector/ValidatorDataCollector.php` | データ構造（calls, violations_count）。lateCollect()（51-56行目）でTraceableValidatorから収集データを取得。violations_countはarray_reduceで算出 |

**読解のコツ**: LateDataCollectorInterfaceを実装しており、collect()は空。lateCollect()でデータが収集される。

#### Step 2: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | validator.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/validator.html.twig` | バリデーターパネルのテンプレート。toolbar(32行目)、menu(57行目)、panel(69行目)の3ブロック |

**主要処理フロー**:
1. **32-55行目**: ツールバーブロック - 違反数または呼び出し数のバッジ表示
2. **57-67行目**: メニューブロック - Validatorラベルとバッジ
3. **69-132行目**: パネルブロック - 呼び出し一覧のループ処理
4. **73-87行目**: 各呼び出しの呼び出し元情報表示（ファイルリンク、行番号、コンテキスト）
5. **89-98行目**: ソースコード抜粋（トグル表示）、PHPハイライト色のCSS変数置換
6. **100-102行目**: バリデーションコンテキストのダンプ表示（トグル）
7. **104-125行目**: 違反テーブル（Path, Message, Invalid value, Violation列）

### プログラム呼び出し階層図

```
ProfilerController::panelAction
    |
    +-- layout.html.twig
           |
           +-- validator.html.twig (panelブロック)
                  |
                  +-- collector.calls ループ
                         |
                         +-- 呼び出し元情報表示
                         +-- ソースコード抜粋（トグル）
                         +-- コンテキストダンプ（トグル）
                         +-- 違反テーブル表示
```

### データフロー図

```
[入力]                    [処理]                           [出力]

Validator::validate()呼び出し
    |
    +---> TraceableValidator
             |
             +---> ValidatorDataCollector::lateCollect()
                      |
                      +---> data['calls'] -------> 呼び出し一覧表示
                      +---> data['violations_count'] -> バッジ数値
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| validator.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/validator.html.twig` | テンプレート | バリデーターパネルのTwigテンプレート |
| ValidatorDataCollector.php | `src/Symfony/Component/Validator/DataCollector/ValidatorDataCollector.php` | ソース | バリデーションデータの収集 |
| TraceableValidator.php | `src/Symfony/Component/Validator/Validator/TraceableValidator.php` | ソース | バリデーション呼び出しのトレース |
| layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | テンプレート | プロファイラーレイアウト |
