# 画面設計書 25-キャッシュパネル

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する「キャッシュパネル」画面の設計書である。Cacheコンポーネントによるキャッシュのヒット/ミス統計情報を表示するプロファイラーパネルの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：キャッシュはアプリケーションのパフォーマンス最適化において重要な役割を果たす。キャッシュのヒット率、ミス率、読み書き回数を把握することで、キャッシュ戦略の有効性を評価し、パフォーマンスのボトルネックを特定できる。本パネルは、各キャッシュプールの呼び出し統計（reads, writes, deletes, hits, misses）、ヒット率、個別の呼び出しログ、アダプタークラス情報を表示する。

**画面へのアクセス方法**：プロファイラーパネル画面（No.2）の左側メニューから「Cache」パネルを選択する。キャッシュ呼び出しが存在しない場合はメニューが無効表示される。ツールバー（No.12）にもキャッシュ呼び出し数、処理時間、ヒット率のバッジが表示される。

**主要な操作・処理内容**：
1. キャッシュ呼び出し数・処理時間のメトリクス表示（ツールバー）
2. 総合メトリクスの表示（calls, time, reads, writes, deletes, hits, misses, hit rate）
3. キャッシュプール別のタブ切替表示
4. 各プールのアダプタークラス、メトリクス、呼び出しログの表示
5. 呼び出しのないプール一覧の表示

**画面遷移**：
- 遷移元：プロファイラーパネル（No.2）の左メニュー「Cache」から遷移
- 遷移元：Webデバッグツールバー（No.12）のCacheアイコンクリック

**権限による表示制御**：本画面は開発環境でのみ利用可能である。特定のロールや権限による表示制御はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | キャッシュのヒット/ミス統計を表示するパネル |
| 45 | Cache | 主機能 | Cacheコンポーネントのヒット/ミス/呼び出し統計の表示 |

## 画面種別

一覧（タブ構成）

## URL/ルーティング

本パネルはプロファイラーパネル（`/_profiler/{token}?panel=cache`）の一部として表示される。独自のルートは持たない。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| token | 入力（URLパラメータ） | string | 必須 | プロファイルトークン（親パネル経由） |
| panel | 入力（クエリパラメータ） | string | 必須 | "cache"（親パネル経由） |

## 表示項目

### ツールバー領域

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| Cacheアイコン | cache.svgアイコン | 静的リソース |
| 呼び出し数 | 総キャッシュ呼び出し数 | collector.totals.calls |
| 処理時間 | 総処理時間（ms） | collector.totals.time |
| Cache hits | ヒット数/読み取り数（ヒット率%） | collector.totals.hits / collector.totals.reads |
| Cache writes | 書き込み数 | collector.totals.writes |

### パネル領域 - 総合メトリクス

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| Total calls | 総呼び出し数 | pool.calls |
| Total time | 総処理時間（ms） | pool.time |
| Total reads | 総読み取り数 | pool.reads |
| Total writes | 総書き込み数 | pool.writes |
| Total deletes | 総削除数 | pool.deletes |
| Total hits | 総ヒット数 | pool.hits |
| Total misses | 総ミス数 | pool.misses |
| Hits/reads | ヒット率（%） | pool.hit_read_ratio |

### パネル領域 - プール別タブ

| 項目名 | 説明 |
|--------|------|
| プール名 | キャッシュプール名（タブタイトル） |
| 呼び出し数バッジ | プール別呼び出し数 |
| Adapter | アダプタークラス名 |
| Metrics | プール別メトリクス（calls, time, reads, writes, deletes, hits, misses, hit rate） |

### パネル領域 - 呼び出しログテーブル

| 項目名 | 説明 |
|--------|------|
| # | 呼び出し番号 |
| Time | 処理時間（ms） |
| Call | メソッド名とネームスペース |
| Hit | 結果（profiler_dump表示） |

## イベント仕様

### 1-プールタブ切替

プールタブをクリックすると、プロファイラーの標準タブ切替JavaScriptにより以下が実行される：
1. 前のアクティブタブを非アクティブにする
2. 選択されたタブをアクティブにする
3. 対応するタブコンテンツを表示する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パネル表示 | （なし） | SELECT | Profilerストレージからプロファイルデータを読み込む |

### テーブル別更新項目詳細

本画面ではデータベースの更新は行わない。

## メッセージ仕様

| 条件 | メッセージ | 種別 |
|------|-----------|------|
| キャッシュ呼び出しなし | "No cache calls were made." | 情報 |
| プール別呼び出しなし | "No calls were made for {name} pool." | 情報 |

## 例外処理

- キャッシュ呼び出しが0件の場合は空パネルメッセージを表示
- ツールバーはキャッシュ呼び出しが0件の場合は表示されない

## 備考

- CacheDataCollectorはLateDataCollectorInterfaceを実装しており、collect()内でlateCollect()を呼び出す
- TraceableAdapterを通じてキャッシュ操作のトレースが行われる
- 呼び出しのないプール一覧が最後のタブとして表示される
- 処理時間はミリ秒（ms）単位で小数点2桁まで表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CacheDataCollector.php | `src/Symfony/Component/Cache/DataCollector/CacheDataCollector.php` | データ構造。instances, totalの入れ子構造（54行目）。lateCollect()（52-59行目）でTraceableAdapterから呼び出しデータを収集。statisticsの算出方法 |

**読解のコツ**: collect()内でlateCollect()を直接呼び出している（41行目）。TraceableAdapterのインスタンスを保持し、各プールの呼び出しログを収集する。

#### Step 2: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cache.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/cache.html.twig` | キャッシュパネルのテンプレート。toolbar(3行目)、menu(37行目)、panel(46行目)の3ブロック。render_metricsマクロ（131行目）でメトリクスを共通レンダリング |

**主要処理フロー**:
1. **3-35行目**: ツールバーブロック - 呼び出し数、時間、ヒット率の表示
2. **46-129行目**: パネルブロック - 総合メトリクス、プール別タブ構成
3. **56-58行目**: プール別タブのフィルタリング（呼び出しのあるプールのみ）
4. **82-101行目**: 呼び出しログテーブル（#, Time, Call, Hit列）
5. **106-125行目**: 呼び出しのないプール一覧タブ
6. **131-178行目**: render_metricsマクロ - メトリクスの統一表示

### プログラム呼び出し階層図

```
ProfilerController::panelAction
    |
    +-- layout.html.twig
           |
           +-- cache.html.twig (panelブロック)
                  |
                  +-- render_metrics マクロ (総合メトリクス)
                  |
                  +-- sf-tabs (プール別タブ)
                         |
                         +-- render_metrics マクロ (プール別メトリクス)
                         +-- 呼び出しログテーブル
                         +-- 呼び出しなしプール一覧
```

### データフロー図

```
[入力]                    [処理]                           [出力]

Cache操作（get, set, delete等）
    |
    +---> TraceableAdapter
             |
             +---> CacheDataCollector::lateCollect()
                      |
                      +---> data['total'] -------> 総合メトリクス
                      +---> data['instances'] ----> プール別タブ
                             +-- calls            +-- メトリクス
                             +-- adapters         +-- 呼び出しログ
                             +-- statistics       +-- アダプター情報
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cache.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/cache.html.twig` | テンプレート | キャッシュパネルのTwigテンプレート |
| CacheDataCollector.php | `src/Symfony/Component/Cache/DataCollector/CacheDataCollector.php` | ソース | キャッシュデータの収集 |
| TraceableAdapter.php | `src/Symfony/Component/Cache/Adapter/TraceableAdapter.php` | ソース | キャッシュ操作のトレース |
| layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | テンプレート | プロファイラーレイアウト |
