# 画面設計書 26-翻訳パネル

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する「翻訳パネル」画面の設計書である。Translationコンポーネントによる翻訳メッセージの使用状況を表示するプロファイラーパネルの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：多言語対応アプリケーションの開発では、翻訳メッセージの定義漏れやフォールバック状態の把握が重要である。本パネルは、リクエスト処理中に使用された翻訳メッセージを「Defined（定義済み）」「Fallback（フォールバック）」「Missing（未定義）」の3カテゴリに分類して表示する。これにより、翻訳カタログの充足状況を一目で把握でき、未翻訳メッセージの特定と翻訳品質の向上を支援する。

**画面へのアクセス方法**：プロファイラーパネル画面（No.2）の左側メニューから「Translation」パネルを選択する。翻訳メッセージが存在しない場合はメニューが無効表示される。ツールバー（No.12）にもMissing数とFallback数の合計、またはDefined数のバッジが表示される。

**主要な操作・処理内容**：
1. 翻訳メッセージの状態別カウント表示（ツールバー）
2. デフォルトロケールとフォールバックロケールのメトリクス表示
3. Defined/Fallback/Missingの3タブ切替による翻訳メッセージ一覧表示
4. 各メッセージの詳細情報（Locale, Domain, Times used, Message ID, Message Preview）
5. パラメータの展開/折りたたみ表示
6. グローバルパラメータ一覧の表示

**画面遷移**：
- 遷移元：プロファイラーパネル（No.2）の左メニュー「Translation」から遷移
- 遷移元：Webデバッグツールバー（No.12）のTranslationアイコンクリック

**権限による表示制御**：本画面は開発環境でのみ利用可能である。特定のロールや権限による表示制御はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | 翻訳メッセージの使用状況を表示するパネル |
| 51 | Translation | 主機能 | Translationコンポーネントの翻訳メッセージ使用状況の表示 |

## 画面種別

一覧（タブ構成）

## URL/ルーティング

本パネルはプロファイラーパネル（`/_profiler/{token}?panel=translation`）の一部として表示される。独自のルートは持たない。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| token | 入力（URLパラメータ） | string | 必須 | プロファイルトークン（親パネル経由） |
| panel | 入力（クエリパラメータ） | string | 必須 | "translation"（親パネル経由） |

## 表示項目

### ツールバー領域

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| Translationアイコン | translation.svgアイコン | 静的リソース |
| 数値バッジ | Missing+Fallback数（エラーあり時）またはDefined数 | collector.countMissings + collector.countFallbacks / collector.countDefines |
| Default locale | デフォルトロケール | collector.locale |
| Missing messages | 未定義メッセージ数（あり時は赤色） | collector.countMissings |
| Fallback messages | フォールバックメッセージ数（あり時は黄色） | collector.countFallbacks |
| Defined messages | 定義済みメッセージ数 | collector.countDefines |

### パネル領域 - メトリクス

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| Default locale | デフォルトロケール | collector.locale |
| Fallback locale(s) | フォールバックロケール | collector.fallbackLocales |

### パネル領域 - Defined/Fallback/Missing タブ

| 項目名 | 説明 |
|--------|------|
| Locale | メッセージのロケール |
| Fallback locale | フォールバックロケール（Fallbackタブのみ） |
| Domain | 翻訳ドメイン |
| Times used | 使用回数 |
| Message ID | メッセージID |
| Message Preview | 翻訳結果のプレビュー |

### パネル領域 - グローバルパラメータ

| 項目名 | 説明 |
|--------|------|
| Message ID | パラメータのID |
| Value | パラメータの値（profiler_dump表示） |

## イベント仕様

### 1-タブ切替

Defined/Fallback/Missingタブをクリックすると、プロファイラーの標準タブ切替JavaScriptにより対応するメッセージ一覧が表示される。

### 2-パラメータ表示切替

「Show parameters」ボタンをクリックすると、sf-toggleにより翻訳パラメータの表示/非表示が切り替わる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パネル表示 | （なし） | SELECT | Profilerストレージからプロファイルデータを読み込む |

### テーブル別更新項目詳細

本画面ではデータベースの更新は行わない。

## メッセージ仕様

| 条件 | メッセージ | 種別 |
|------|-----------|------|
| 翻訳なし | "No translations have been called." | 情報 |
| Defined なし | "None of the used translation messages are defined for the given locale." | 情報 |
| Fallback なし | "No fallback translation messages were used." | 情報 |
| Missing なし | "There are no messages of this category." | 情報 |
| Definedの説明 | "These messages are correctly translated into the given locale." | ヘルプ |
| Fallbackの説明 | "These messages are not available for the given locale but Symfony found them in the fallback locale catalog." | ヘルプ |
| Missingの説明 | "These messages are not available for the given locale and cannot be found in the fallback locales. Add them to the translation catalogue to avoid Symfony outputting untranslated contents." | ヘルプ |

## 例外処理

- 翻訳メッセージが存在しない場合は空パネルメッセージを表示
- ツールバーは翻訳メッセージが存在しない場合は表示されない

## 備考

- DataCollectorTranslatorがTranslatorInterfaceをラップし、trans()呼び出しごとにメッセージ情報を収集する
- メッセージの状態はMESSAGE_DEFINED(0)、MESSAGE_MISSING(1)、MESSAGE_EQUALS_FALLBACK(2)の3定数で管理される
- 複数形（pluralization）が使用されている場合はメッセージIDの下に注記が表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DataCollectorTranslator.php | `src/Symfony/Component/Translation/DataCollectorTranslator.php` | メッセージ状態の3定数（24-26行目）。trans()メソッド（40-46行目）でメッセージ情報を収集。messages配列の構造 |

**読解のコツ**: DataCollectorTranslatorはTranslatorInterfaceのデコレーターパターン。trans()呼び出しごとにcollectMessage()でメッセージの状態（defined/missing/fallback）を判定して記録する。

#### Step 2: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | translation.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/translation.html.twig` | 翻訳パネルのテンプレート。toolbar(3行目)、menu(43行目)、panel(56行目)の3ブロック。render_tableマクロ（182行目） |

**主要処理フロー**:
1. **3-41行目**: ツールバーブロック - Missing/Fallback/Definedのステータス色付き表示
2. **56-68行目**: メトリクス - デフォルトロケールとフォールバックロケール
3. **77-89行目**: メッセージの3カテゴリ振り分けロジック（constant参照）
4. **91-154行目**: 3つのタブ（Defined/Fallback/Missing）
5. **159-178行目**: グローバルパラメータテーブル
6. **182-227行目**: render_tableマクロ - メッセージ一覧テーブル

### プログラム呼び出し階層図

```
ProfilerController::panelAction
    |
    +-- layout.html.twig
           |
           +-- translation.html.twig (panelブロック)
                  |
                  +-- メトリクス表示
                  +-- メッセージ振り分けロジック
                  +-- sf-tabs (Defined/Fallback/Missing)
                  |      +-- render_table マクロ
                  |
                  +-- グローバルパラメータテーブル
```

### データフロー図

```
[入力]                    [処理]                           [出力]

trans() 呼び出し
    |
    +---> DataCollectorTranslator::trans()
             |
             +---> collectMessage()
                      |
                      +---> messages[] ----------> Defined/Fallback/Missing振り分け
                      +---> locale ------------> メトリクス表示
                      +---> fallbackLocales ----> メトリクス表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| translation.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/translation.html.twig` | テンプレート | 翻訳パネルのTwigテンプレート |
| DataCollectorTranslator.php | `src/Symfony/Component/Translation/DataCollectorTranslator.php` | ソース | 翻訳データの収集（Translatorデコレーター） |
| layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | テンプレート | プロファイラーレイアウト |
