# 画面設計書 27-セキュリティパネル

## 概要

本ドキュメントは、Symfony SecurityBundleが提供する「セキュリティパネル」画面の設計書である。認証・認可に関するセキュリティ情報を表示するプロファイラーパネルの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：Webアプリケーションのセキュリティは最も重要な非機能要件の1つであり、認証・認可の動作を正確に把握することはセキュリティ上の問題を防ぐために不可欠である。本パネルは、認証トークン情報、ファイアウォール設定、セキュリティリスナー、認証プロバイダー（Authenticator）の動作状況、アクセス決定ログ（投票者による判定結果）を包括的に表示する。SecurityBundleが提供するテンプレートであり、プロファイラーフレームワーク内でホスティングされる。

**画面へのアクセス方法**：プロファイラーパネル画面（No.2）の左側メニューから「Security」パネルを選択する。ファイアウォールが有効でない場合やトークンが存在しない場合はメニューが無効表示される。ツールバー（No.12）にもユーザー名、認証状態、ロール等の情報が表示される。

**主要な操作・処理内容**：
1. ユーザー名・認証状態のメトリクス表示（ツールバー）
2. Token タブ：認証トークンの詳細情報（ユーザー名、認証状態、ロール、継承ロール）
3. Firewall タブ：ファイアウォール設定（名前、セキュリティ有効/無効、ステートレス、プロバイダー、コンテキスト等）
4. Listeners タブ：セキュリティリスナーの一覧（リスナー名、処理時間、レスポンス）
5. Authenticators タブ：認証プロバイダーの動作状況（成功/失敗/スキップ、パスポート、バッジ、例外）
6. Access Decision タブ：アクセス決定ログ（投票者戦略、投票者一覧、判定結果ログ）

**画面遷移**：
- 遷移元：プロファイラーパネル（No.2）の左メニュー「Security」から遷移
- 遷移元：Webデバッグツールバー（No.12）のSecurityアイコンクリック
- 遷移先：ログアウトURL（ツールバーのLogoutリンク）
- 遷移先：なりすまし解除パス（ツールバーのExit impersonationリンク）
- 遷移先：認証元プロファイル（authProfileTokenリンク）

**権限による表示制御**：本画面は開発環境でのみ利用可能である。表示内容はセキュリティの状態に応じて動的に変化する（認証済み/未認証、ファイアウォール有効/無効、なりすまし状態等）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | SecurityBundle | 主機能 | 認証・認可のセキュリティ情報を表示するパネル（SecurityBundle提供テンプレート） |
| 20 | Security Core | 主機能 | 認証ユーザー情報、ロール、アクセス決定の結果の表示 |
| 21 | Security HTTP | 補助機能 | ファイアウォール設定、認証リスナーの情報の表示 |
| 63 | WebProfilerBundle | 補助機能 | プロファイラーフレームワーク内でのパネルホスティング |

## 画面種別

詳細（タブ構成）

## URL/ルーティング

本パネルはプロファイラーパネル（`/_profiler/{token}?panel=security`）の一部として表示される。独自のルートは持たない。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| token | 入力（URLパラメータ） | string | 必須 | プロファイルトークン（親パネル経由） |
| panel | 入力（クエリパラメータ） | string | 必須 | "security"（親パネル経由） |

## 表示項目

### ツールバー領域

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| Securityアイコン | icon.svgアイコン（SecurityBundle提供） | 静的リソース |
| ユーザー名 | 認証ユーザー名（未認証時は"n/a"） | collector.user |
| Impersonator | なりすまし元ユーザー名（なりすまし時のみ） | collector.impersonatorUser |
| Logged in as | ログインユーザー名 | collector.user |
| Authenticated | 認証状態（Yes/No） | collector.authenticated |
| Roles | ロール一覧 | collector.roles |
| Inherited Roles | 継承ロール一覧 | collector.inheritedRoles |
| Token class | トークンクラス名 | collector.tokenClass |
| Firewall name | ファイアウォール名 | collector.firewall.name |
| Logout | ログアウトリンク | collector.logoutUrl |
| Exit impersonation | なりすまし解除リンク | collector.impersonationExitPath |

### パネル領域 - Tokenタブ

| 項目名 | 説明 |
|--------|------|
| Username | ユーザー名（メトリクス） |
| Authenticated | 認証状態（Yes/Noアイコン） |
| From | 認証元プロファイルトークン（リンク） |
| Roles | ロール一覧（profiler_dump） |
| Inherited Roles | 継承ロール一覧（profiler_dump） |
| Token | トークンオブジェクト（profiler_dump） |

### パネル領域 - Firewallタブ

| 項目名 | 説明 |
|--------|------|
| Name | ファイアウォール名（メトリクス） |
| Security enabled | セキュリティ有効/無効（アイコン） |
| Stateless | ステートレス設定（アイコン） |
| provider | プロバイダー名 |
| context | コンテキスト名 |
| entry_point | エントリーポイント |
| user_checker | ユーザーチェッカー |
| access_denied_handler | アクセス拒否ハンドラー |
| access_denied_url | アクセス拒否URL |
| authenticators | 認証プロバイダー一覧 |

### パネル領域 - Listenersタブ

| 項目名 | 説明 |
|--------|------|
| Listener | リスナークラス名（profiler_dump） |
| Duration | 処理時間（ms） |
| Response | レスポンス情報（profiler_dump） |

### パネル領域 - Authenticatorsタブ

| 項目名 | 説明 |
|--------|------|
| Status | 認証結果（success/failure/skipped） |
| Authenticator | 認証プロバイダークラス名 |
| Lazy | 遅延認証かどうか |
| Duration | 処理時間（ms） |
| Passport | パスポートオブジェクト |
| Badges | バッジ一覧（resolved/not_resolved） |
| Exception | 例外情報（失敗時） |

### パネル領域 - Access Decisionタブ

| 項目名 | 説明 |
|--------|------|
| Strategy | 投票者戦略 |
| Voter class | 投票者クラス名 |
| # | 判定番号 |
| Result | 判定結果（GRANTED/DENIED/ERROR） |
| Attributes | 判定対象の属性 |
| Object | 判定対象のオブジェクト |

## イベント仕様

### 1-タブ切替

Token/Firewall/Listeners/Authenticators/Access Decisionタブをクリックすると、対応するタブコンテンツが表示される。

### 2-Authenticator詳細の展開/折りたたみ

各Authenticator行をクリックすると、sf-toggleにより詳細情報（パスポート、バッジ、例外等）の表示/非表示が切り替わる。

### 3-Voter詳細の展開/折りたたみ

アクセス決定ログの「Show voter details」リンクをクリックすると、sf-toggleにより投票者ごとの判定詳細が表示される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パネル表示 | （なし） | SELECT | Profilerストレージからプロファイルデータを読み込む |

### テーブル別更新項目詳細

本画面ではデータベースの更新は行わない。

## メッセージ仕様

| 条件 | メッセージ | 種別 |
|------|-----------|------|
| セキュリティ無効 | "The security is disabled." | 情報 |
| トークンなし | "There is no security token." | 情報 |
| リスナーなし | "No security listeners have been recorded. Check that debugging is enabled in the kernel." | 情報 |
| 認証プロバイダーなし | "No authenticators have been recorded. Check previous profiles on your authentication endpoint." | 情報 |
| サポート外認証 | "This authenticator did not support the request." | 情報 |
| 先行認証あり | "An authenticator ran before this one." | 情報 |
| 未認証の原因 | "User is not authenticated probably because they have no roles." | ヘルプ |

## 例外処理

- セキュリティが無効の場合はすべてのタブが無効表示
- トークンが存在しない場合はTokenタブに情報メッセージを表示

## 備考

- テンプレートはSecurityBundle提供（`@SecurityBundle/Collector/security.html.twig`）であり、WebProfilerBundleのlayoutを継承
- SecurityDataCollectorはLateDataCollectorInterfaceを実装
- TokenStorageInterface、RoleHierarchyInterface、LogoutUrlGenerator、AccessDecisionManagerInterface等の複数サービスからデータを収集
- VoterInterface定数（ACCESS_GRANTED, ACCESS_ABSTAIN, ACCESS_DENIED）を使用して投票結果を表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SecurityDataCollector.php | `src/Symfony/Bundle/SecurityBundle/DataCollector/SecurityDataCollector.php` | 多数の依存サービス（42-48行目）。collect()メソッド（53行目〜）でTokenStorage、RoleHierarchy等からセキュリティ情報を収集 |

**読解のコツ**: SecurityDataCollectorは多くのサービスに依存しており、collect()メソッドが長い。enabled, authenticated, impersonated等の基本情報に加え、firewall, listeners, authenticators, accessDecisionLog等の構造化データを収集する。

#### Step 2: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | security.html.twig | `src/Symfony/Bundle/SecurityBundle/Resources/views/Collector/security.html.twig` | SecurityBundle提供のテンプレート。5つのタブ構成（Token, Firewall, Listeners, Authenticators, Access Decision） |

**主要処理フロー**:
1. **86-189行目**: ツールバーブロック - ユーザー情報、認証状態、ロール、ファイアウォール名
2. **198-607行目**: パネルブロック - 5つのタブ
3. **202-278行目**: Tokenタブ - メトリクス（ユーザー名、認証状態）とプロパティテーブル
4. **280-342行目**: Firewallタブ - ファイアウォール設定テーブル
5. **344-384行目**: Listenersタブ - リスナー一覧テーブル
6. **386-483行目**: Authenticatorsタブ - 認証プロバイダー一覧（成功/失敗/スキップ状態付き）
7. **485-606行目**: Access Decisionタブ - 投票者一覧と判定ログ

### プログラム呼び出し階層図

```
ProfilerController::panelAction
    |
    +-- layout.html.twig
           |
           +-- security.html.twig (panelブロック)
                  |
                  +-- sf-tabs
                         |
                         +-- Tokenタブ
                         +-- Firewallタブ
                         +-- Listenersタブ
                         +-- Authenticatorsタブ (sf-toggle)
                         +-- Access Decisionタブ (sf-toggle)
```

### データフロー図

```
[入力]                              [処理]                        [出力]

TokenStorageInterface --------+
RoleHierarchyInterface -------+
LogoutUrlGenerator -----------+---> SecurityDataCollector
AccessDecisionManagerInterface +     ::collect()
TraceableFirewallListener ----+          |
FirewallMap ------------------+          +---> data[] --------> 5タブ表示
                                                 |
                                                 +-- token
                                                 +-- firewall
                                                 +-- listeners
                                                 +-- authenticators
                                                 +-- accessDecisionLog
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| security.html.twig | `src/Symfony/Bundle/SecurityBundle/Resources/views/Collector/security.html.twig` | テンプレート | セキュリティパネルのTwigテンプレート |
| SecurityDataCollector.php | `src/Symfony/Bundle/SecurityBundle/DataCollector/SecurityDataCollector.php` | ソース | セキュリティデータの収集 |
| icon.svg | `src/Symfony/Bundle/SecurityBundle/Resources/views/Collector/icon.svg` | リソース | ツールバーアイコン |
| TraceableFirewallListener.php | `src/Symfony/Bundle/SecurityBundle/Debug/TraceableFirewallListener.php` | ソース | ファイアウォールリスナーのトレース |
| TraceableAccessDecisionManager.php | `src/Symfony/Component/Security/Core/Authorization/TraceableAccessDecisionManager.php` | ソース | アクセス決定マネージャーのトレース |
| layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | テンプレート | プロファイラーレイアウト |
