# 画面設計書 28-Twigパネル

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する「Twigパネル」画面の設計書である。Twigテンプレートエンジンのレンダリング情報を表示するプロファイラーパネルの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：Twigテンプレートのレンダリングパフォーマンスを最適化するためには、どのテンプレートが何回呼び出され、レンダリングにどれだけの時間がかかっているかを把握する必要がある。本パネルは、Twigテンプレートのレンダリング時間、テンプレート呼び出し数、ブロック呼び出し数、マクロ呼び出し数のメトリクスを表示するとともに、個別テンプレートのレンダリング回数一覧とレンダリング呼び出しグラフを可視化する。

**画面へのアクセス方法**：プロファイラーパネル画面（No.2）の左側メニューから「Twig」パネルを選択する。Twigテンプレートがレンダリングされていない場合はメニューが無効表示される。ツールバー（No.12）にもレンダリング時間が表示される。

**主要な操作・処理内容**：
1. レンダリング時間のメトリクス表示（ツールバー）
2. エントリービュー、レンダリング時間、テンプレート呼び出し数、ブロック呼び出し数、マクロ呼び出し数の表示（ツールバー詳細）
3. Twig メトリクスの総合表示（Render time, Template calls, Block calls, Macro calls）
4. レンダリングされたテンプレート一覧テーブル（テンプレート名・パス、レンダリング回数）
5. レンダリング呼び出しグラフのHTML表示

**画面遷移**：
- 遷移元：プロファイラーパネル（No.2）の左メニュー「Twig」から遷移
- 遷移元：Webデバッグツールバー（No.12）のTwigアイコンクリック
- 遷移先：テンプレートファイルのソースコードエディタ（file_linkフィルタ経由）

**権限による表示制御**：本画面は開発環境でのみ利用可能である。特定のロールや権限による表示制御はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | Twigテンプレートのレンダリング情報を表示するパネル |
| 36 | Twig Bridge | 主機能 | Twig BridgeおよびTwigテンプレートエンジンのレンダリング統計の表示 |
| 35 | TwigBundle | 補助機能 | TwigBundleで登録されたTwig設定情報の表示 |

## 画面種別

一覧

## URL/ルーティング

本パネルはプロファイラーパネル（`/_profiler/{token}?panel=twig`）の一部として表示される。独自のルートは持たない。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| token | 入力（URLパラメータ） | string | 必須 | プロファイルトークン（親パネル経由） |
| panel | 入力（クエリパラメータ） | string | 必須 | "twig"（親パネル経由） |

## 表示項目

### ツールバー領域

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| Twigアイコン | twig.svgアイコン | 静的リソース |
| レンダリング時間 | レンダリング時間（ms） | collector.time |
| Entry View | エントリーテンプレート名（ファイルリンク付き） | collector.templates |
| Render Time | レンダリング時間 | collector.time |
| Template Calls | テンプレート呼び出し数 | collector.templatecount |
| Block Calls | ブロック呼び出し数 | collector.blockcount |
| Macro Calls | マクロ呼び出し数 | collector.macrocount |

### パネル領域 - メトリクス

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| Render time | レンダリング時間（ms） | collector.time |
| Template calls | テンプレート呼び出し数 | collector.templatecount |
| Block calls | ブロック呼び出し数 | collector.blockcount |
| Macro calls | マクロ呼び出し数 | collector.macrocount |

### パネル領域 - Rendered Templatesテーブル

| 項目名 | 説明 |
|--------|------|
| Template Name & Path | テンプレート名とファイルパス（ファイルリンク付き） |
| Render Count | レンダリング回数 |

### パネル領域 - Rendering Call Graph

| 項目名 | 説明 |
|--------|------|
| 呼び出しグラフ | テンプレートのレンダリング呼び出し階層をHTML形式で表示 |

## イベント仕様

### 1-テンプレートファイルリンク

テンプレート名のリンクをクリックすると、file_linkフィルタで生成されたURLに基づいてソースコードエディタでファイルが開かれる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パネル表示 | （なし） | SELECT | Profilerストレージからプロファイルデータを読み込む |

### テーブル別更新項目詳細

本画面ではデータベースの更新は行わない。

## メッセージ仕様

| 条件 | メッセージ | 種別 |
|------|-----------|------|
| テンプレートなし | "No Twig templates were rendered." | 情報 |
| サブリクエスト注記 | "Render time includes sub-requests rendering time (if any)." | ヘルプ |

## 例外処理

- テンプレートが1つもレンダリングされていない場合は空パネルメッセージを表示

## 備考

- TwigDataCollectorはLateDataCollectorInterfaceを実装しており、Twig\Profiler\Profileからデータを収集する
- レンダリング呼び出しグラフはHtmlDumperを使用してProfile構造をHTML化している
- templatePathsマッピングにより各テンプレートのファイルシステムパスを取得できる
- CSS変数を使用したカスタムスタイル（twig-dump, twig-table）が定義されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | TwigDataCollector.php | `src/Symfony/Bridge/Twig/DataCollector/TwigDataCollector.php` | Twig\Profiler\ProfileとTwig Environmentに依存（33-36行目）。lateCollect()（50行目〜）でプロファイルデータとテンプレートパスを収集 |

**読解のコツ**: TwigDataCollectorはTwigのProfileクラスからレンダリング統計を取得する。computedプロパティでキャッシュされた計算結果（テンプレート数、ブロック数、マクロ数等）を保持する。

#### Step 2: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | twig.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/twig.html.twig` | Twigパネルのテンプレート。toolbar(40行目)、menu(85行目)、panel(92行目)の3ブロック |

**主要処理フロー**:
1. **40-83行目**: ツールバーブロック - レンダリング時間、エントリービュー、各種呼び出し数
2. **92-168行目**: パネルブロック - メトリクス、テンプレートテーブル、呼び出しグラフ
3. **100-126行目**: メトリクスグループ - Render time, Template calls, Block calls, Macro calls
4. **134-160行目**: テンプレート一覧テーブル - テンプレート名（file_link付き）とRender Count
5. **164-166行目**: Rendering Call Graph - collector.htmlcallgraph

### プログラム呼び出し階層図

```
ProfilerController::panelAction
    |
    +-- layout.html.twig
           |
           +-- twig.html.twig (panelブロック)
                  |
                  +-- メトリクス表示
                  +-- テンプレート一覧テーブル
                  |      +-- file_link フィルタ
                  |      +-- file_relative フィルタ
                  |
                  +-- Rendering Call Graph
                         +-- collector.htmlcallgraph (HtmlDumper出力)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

Twigテンプレートレンダリング
    |
    +---> Twig\Profiler\Profile
             |
             +---> TwigDataCollector::lateCollect()
                      |
                      +---> profile (シリアライズ) ---> メトリクス
                      +---> template_paths ---------> テンプレート一覧
                      +---> htmlcallgraph ----------> 呼び出しグラフ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| twig.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/twig.html.twig` | テンプレート | TwigパネルのTwigテンプレート |
| TwigDataCollector.php | `src/Symfony/Bridge/Twig/DataCollector/TwigDataCollector.php` | ソース | Twigレンダリングデータの収集 |
| layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | テンプレート | プロファイラーレイアウト |
