# 画面設計書 29-HTTPクライアントパネル

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する「HTTPクライアントパネル」画面の設計書である。HttpClientコンポーネントによるHTTPリクエスト/レスポンスのトレース情報を表示するプロファイラーパネルの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：外部APIやマイクロサービスとの連携を行うアプリケーションでは、HTTPクライアントによる外部リクエストのデバッグが頻繁に必要となる。本パネルは、各HTTPクライアントサービスが送信したリクエストのメソッド、URL、リクエストオプション、レスポンスステータスコード、レスポンス詳細情報を表示する。これにより、外部API連携の問題（タイムアウト、認証エラー、不正なリクエスト等）の迅速な特定を支援する。

**画面へのアクセス方法**：プロファイラーパネル画面（No.2）の左側メニューから「HTTP Client」パネルを選択する。HTTPリクエストが存在しない場合はメニューが無効表示される。ツールバー（No.12）にもリクエスト数とHTTPエラー数のバッジが表示される。

**主要な操作・処理内容**：
1. 総リクエスト数・HTTPエラー数のメトリクス表示（ツールバー）
2. クライアントサービス別のタブ切替表示
3. 各クライアントのリクエスト一覧表示（HTTPメソッド、URL、ステータスコード）
4. リクエストオプションの詳細表示
5. レスポンス情報のダンプ表示
6. cURLコマンドのコピーボタン
7. プロファイラーリンク（デバッグトークンがある場合）

**画面遷移**：
- 遷移元：プロファイラーパネル（No.2）の左メニュー「HTTP Client」から遷移
- 遷移元：Webデバッグツールバー（No.12）のHTTP Clientアイコンクリック
- 遷移先：リクエスト先のプロファイラー画面（x-debug-token-linkヘッダーが存在する場合）

**権限による表示制御**：本画面は開発環境でのみ利用可能である。特定のロールや権限による表示制御はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | HTTPクライアントのリクエスト/レスポンス情報を表示するパネル |
| 4 | HttpClient | 主機能 | HttpClientコンポーネントによるHTTPリクエスト/レスポンスのトレース情報の表示 |

## 画面種別

一覧（タブ構成）

## URL/ルーティング

本パネルはプロファイラーパネル（`/_profiler/{token}?panel=http_client`）の一部として表示される。独自のルートは持たない。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| token | 入力（URLパラメータ） | string | 必須 | プロファイルトークン（親パネル経由） |
| panel | 入力（クエリパラメータ） | string | 必須 | "http_client"（親パネル経由） |

## 表示項目

### ツールバー領域

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| HTTP Clientアイコン | http-client.svgアイコン | 静的リソース |
| リクエスト数 | 総リクエスト数 | collector.requestCount |
| Total requests | 総リクエスト数 | collector.requestCount |
| HTTP errors | HTTPエラー数（エラーあり時は赤色） | collector.errorCount |

### パネル領域 - メトリクス

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| Total requests | 総リクエスト数 | collector.requestCount |
| HTTP errors | HTTPエラー数 | collector.errorCount |

### パネル領域 - クライアント別タブ

| 項目名 | 説明 |
|--------|------|
| クライアント名 | HTTPクライアントサービス名（タブタイトル） |
| リクエスト数バッジ | クライアント別リクエスト数 |

### パネル領域 - リクエスト詳細テーブル（各リクエストごと）

| 項目名 | 説明 |
|--------|------|
| HTTP Method | HTTPメソッド（バッジ表示） |
| URL | リクエストURL |
| Profile | プロファイラーリンク（x-debug-tokenが存在する場合） |
| Copy as cURL | cURLコマンドのコピーボタン |
| Request options | リクエストオプション（profiler_dump表示） |
| Response | HTTPステータスコード（色分け表示: 2xx=success, 4xx=warning, 5xx=error）とレスポンス情報（profiler_dump） |

## イベント仕様

### 1-クライアントタブ切替

クライアントタブをクリックすると、プロファイラーの標準タブ切替JavaScriptにより対応するクライアントのリクエスト一覧が表示される。

### 2-cURLコマンドコピー

「Copy as cURL」ボタンをクリックすると、data-clipboard-text属性のcURLコマンドがクリップボードにコピーされる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パネル表示 | （なし） | SELECT | Profilerストレージからプロファイルデータを読み込む |

### テーブル別更新項目詳細

本画面ではデータベースの更新は行わない。

## メッセージ仕様

| 条件 | メッセージ | 種別 |
|------|-----------|------|
| リクエストなし | "No HTTP requests were made." | 情報 |
| クライアント別リクエストなし | "No requests were made with the \"{name}\" service." | 情報 |

## 例外処理

- HTTPリクエストが0件の場合は空パネルメッセージを表示
- ツールバーはリクエストが0件の場合は表示されない

## 備考

- HttpClientDataCollectorはLateDataCollectorInterfaceを実装しており、TraceableHttpClientから呼び出しデータを収集する
- レスポンスヘッダーのx-debug-tokenとx-debug-token-linkを解析してプロファイラーリンクを生成
- ステータスコードの色分け：500以上=error（赤）、400以上=warning（黄）、それ以外=success（緑）
- cURLコマンドは trace.curlCommand が存在する場合のみコピーボタンが表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | HttpClientDataCollector.php | `src/Symfony/Component/HttpClient/DataCollector/HttpClientDataCollector.php` | TraceableHttpClientの配列を保持（34行目）。lateCollect()（46行目〜）でクライアント別のトレースデータを収集。request_count, error_count, clients構造 |

**読解のコツ**: collect()内でlateCollect()を直接呼び出す（43行目）。各クライアントのトレース情報にはmethod, url, http_code, info, options, curlCommand等が含まれる。

#### Step 2: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | http_client.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/http_client.html.twig` | HTTPクライアントパネルのテンプレート。toolbar(38行目)、menu(61行目)、panel(73行目)の3ブロック |

**主要処理フロー**:
1. **38-59行目**: ツールバーブロック - リクエスト数とエラー数の表示
2. **73-174行目**: パネルブロック - メトリクス、クライアント別タブ構成
3. **92-94行目**: クライアント別タブの表示
4. **102-114行目**: リクエストヘッダー（HTTPメソッド、URL、Profile、cURLコピー）
5. **115-166行目**: リクエスト詳細（オプション、レスポンス、ステータスコード色分け）
6. **103-113行目**: x-debug-tokenヘッダーからのプロファイラーリンク抽出

### プログラム呼び出し階層図

```
ProfilerController::panelAction
    |
    +-- layout.html.twig
           |
           +-- http_client.html.twig (panelブロック)
                  |
                  +-- メトリクス表示
                  +-- sf-tabs (クライアント別タブ)
                         |
                         +-- 各クライアントのリクエスト一覧
                                |
                                +-- リクエストヘッダー（メソッド、URL）
                                +-- リクエストオプション（profiler_dump）
                                +-- レスポンス情報（ステータスコード + profiler_dump）
```

### データフロー図

```
[入力]                    [処理]                           [出力]

HTTPクライアントリクエスト
    |
    +---> TraceableHttpClient
             |
             +---> HttpClientDataCollector::lateCollect()
                      |
                      +---> data['request_count'] --> メトリクス
                      +---> data['error_count'] ----> メトリクス
                      +---> data['clients'] --------> クライアント別タブ
                             +-- traces[]              +-- リクエスト詳細
                                  +-- method
                                  +-- url
                                  +-- http_code
                                  +-- info
                                  +-- options
                                  +-- curlCommand
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| http_client.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/http_client.html.twig` | テンプレート | HTTPクライアントパネルのTwigテンプレート |
| HttpClientDataCollector.php | `src/Symfony/Component/HttpClient/DataCollector/HttpClientDataCollector.php` | ソース | HTTPクライアントデータの収集 |
| TraceableHttpClient.php | `src/Symfony/Component/HttpClient/TraceableHttpClient.php` | ソース | HTTPクライアントリクエストのトレース |
| layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | テンプレート | プロファイラーレイアウト |
