# 画面設計書 30-メーラーパネル

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する「メーラーパネル」画面の設計書である。Mailerコンポーネントによる送信メールの情報を表示するプロファイラーパネルの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：メール送信はユーザー通知、パスワードリセット、受注確認等の重要な業務プロセスに関わる機能である。開発・テスト環境においてメールの内容（件名、宛先、本文、添付ファイル等）を確認し、送信状態（即時送信/キュー待ち）を把握することは品質保証に不可欠である。本パネルは、リクエスト処理中に送信されたメールの詳細情報を表示し、HTML/テキスト本文のプレビュー、MIMEパーツの構造、添付ファイルのダウンロード、EMLファイルのダウンロード機能を提供する。

**画面へのアクセス方法**：プロファイラーパネル画面（No.2）の左側メニューから「Emails」パネルを選択する。メールが存在しない場合はメニューが無効表示される。ツールバー（No.12）にもメール数のバッジが表示される。

**主要な操作・処理内容**：
1. キュー待ち/送信済みメール数のメトリクス表示（ツールバー）
2. 複数メールの一覧テーブル表示と選択切替（2通以上の場合）
3. メール詳細表示（件名、From、To、ヘッダー情報）
4. 添付ファイル一覧とダウンロード
5. メール本文のタブ切替表示（Text content / HTML preview / HTML content）
6. MIMEパーツ構造の表示
7. Raw Messageの表示とEMLファイルダウンロード
8. トランスポート別の分類表示（複数トランスポート時）

**画面遷移**：
- 遷移元：プロファイラーパネル（No.2）の左メニュー「Emails」から遷移
- 遷移元：Webデバッグツールバー（No.12）のEmailsアイコンクリック

**権限による表示制御**：本画面は開発環境でのみ利用可能である。特定のロールや権限による表示制御はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | 送信メールの情報を表示するパネル |
| 40 | Mailer | 主機能 | Mailerコンポーネントによる送信メール（宛先、件名、本文等）の表示 |
| 42 | Mime | 補助機能 | MIMEメッセージの構造（ヘッダー、本文、添付ファイル）の表示 |

## 画面種別

詳細（メール選択 + タブ構成）

## URL/ルーティング

本パネルはプロファイラーパネル（`/_profiler/{token}?panel=mailer`）の一部として表示される。独自のルートは持たない。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| token | 入力（URLパラメータ） | string | 必須 | プロファイルトークン（親パネル経由） |
| panel | 入力（クエリパラメータ） | string | 必須 | "mailer"（親パネル経由） |

## 表示項目

### ツールバー領域

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| Mailerアイコン | mailer.svgアイコン | 静的リソース |
| メール数 | 送信メール数 | events.messages|length |
| Queued messages | キュー待ちメール数 | events.events|filter(e => e.isQueued()) |
| Sent messages | 送信済みメール数 | events.events|filter(e => not e.isQueued()) |

### パネル領域 - メトリクス

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| Queued | キュー待ちメール数 | events.events filtered |
| Sent | 送信済みメール数 | events.events filtered |

### パネル領域 - メール一覧テーブル（2通以上時のみ）

| 項目名 | 説明 |
|--------|------|
| # | メール番号 |
| Subject | メール件名 |
| To | 宛先 |

### パネル領域 - メール詳細

| 項目名 | 説明 |
|--------|------|
| Status | 送信状態バッジ（Queued=warning, Sent=success） |
| Transport | トランスポート名 |
| Subject | メール件名 |
| From | 送信元アドレス |
| To | 宛先アドレス |
| その他ヘッダー | Subject, From, To以外のヘッダー |

### パネル領域 - 添付ファイル

| 項目名 | 説明 |
|--------|------|
| ファイル名 | 添付ファイル名 |
| ファイルサイズ | ファイルサイズ（humanized） |
| Download | ダウンロードリンク（data URI） |

### パネル領域 - メール本文タブ

| タブ名 | 説明 |
|--------|------|
| Text content | テキスト形式のメール本文 |
| HTML preview | HTML本文のiframeプレビュー |
| HTML content | HTML本文のソースコード表示 |

### パネル領域 - 追加タブ

| タブ名 | 説明 |
|--------|------|
| MIME parts | MIMEパーツ構造のデバッグ表示 |
| Raw Message | 生のメールメッセージ + EMLダウンロードリンク |

## イベント仕様

### 1-メール選択切替

メール一覧テーブルの行をクリックすると、JavaScriptのSymfonyProfilerMailerPanelにより以下が実行される：
1. 前の選択行からactiveクラスを除去
2. クリックされた行にactiveクラスを付加
3. 前のメール詳細を非表示にする
4. 対応するメール詳細を表示する

### 2-本文タブ切替

Text content / HTML preview / HTML contentタブをクリックすると、プロファイラーの標準タブ切替JavaScriptにより対応する本文が表示される。

### 3-添付ファイルダウンロード

添付ファイルのDownloadリンクをクリックすると、data URIスキームにより添付ファイルがダウンロードされる。

### 4-EMLファイルダウンロード

「Download as EML file」リンクをクリックすると、base64エンコードされたメール全体がEMLファイルとしてダウンロードされる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パネル表示 | （なし） | SELECT | Profilerストレージからプロファイルデータを読み込む |

### テーブル別更新項目詳細

本画面ではデータベースの更新は行わない。

## メッセージ仕様

| 条件 | メッセージ | 種別 |
|------|-----------|------|
| メールなし | "No emails were sent." | 情報 |
| テキスト本文なし | "The text body is empty." | 情報 |
| HTML本文なし | "The HTML body is empty." | 情報 |
| 本文なし | "The body is empty." | 情報 |
| 件名なし | "(No subject)" | 情報 |
| 宛先なし | "(empty)" | 情報 |

## 例外処理

- メールが送信されていない場合は空パネルメッセージを表示
- ツールバーはメールが0件の場合は表示されない

## 備考

- MessageDataCollectorはMessageLoggerListenerからMessageEventsを取得してデータを収集する
- base64Encode()メソッドがEMLファイルダウンロードと添付ファイルダウンロードのエンコーディングに使用される
- HTMLプレビューはiframeのsrc属性にdata URIを使用してサンドボックス表示される
- 文字エンコーディング変換（convert_encoding）がテキスト・HTML本文の表示に使用される
- 複数トランスポートが設定されている場合はトランスポート別にセクションが分かれる
- SymfonyProfilerMailerPanelクラスがメール選択のJavaScript操作を制御する（169-187行目）
- ファイルサイズのhuman-readable表示にrender_file_size_humanizedマクロ（502-510行目）を使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MessageDataCollector.php | `src/Symfony/Component/Mailer/DataCollector/MessageDataCollector.php` | MessageLoggerListenerからMessageEventsを取得（27-29行目）。collect()（32-35行目）でeventsをdata['events']に保存。base64Encode()（45-48行目）はテンプレートから呼び出されるヘルパー |

**読解のコツ**: MessageDataCollectorはシンプルなコレクターで、MessageLoggerListenerが記録したイベントをそのまま保存する。MessageEventsクラスのAPIを理解するとテンプレートの理解が深まる。

#### Step 2: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mailer.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/mailer.html.twig` | メーラーパネルのテンプレート。toolbar(191行目)、menu(215行目)、panel(230行目)の3ブロック。3つのマクロ（render_transport_details, render_email_details, render_file_size_humanized） |

**主要処理フロー**:
1. **191-213行目**: ツールバーブロック - メール数、キュー待ち/送信済み数
2. **230-261行目**: パネルブロック - メトリクス、トランスポート別分岐
3. **263-316行目**: render_transport_detailsマクロ - メール一覧テーブル（2通以上時）とメール詳細の表示制御
4. **318-500行目**: render_email_detailsマクロ - メール詳細表示の本体
5. **335-375行目**: メールヘッダー情報（件名、From、To、その他ヘッダー）
6. **377-404行目**: 添付ファイル一覧（ファイル名、サイズ、ダウンロードリンク）
7. **406-476行目**: メール本文タブ（Text content、HTML preview、HTML content）
8. **480-497行目**: MIMEパーツとRaw Messageタブ
9. **502-510行目**: render_file_size_humanizedマクロ - ファイルサイズ表示

#### Step 3: JavaScriptを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | mailer.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/mailer.html.twig` | SymfonyProfilerMailerPanelクラス（169-187行目）。メール行クリックによる選択切替のJavaScript実装 |

**主要処理フロー**:
- **174-185行目**: `#initializeEmailsTable()` - メール行のクリックイベント設定、activeクラスの切替、詳細表示の切替

### プログラム呼び出し階層図

```
ProfilerController::panelAction
    |
    +-- layout.html.twig
           |
           +-- mailer.html.twig (panelブロック)
                  |
                  +-- メトリクス表示
                  +-- トランスポート別分岐
                         |
                         +-- render_transport_details マクロ
                                |
                                +-- メール一覧テーブル（2通以上時）
                                +-- render_email_details マクロ
                                       |
                                       +-- メールヘッダー
                                       +-- 添付ファイル一覧
                                       +-- sf-tabs (本文タブ)
                                       |      +-- Text content
                                       |      +-- HTML preview (iframe)
                                       |      +-- HTML content
                                       |
                                       +-- MIME parts
                                       +-- Raw Message + EMLダウンロード
```

### データフロー図

```
[入力]                    [処理]                           [出力]

Mailer::send() 呼び出し
    |
    +---> MessageLoggerListener
             |
             +---> MessageEvents
                      |
                      +---> MessageDataCollector::collect()
                               |
                               +---> data['events'] -----> パネル表示
                                      |
                                      +-- messages[]
                                      +-- events[]
                                      +-- transports[]
                                      |
                                      +---> base64Encode() --> EML/添付ダウンロード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mailer.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/mailer.html.twig` | テンプレート | メーラーパネルのTwigテンプレート |
| MessageDataCollector.php | `src/Symfony/Component/Mailer/DataCollector/MessageDataCollector.php` | ソース | メール送信データの収集 |
| MessageLoggerListener.php | `src/Symfony/Component/Mailer/EventListener/MessageLoggerListener.php` | ソース | メール送信イベントの記録 |
| MessageEvents.php | `src/Symfony/Component/Mailer/Event/MessageEvents.php` | ソース | メールイベントデータ構造 |
| layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | テンプレート | プロファイラーレイアウト |
