# 画面設計書 31-通知パネル

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する通知パネル（Notifier Panel）の画面設計書である。Notifierコンポーネントを通じて送信された通知の詳細情報をプロファイラー上で確認するためのコレクターパネルである。

### 本画面の処理概要

本画面は、Symfony Notifierコンポーネントによって送信された通知メッセージの一覧と詳細情報を表示するプロファイラーパネルである。

**業務上の目的・背景**：アプリケーション開発時に、SMS・Slack・メールなど各種チャネルを通じた通知の送信状況を確認・デバッグするために必要な画面である。通知が正しく送信されたか、各トランスポートに何件のメッセージが振り分けられたか、キュー投入されたかなどを即座に把握できる。

**画面へのアクセス方法**：Webデバッグツールバーの通知アイコンをクリックするか、プロファイラーパネルの左メニューから「Notifications」を選択してアクセスする。URLは `/_profiler/{token}?panel=notifier` の形式となる。

**主要な操作・処理内容**：
1. 送信された通知メッセージの総数をメトリクスとして表示する
2. トランスポートごとのメッセージ件数を集計して表示する
3. 各トランスポートのメッセージをタブで切り替えて一覧表示する
4. 各メッセージのSubject、Content、Importance、Emoji、例外情報、メッセージオプションを詳細表示する
5. メッセージがキュー投入されたか即時送信されたかのステータスを表示する

**画面遷移**：プロファイラーパネルメイン画面からパネル切替で遷移する。Webデバッグツールバーからも直接遷移可能。他のコレクターパネルへはパネル切替で遷移できる。

**権限による表示制御**：プロファイラーは開発環境（debug=true）でのみ有効。本番環境では表示されない。通知が送信されていない場合はメニューがdisabled状態となり、空メッセージが表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | 通知（Notifier）の送信情報を表示するパネル |
| 41 | Notifier | 主機能 | Notifierコンポーネントによる各チャネルの通知送信情報の表示 |

## 画面種別

詳細（コレクターパネル）

## URL/ルーティング

- **URL**: `/_profiler/{token}?panel=notifier`
- **ルート名**: `_profiler`（パネルパラメータで切替）
- **HTTP メソッド**: GET

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|------|------|
| token | 入力（URLパラメータ） | string | プロファイラートークン |
| panel | 入力（クエリパラメータ） | string | パネル名（"notifier"） |

## 表示項目

### ツールバー表示

| 項目名 | 型 | 説明 |
|--------|------|------|
| 通知アイコン | SVG | Notifierアイコン |
| 送信件数 | integer | 送信された通知メッセージの総数 |
| トランスポート別件数 | integer | 各トランスポート名と件数 |

### メニュー表示

| 項目名 | 型 | 説明 |
|--------|------|------|
| Notificationsラベル | string | メニュー項目名 |
| 件数バッジ | integer | 通知メッセージ総数（0件の場合はdisabled） |

### パネル本体

| 項目名 | 型 | 説明 |
|--------|------|------|
| トランスポート名 | string | 通知送信に使用されたトランスポートの名前 |
| トランスポート別メッセージ数 | integer | 各トランスポートごとのメッセージ件数 |
| メッセージ番号 | integer | メッセージの通し番号 |
| 送信ステータス | string | "queued"（キュー投入）または"sent"（即時送信） |
| Subject | string | 通知メッセージの件名 |
| Content | string | 通知の本文内容 |
| Importance | string | 通知の重要度 |
| Emoji | string | 通知に設定された絵文字 |
| Exception | string | 例外情報（存在する場合） |
| ExceptionAsString | string | 例外の文字列表現 |
| Message Options | JSON | メッセージオプションのJSON表現 |

## イベント仕様

### 1-パネル切替

プロファイラーレイアウトの左メニューから「Notifications」を選択すると、当パネルの内容が表示される。

### 2-ツールバーアイコンクリック

Webデバッグツールバーの通知アイコンをクリックすると、プロファイラーの通知パネルに遷移する。

### 3-メッセージタブ切替

トランスポートごとのメッセージ一覧で、各メッセージのタブを切り替えて詳細情報を閲覧する。タブにはメッセージ番号と送信ステータスが表示される。

### 4-Notification/Message Optionsタブ切替

各メッセージの詳細内で、Notification情報タブとMessage Optionsタブを切り替えて確認する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パネル表示 | - | SELECT | Profilerストレージからプロファイルデータを読み込む（ファイルシステムベース） |

### テーブル別更新項目詳細

データベースへの直接的な更新は行わない。プロファイルデータはファイルシステム上のProfilerストレージに保存される。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|---------|
| 情報 | "No notifications were sent." | 通知メッセージが1件も送信されていない場合 |
| 情報 | "(empty)" | Subject、Content等が空の場合の代替表示 |

## 例外処理

- プロファイラートークンが不明な場合、プロファイラー情報画面（info）にフォールバックする
- NotificationLoggerListenerが未登録の場合、パネルにデータが表示されない

## 備考

- テンプレートファイル: `@WebProfiler/Collector/notifier.html.twig`
- データコレクター: `NotificationDataCollector`（コレクター名: "notifier"）
- NotificationLoggerListenerを通じてNotificationEventsを収集する
- トランスポート名が空文字の場合は `<em>Empty Transport Name</em>` と表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

NotificationEventsオブジェクトが通知データの中心的なデータ構造であり、トランスポートごとのメッセージを管理している。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NotificationEvents.php | `src/Symfony/Component/Notifier/Event/NotificationEvents.php` | トランスポートごとのイベント管理、messages()・transports()・events()メソッドの構造 |
| 1-2 | NotificationLoggerListener.php | `src/Symfony/Component/Notifier/EventListener/NotificationLoggerListener.php` | イベントリスナーによる通知イベントの収集方法 |

**読解のコツ**: NotificationEventsクラスはトランスポート名をキーとしてイベントを分類管理しており、テンプレート側のevents.transportsやevents.messages(transport)と対応する。

#### Step 2: エントリーポイントを理解する

データコレクターがリクエスト処理時に通知データを収集する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | NotificationDataCollector.php | `src/Symfony/Component/Notifier/DataCollector/NotificationDataCollector.php` | collect()メソッド（行30-33）でNotificationLoggerListenerからイベントを取得 |

**主要処理フロー**:
1. **行25-28**: コンストラクタでNotificationLoggerListenerを注入
2. **行30-33**: collect()でlogger.getEvents()を呼び出しデータに格納
3. **行35-38**: getEvents()でテンプレートへNotificationEventsを返却

#### Step 3: テンプレートレンダリングを理解する

Twigテンプレートがcollector.eventsを参照してUI表示を行う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | notifier.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/notifier.html.twig` | toolbar/menu/panelブロックの構成、トランスポートごとのタブ表示 |

**主要処理フロー**:
- **行3-28**: toolbarブロック - ツールバーにアイコンと送信件数を表示
- **行67-80**: menuブロック - サイドメニューにNotificationsラベルと件数を表示
- **行82-168**: panelブロック - トランスポートごとにメッセージ一覧をタブ形式で表示

### プログラム呼び出し階層図

```
ProfilerController::panelAction()
    |
    +-- Profiler::loadProfile(token)
    |       +-- NotificationDataCollector::getEvents()
    |               +-- NotificationLoggerListener::getEvents()
    |                       +-- NotificationEvents
    |
    +-- Twig::render('notifier.html.twig')
            +-- collector.events (NotificationEvents)
                    +-- events.transports (トランスポート名一覧)
                    +-- events.messages(transport) (トランスポート別メッセージ)
                    +-- event.message (MessageInterface)
                    +-- message.notification (Notification)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Notifier送信イベント -------> NotificationLoggerListener -------> NotificationEvents
                              (イベントリスナー)                   (データ収集)
                                     |
                                     v
                              NotificationDataCollector
                              (DataCollector)
                                     |
                                     v
                              notifier.html.twig --------> HTML表示
                              (Twigテンプレート)            (パネル/ツールバー/メニュー)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notifier.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/notifier.html.twig` | テンプレート | パネルUI表示 |
| NotificationDataCollector.php | `src/Symfony/Component/Notifier/DataCollector/NotificationDataCollector.php` | ソース | 通知データの収集 |
| NotificationLoggerListener.php | `src/Symfony/Component/Notifier/EventListener/NotificationLoggerListener.php` | ソース | 通知イベントのロギング |
| NotificationEvents.php | `src/Symfony/Component/Notifier/Event/NotificationEvents.php` | ソース | 通知イベント集合のデータ構造 |
| notifier.svg | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Icon/notifier.svg` | リソース | ツールバー・メニュー用アイコン |
| layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | テンプレート | プロファイラーレイアウト（親テンプレート） |
| toolbar_item.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar_item.html.twig` | テンプレート | ツールバー項目の共通テンプレート |
