# 画面設計書 33-シリアライザーパネル

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供するシリアライザーパネルの画面設計書である。Serializerコンポーネントによるシリアライズ/デシリアライズ処理の詳細情報をプロファイラー上で確認するためのコレクターパネルである。

### 本画面の処理概要

本画面は、Symfony Serializerコンポーネントで行われたシリアライズ・デシリアライズ・ノーマライズ・デノーマライズ・エンコード・デコードの各処理情報を一覧形式で表示する。

**業務上の目的・背景**：REST APIやデータ変換処理を行うアプリケーションにおいて、シリアライザーの動作状況を把握するために必要な画面である。どのノーマライザー・エンコーダーが使用されたか、各処理の実行時間、処理対象のデータ型やコンテキスト情報を確認し、パフォーマンス最適化やデバッグに活用できる。

**画面へのアクセス方法**：Webデバッグツールバーのシリアライザーアイコンをクリックするか、プロファイラーパネルの左メニューから「Serializer」を選択してアクセスする。URLは `/_profiler/{token}?panel=serializer` の形式となる。

**主要な操作・処理内容**：
1. シリアライザー処理の総呼び出し回数と総処理時間をメトリクスとして表示する
2. シリアライザー名ごとにタブを切り替えて処理一覧を表示する
3. serialize/deserialize、normalize/denormalize、encode/decodeの6つのサブタブで処理種別を切り替える
4. 各処理の対象データ（型・内容）、コンテキスト、使用されたノーマライザー/エンコーダー、処理時間、呼び出し元を表示する
5. ネストされたノーマライザー/エンコーダーの詳細をトグル表示する
6. データ内容やコンテキストをprofiler_dumpでトグル表示する

**画面遷移**：プロファイラーパネルメイン画面からパネル切替で遷移する。Webデバッグツールバーからも直接遷移可能。他のコレクターパネルへはパネル切替で遷移できる。

**権限による表示制御**：プロファイラーは開発環境でのみ有効。シリアライザー処理が0件の場合はメニューがdisabled状態となり、空メッセージが表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | シリアライズ/デシリアライズの情報を表示するパネル |
| 25 | Serializer | 主機能 | Serializerコンポーネントによるシリアライズ/デシリアライズの処理情報の表示 |

## 画面種別

一覧・詳細（コレクターパネル）

## URL/ルーティング

- **URL**: `/_profiler/{token}?panel=serializer`
- **ルート名**: `_profiler`（パネルパラメータで切替）
- **HTTP メソッド**: GET

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|------|------|
| token | 入力（URLパラメータ） | string | プロファイラートークン |
| panel | 入力（クエリパラメータ） | string | パネル名（"serializer"） |

## 表示項目

### ツールバー表示

| 項目名 | 型 | 説明 |
|--------|------|------|
| シリアライザーアイコン | SVG | Serializerアイコン |
| 総呼び出し回数 | integer | handledCount |
| Total time | float | 総処理時間（ms単位） |
| Serialize件数 | integer | serialize処理の件数 |
| Deserialize件数 | integer | deserialize処理の件数 |
| Encode件数 | integer | encode処理の件数 |
| Decode件数 | integer | decode処理の件数 |
| Normalize件数 | integer | normalize処理の件数 |
| Denormalize件数 | integer | denormalize処理の件数 |

### メニュー表示

| 項目名 | 型 | 説明 |
|--------|------|------|
| Serializerラベル | string | メニュー項目名 |

### パネル本体

| 項目名 | 型 | 説明 |
|--------|------|------|
| Handled | integer | 処理された総回数 |
| Total time | float | 総処理時間（ms単位、小数2桁） |
| Data（型名） | string | 処理対象のデータ型名 |
| Data（内容） | dump | 処理対象データのダンプ表示（トグル） |
| Context（Type） | string | コンテキストのデータ型 |
| Context（Format） | string | データフォーマット名 |
| Context（詳細） | dump | コンテキスト詳細のダンプ表示（トグル） |
| Normalizer | string | 使用されたノーマライザーのクラス名と処理時間 |
| ネストノーマライザー | list | ネストされたノーマライザーの一覧（呼出回数・クラス名・時間） |
| Encoder | string | 使用されたエンコーダーのクラス名と処理時間 |
| ネストエンコーダー | list | ネストされたエンコーダーの一覧（呼出回数・クラス名・時間） |
| Time | float | 処理時間（ms単位、小数2桁） |
| Caller | string | 呼び出し元のファイル名・行番号（ソースコード抜粋付き） |

## イベント仕様

### 1-パネル切替

プロファイラーレイアウトの左メニューから「Serializer」を選択すると、当パネルの内容が表示される。

### 2-シリアライザー名タブ切替

複数のシリアライザーが登録されている場合、シリアライザー名ごとのタブを切り替えて処理一覧を表示する。

### 3-処理種別サブタブ切替

各シリアライザーの中で、serialize/deserialize、normalize/denormalize、encode/decodeの6つのタブを切り替える。処理がない種別のタブはdisabledとなる。

### 4-データ内容トグル

「Show contents」リンクをクリックすると、処理対象データのprofiler_dumpがトグル表示される。「Hide contents」で非表示にできる。

### 5-コンテキストトグル

「Show context」リンクをクリックすると、コンテキスト詳細のprofiler_dumpがトグル表示される。

### 6-ネストノーマライザー/エンコーダートグル

「Show nested normalizers」または「Show nested encoders」リンクで、ネストされた処理チェーンの詳細一覧をトグル表示する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パネル表示 | - | SELECT | Profilerストレージからプロファイルデータを読み込む |

### テーブル別更新項目詳細

データベースへの直接的な更新は行わない。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|---------|
| 情報 | "Nothing was handled by the serializer." | シリアライザー処理が0件の場合 |
| 情報 | "Nothing was serialized." | serialize処理が0件の場合 |
| 情報 | "Nothing was deserialized." | deserialize処理が0件の場合 |
| 情報 | "Nothing was normalized." | normalize処理が0件の場合 |
| 情報 | "Nothing was denormalized." | denormalize処理が0件の場合 |
| 情報 | "Nothing was encoded." | encode処理が0件の場合 |
| 情報 | "Nothing was decoded." | decode処理が0件の場合 |

## 例外処理

- プロファイラートークンが不明な場合、プロファイラー情報画面にフォールバックする

## 備考

- テンプレートファイル: `@WebProfiler/Collector/serializer.html.twig`
- データコレクター: `SerializerDataCollector`（コレクター名: "serializer"）
- LateDataCollectorInterfaceを実装しており、カーネル終了時にデータを収集する
- TraceableSerializerを通じてシリアライズ処理をトレースする
- テンプレート内でTwigマクロ（render_serializer_tab, render_serialize_tab, render_normalize_tab, render_encode_tab等）を多用して構造化されている
- ノーマライザー/エンコーダーのクラス名はファイルリンク付きで表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

SerializerDataCollectorが管理するデータ構造を理解する。serialize/deserialize/normalize/denormalize/encode/decodeの6種類の処理データがある。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SerializerDataCollector.php | `src/Symfony/Component/Serializer/DataCollector/SerializerDataCollector.php` | DATA_TEMPLATE定数（行28-35）で6種の処理種別を定義、getData()/getHandledCount()/getTotalTime()の算出 |
| 1-2 | TraceableSerializer.php | `src/Symfony/Component/Serializer/Debug/TraceableSerializer.php` | シリアライザー処理の記録構造（data, type, format, context, normalizer, encoder, time, caller） |

**読解のコツ**: DATA_TEMPLATEの6つのキー（serialize, deserialize, normalize, denormalize, encode, decode）がテンプレートの6つのタブに対応している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SerializerDataCollector.php | `src/Symfony/Component/Serializer/DataCollector/SerializerDataCollector.php` | lateCollect()でTraceableSerializerからデータ収集、getSerializerNames()でシリアライザー名一覧取得（行78-80） |

**主要処理フロー**:
1. **行28-35**: DATA_TEMPLATE定数で6種類の処理カテゴリを定義
2. **行57-60**: getData(?name)でシリアライザー名ごとのデータ取得
3. **行62-65**: getHandledCount(?name)で処理件数の集計
4. **行67-76**: getTotalTime()で総処理時間の算出

#### Step 3: テンプレートレンダリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | serializer.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/serializer.html.twig` | render_serializer_tab/render_serialize_tab/render_normalize_tab/render_encode_tabマクロの構成 |

**主要処理フロー**:
- **行31-88**: toolbarブロック - 6種の処理件数と総時間を表示
- **行90-95**: menuブロック - Serializerラベル表示
- **行97-124**: panelブロック - メトリクスとシリアライザー名タブ
- **行126-142**: render_serializer_tabマクロ - 6つのサブタブ（serialize/deserialize/normalize/denormalize/encode/decode）
- **行144-183**: render_serialize_tabマクロ - Data/Context/Normalizer/Encoder/Time/Callerテーブル
- **行295-306**: render_data_cellマクロ - データ内容のトグル表示
- **行326-345**: render_normalizer_cellマクロ - ネストノーマライザーのトグル表示

### プログラム呼び出し階層図

```
ProfilerController::panelAction()
    |
    +-- Profiler::loadProfile(token)
    |       +-- SerializerDataCollector
    |               +-- lateCollect()
    |               |       +-- TraceableSerializer::getCollectedData()
    |               +-- getSerializerNames()
    |               +-- getData(serializerName)
    |               +-- getHandledCount(serializerName)
    |               +-- getTotalTime()
    |
    +-- Twig::render('serializer.html.twig')
            +-- render_serializer_tab(collector, serializerName)
                    +-- render_serialize_tab(data, serialize, name)
                    +-- render_normalize_tab(data, normalize, name)
                    +-- render_encode_tab(data, encode, name)
                            +-- render_data_cell / render_context_cell
                            +-- render_normalizer_cell / render_encoder_cell
                            +-- render_time_cell / render_caller_cell
```

### データフロー図

```
[入力]                           [処理]                              [出力]

Serializer処理呼出 ----------> TraceableSerializer ----------> トレースデータ
(serialize/deserialize等)       (処理記録)                      (data, time, normalizer等)
                                     |
                                     v
                               SerializerDataCollector
                               (lateCollect/名前別グルーピング)
                                     |
                                     v
                               serializer.html.twig --------> HTML表示
                               (6種タブ/テーブル一覧)          (パネル/ツールバー/メニュー)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| serializer.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/serializer.html.twig` | テンプレート | パネルUI表示 |
| SerializerDataCollector.php | `src/Symfony/Component/Serializer/DataCollector/SerializerDataCollector.php` | ソース | シリアライザーデータの収集 |
| TraceableSerializer.php | `src/Symfony/Component/Serializer/Debug/TraceableSerializer.php` | ソース | シリアライザー処理のトレース |
| serializer.svg | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Icon/serializer.svg` | リソース | ツールバー・メニュー用アイコン |
| layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | テンプレート | プロファイラーレイアウト |
