# 画面設計書 34-ワークフローパネル

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供するワークフローパネルの画面設計書である。Workflowコンポーネントで定義されたワークフロー/ステートマシンの状態遷移情報をMermaid図とともに可視化するコレクターパネルである。

### 本画面の処理概要

本画面は、Symfony Workflowコンポーネントで設定されたワークフローの定義（状態遷移図）と、リクエスト中に行われたワークフロー呼び出しの履歴を表示する。

**業務上の目的・背景**：ステートマシンやワークフローを使用したビジネスロジック（受注管理、承認フローなど）の動作確認・デバッグに必要な画面である。ワークフロー定義がMermaid図で視覚的に表示され、各遷移に関連付けられたイベントリスナーも確認できるため、設計意図と実装の整合性を検証できる。

**画面へのアクセス方法**：Webデバッグツールバーのワークフローアイコンをクリックするか、プロファイラーパネルの左メニューから「Workflow」を選択してアクセスする。URLは `/_profiler/{token}?panel=workflow` の形式となる。

**主要な操作・処理内容**：
1. ワークフロー呼び出しの総回数をツールバーに表示する
2. 定義されたワークフローごとにタブを切り替えて情報を表示する
3. 各ワークフローのDefinition（状態遷移図）をMermaid形式で描画する
4. Mermaidノードをクリックすると、そのノードに関連するイベントリスナーをダイアログで表示する
5. ワークフロー呼び出し履歴をテーブル形式で表示する（メソッド名、引数、戻り値、例外、所要時間）
6. Mermaid Live Editorへのリンクを提供する

**画面遷移**：プロファイラーパネルメイン画面からパネル切替で遷移する。Webデバッグツールバーからも直接遷移可能。Mermaid Live Editorへの外部リンクが存在する。

**権限による表示制御**：プロファイラーは開発環境でのみ有効。ワークフローが設定されていない場合はメニューがdisabled状態となり、空メッセージが表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | ワークフローの状態遷移情報を表示するパネル |
| 39 | Workflow | 主機能 | Workflowコンポーネントによる状態遷移の可視化・履歴の表示 |

## 画面種別

詳細・図表（コレクターパネル）

## URL/ルーティング

- **URL**: `/_profiler/{token}?panel=workflow`
- **ルート名**: `_profiler`（パネルパラメータで切替）
- **HTTP メソッド**: GET

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|------|------|
| token | 入力（URLパラメータ） | string | プロファイラートークン |
| panel | 入力（クエリパラメータ） | string | パネル名（"workflow"） |

## 表示項目

### ツールバー表示

| 項目名 | 型 | 説明 |
|--------|------|------|
| ワークフローアイコン | SVG | Workflowアイコン |
| Workflow Calls | integer | ワークフロー呼び出しの総回数 |

### メニュー表示

| 項目名 | 型 | 説明 |
|--------|------|------|
| Workflowラベル | string | メニュー項目名（ワークフローなしの場合disabled） |

### パネル本体

| 項目名 | 型 | 説明 |
|--------|------|------|
| ワークフロー名 | string | タブタイトルに表示されるワークフロー名と呼び出し回数 |
| Definition（Mermaid図） | SVG | MermaidDumperで生成された状態遷移図 |
| Mermaid Liveリンク | URL | mermaid.liveへのリンク |
| 呼び出し番号（#） | integer | 呼び出しの通し番号 |
| Call（メソッド名） | string | 呼び出されたメソッド名（例: can(), apply()） |
| Previous marking | dump | 遷移前のマーキング状態（profiler_dump） |
| Args | dump | 呼び出し引数（profiler_dump） |
| Return | mixed | 戻り値（true/false/dump） |
| Exception | dump | 例外情報（profiler_dump、存在する場合） |
| Duration | float | 呼び出し所要時間（ms単位、小数2桁） |

### イベントリスナーダイアログ

| 項目名 | 型 | 説明 |
|--------|------|------|
| event | string | イベント名（code表示） |
| listener | string | リスナーの詳細（クラス名・メソッド名、ファイルリンク付き） |
| guard expressions | string | ガード式（存在する場合） |

## イベント仕様

### 1-パネル切替

プロファイラーレイアウトの左メニューから「Workflow」を選択すると、当パネルの内容が表示される。

### 2-ワークフロータブ切替

複数ワークフローが定義されている場合、ワークフロー名ごとのタブを切り替える。Mermaid図はタブが表示されたタイミングで動的にレンダリングされる（遅延レンダリング）。

### 3-Mermaidノードクリック

状態遷移図のノード（Place/Transition）をクリックすると、そのノードに関連するイベントリスナーの一覧をモーダルダイアログで表示する。ダイアログはESCキーまたはCloseボタン、ダイアログ外クリックで閉じる。

### 4-Mermaid Live Editorリンク

「View on mermaid.live」リンクをクリックすると、ワークフロー定義をmermaid.liveで開く。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パネル表示 | - | SELECT | Profilerストレージからプロファイルデータを読み込む |

### テーブル別更新項目詳細

データベースへの直接的な更新は行わない。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|---------|
| 情報 | "There are no workflows configured." | ワークフローが1つも設定されていない場合 |

## 例外処理

- プロファイラートークンが不明な場合、プロファイラー情報画面にフォールバックする
- ワークフロー呼び出しで例外が発生した場合、Callsテーブルの該当行のException列にダンプ表示される

## 備考

- テンプレートファイル: `@WebProfiler/Collector/workflow.html.twig`
- データコレクター: `WorkflowDataCollector`（コレクター名: "workflow"）
- LateDataCollectorInterfaceを実装しており、カーネル終了時にデータを収集する
- MermaidDumper（TRANSITION_TYPE_WORKFLOW）を使用してフローチャートを生成する
- Mermaidライブラリ（mermaid-flowchart-v2.min.js）をインライン読み込みし、ダークモード対応のテーマ設定を行う
- ダイアログにはHTML `<dialog>` 要素を使用し、showModal()APIで表示する
- ListenerExtractorを通じてEventDispatcherからワークフローイベントリスナーを抽出する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

WorkflowDataCollectorがワークフロー定義とトレースデータを管理する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WorkflowDataCollector.php | `src/Symfony/Component/Workflow/DataCollector/WorkflowDataCollector.php` | lateCollect()（行48-65）でworkflows配列構築（dump, calls, listeners） |
| 1-2 | TraceableWorkflow.php | `src/Symfony/Component/Workflow/Debug/TraceableWorkflow.php` | getCalls()で呼び出し履歴を記録（method, args, return, exception, duration, previousMarking） |
| 1-3 | MermaidDumper.php | `src/Symfony/Component/Workflow/Dumper/MermaidDumper.php` | ワークフロー定義からMermaid記法への変換 |

**読解のコツ**: WorkflowDataCollectorのlateCollect()で構築されるdata['workflows'][name]の構造（dump, calls, listeners）がテンプレートのdata変数に対応する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | WorkflowDataCollector.php | `src/Symfony/Component/Workflow/DataCollector/WorkflowDataCollector.php` | lateCollect()（行48-65）、getWorkflows()（行77-80）、getCallsCount()とhash() |

**主要処理フロー**:
1. **行36-42**: コンストラクタでworkflowsイテラブルとEventDispatcherを受け取る
2. **行48-65**: lateCollect()で各ワークフローのMermaid図、呼び出し履歴、リスナー情報を構築
3. **行58**: MermaidDumper(TRANSITION_TYPE_WORKFLOW)でフローチャート生成
4. **行62**: getEventListeners()でリスナーマップを構築

#### Step 3: テンプレートレンダリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | workflow.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/workflow.html.twig` | Mermaid初期化、タブ遅延レンダリング、ダイアログ表示 |

**主要処理フロー**:
- **行102-117**: toolbarブロック - callsCountを表示
- **行119-126**: menuブロック - ワークフロー有無でdisabled制御
- **行128-359**: panelブロック
  - **行136-265**: Mermaid初期化スクリプト（テーマ設定、ノードクリックハンドラ、遅延レンダリング）
  - **行267-334**: ワークフロータブ（Definition Mermaid図 + Callsテーブル）
  - **行338-358**: イベントリスナーダイアログ（`<dialog>` 要素）

### プログラム呼び出し階層図

```
ProfilerController::panelAction()
    |
    +-- Profiler::loadProfile(token)
    |       +-- WorkflowDataCollector
    |               +-- lateCollect()
    |               |       +-- TraceableWorkflow::getCalls()
    |               |       +-- MermaidDumper::dump(definition)
    |               |       +-- ListenerExtractor::getEventListeners()
    |               +-- getWorkflows()
    |               +-- getCallsCount()
    |               +-- hash(name)
    |               +-- buildMermaidLiveLink(name)
    |
    +-- Twig::render('workflow.html.twig')
            +-- mermaid.initialize() / mermaid.run()
            +-- showNodeDetails() (ダイアログ表示)
            +-- <dialog> (イベントリスナー表示)
```

### データフロー図

```
[入力]                         [処理]                              [出力]

Workflow呼び出し -----------> TraceableWorkflow -----------> 呼び出し履歴
(can/apply/getMarking等)      (メソッド呼出記録)              (method, args, return, duration)
                                     |
Workflow定義 ------------------> MermaidDumper ------------> Mermaid記法テキスト
                                     |
EventDispatcher ---------------> ListenerExtractor -------> リスナーマップ
                                     |
                                     v
                               WorkflowDataCollector
                               (lateCollect)
                                     |
                                     v
                               workflow.html.twig ---------> HTML表示
                               (Mermaid図/Calls表/Dialog)    (パネル/ツールバー)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| workflow.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/workflow.html.twig` | テンプレート | パネルUI表示 |
| WorkflowDataCollector.php | `src/Symfony/Component/Workflow/DataCollector/WorkflowDataCollector.php` | ソース | ワークフローデータの収集 |
| TraceableWorkflow.php | `src/Symfony/Component/Workflow/Debug/TraceableWorkflow.php` | ソース | ワークフロー呼び出しのトレース |
| MermaidDumper.php | `src/Symfony/Component/Workflow/Dumper/MermaidDumper.php` | ソース | ワークフロー定義のMermaid出力 |
| ListenerExtractor.php | `src/Symfony/Component/Workflow/Debug/ListenerExtractor.php` | ソース | イベントリスナーの抽出 |
| mermaid-flowchart-v2.min.js | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Script/Mermaid/mermaid-flowchart-v2.min.js` | リソース | Mermaid描画ライブラリ |
| workflow.svg | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Icon/workflow.svg` | リソース | アイコン |
| layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | テンプレート | プロファイラーレイアウト |
