# 画面設計書 35-設定パネル

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する設定パネル（Configuration Panel）の画面設計書である。Symfonyのバージョン情報、PHP環境情報、有効なBundleの一覧などのシステム設定情報を表示するコレクターパネルである。

### 本画面の処理概要

本画面は、Symfonyフレームワークとサーバー環境の設定情報を包括的に表示する。プロファイラーツールバーの右端に常時表示される主要パネルの一つである。

**業務上の目的・背景**：アプリケーションの実行環境の全体像を迅速に把握するために必要な画面である。Symfonyバージョンのサポート状態（メンテナンス中・セキュリティ修正のみ・サポート終了）の確認、PHP環境の設定状況（OPcache、APCu、Xdebugの有効/無効）の確認、登録されたBundleの一覧確認など、インフラ・環境面の情報を一元的に表示する。

**画面へのアクセス方法**：Webデバッグツールバー右端のSymfonyロゴ・バージョン番号をクリックするか、プロファイラーパネルの左メニューから「Configuration」を選択してアクセスする。URLは `/_profiler/{token}?panel=config` の形式となる。

**主要な操作・処理内容**：
1. Symfonyバージョン、LTS表示、バージョンサポート状態（開発中/メンテナンス中/セキュリティ修正のみ/サポート終了）をメトリクスとして表示する
2. 環境名（dev/prod）、デバッグモード（enabled/disabled）を表示する
3. Runnerクラス情報を表示する（設定されている場合）
4. PHPバージョン、アーキテクチャ（32/64bit）、Intlロケール、タイムゾーンを表示する
5. OPcache、APCu、Xdebugの有効/無効状態をアイコンで表示する
6. phpinfo()画面やxdebug_info()画面へのリンクを提供する
7. 有効なBundleの一覧をテーブル形式で表示する
8. Symfony公式ドキュメント・サポートチャネルへのリンクを提供する

**画面遷移**：プロファイラーパネルメイン画面からパネル切替で遷移する。Webデバッグツールバーからも直接遷移可能。phpinfo()画面、xdebug_info()画面、Symfonyドキュメント・サポートページへのリンクがある。

**権限による表示制御**：プロファイラーは開発環境でのみ有効。ツールバーにはSymfonyバージョンの状態に応じてステータスカラーが表示される（eol=赤、eom/dev=黄）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | Symfony設定・環境情報を表示するパネル |
| 9 | FrameworkBundle | 主機能 | FrameworkBundleの設定情報（Symfonyvバージョン、PHP版本、環境名等）の表示 |
| 11 | Config | 補助機能 | Configコンポーネントで管理される設定値の表示 |

## 画面種別

詳細（コレクターパネル）

## URL/ルーティング

- **URL**: `/_profiler/{token}?panel=config`
- **ルート名**: `_profiler`（パネルパラメータで切替）
- **HTTP メソッド**: GET

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|------|------|
| token | 入力（URLパラメータ） | string | プロファイラートークン |
| panel | 入力（クエリパラメータ） | string | パネル名（"config"） |

## 表示項目

### ツールバー表示

| 項目名 | 型 | 説明 |
|--------|------|------|
| Symfonyロゴ | SVG | Symfonyアイコン |
| Symfonyバージョン | string | Symfony version（例: "8.1.0"） |
| Profiler token | string | プロファイラートークン（リンク付き） |
| Runner | string | Runnerクラス名（設定されている場合） |
| Environment | string | 環境名（dev, prod等） |
| Debug | string | デバッグモード（enabled/disabled、緑/赤バッジ） |
| PHP version | string | PHPバージョン（phpinfo()リンク付き） |
| PHP Extensions | string | Xdebug/APCu/OPcacheの有効/無効（色付きバッジ） |
| PHP SAPI | string | PHP SAPI名 |
| Resources | link | Symfonyドキュメントリンク |
| Help | link | Symfonyサポートチャネルリンク |

### メニュー表示

| 項目名 | 型 | 説明 |
|--------|------|------|
| Configurationラベル | string | メニュー項目名（eol=赤/eom,dev=黄のステータスラベル） |

### パネル本体 - Symfony Configuration

| 項目名 | 型 | 説明 |
|--------|------|------|
| Runner | string | Runnerクラス名（設定されている場合） |
| Symfony version | string | Symfonyバージョン番号 + LTS表示 |
| Environment | string | 環境名 |
| Debug | string | enabled/disabled |
| バージョンステータスバッジ | string | IN DEVELOPMENT / MAINTAINED / SECURITY FIXES ONLY / UNMAINTAINED |
| Bug fixes期限 | string | バグ修正の期限日（LTS時のみ） |
| Security fixes期限 | string | セキュリティ修正の期限日 |
| リリース詳細リンク | link | symfony.com/releasesへのリンク |

### パネル本体 - PHP Configuration

| 項目名 | 型 | 説明 |
|--------|------|------|
| PHP version | string | PHPバージョン + 追加情報 |
| Architecture | string | 32/64 bits |
| Intl locale | string | Intlデフォルトロケール |
| Timezone | string | デフォルトタイムゾーン |
| OPcache | icon | 有効/無効アイコン + ステータス |
| APCu | icon | 有効/無効アイコン + ステータス |
| Xdebug | icon | 有効/無効アイコン + ステータス（xdebug_info()リンク付き） |
| phpinfo()リンク | link | PHP設定全体表示リンク |

### パネル本体 - Enabled Bundles

| 項目名 | 型 | 説明 |
|--------|------|------|
| Name | string | Bundle名 |
| Class | dump | Bundleクラス名（profiler_dump） |

## イベント仕様

### 1-パネル切替

プロファイラーレイアウトの左メニューから「Configuration」を選択すると、当パネルの内容が表示される。

### 2-ツールバーアイコンクリック

ツールバー右端のSymfonyロゴ/バージョン表示をクリックすると、設定パネルに遷移する。ステータスカラーはSymfonyバージョンの状態に応じて変化する。

### 3-phpinfo()リンク

「View full PHP configuration」リンクまたはツールバーの「View phpinfo()」リンクをクリックすると、`/_profiler/phpinfo` のPHP情報表示画面に遷移する。

### 4-xdebug_info()リンク

Xdebug有効でxdebug_info()が利用可能な場合、Xdebugアイコンまたはリンクをクリックすると、`/_profiler/xdebug` のXdebug情報表示画面に遷移する。

### 5-外部リンク

Symfonyドキュメント、サポートチャネル、リリース詳細へのリンクはsymfony.comの外部サイトに遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パネル表示 | - | SELECT | Profilerストレージからプロファイルデータを読み込む |

### テーブル別更新項目詳細

データベースへの直接的な更新は行わない。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|---------|
| 警告（ツールバー） | "Unable to retrieve information about the Symfony version." | symfonyState == 'unknown'の場合 |
| 警告（ツールバー） | "This Symfony version will no longer receive security fixes." | symfonyState == 'eol'の場合 |
| 警告（ツールバー） | "This Symfony version will only receive security fixes." | symfonyState == 'eom'の場合 |
| 警告（ツールバー） | "This Symfony version is still in the development phase." | symfonyState == 'dev'の場合 |

## 例外処理

- プロファイラートークンが不明な場合、プロファイラー情報画面にフォールバックする
- Kernelが未設定の場合、Environment/Debugは"n/a"と表示される

## 備考

- テンプレートファイル: `@WebProfiler/Collector/config.html.twig`
- データコレクター: `ConfigDataCollector`（コレクター名: "config"）
- LateDataCollectorInterfaceを実装
- ツールバーでは`sf-toolbar-block-right`クラスにより右端に配置される
- Symfonyバージョンの状態判定はKernel::END_OF_MAINTENANCEとKernel::END_OF_LIFEから算出
- runnerClassはSymfony Runtimeコンポーネントとの連携で設定される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ConfigDataCollectorが収集する多数の設定情報を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ConfigDataCollector.php | `src/Symfony/Component/HttpKernel/DataCollector/ConfigDataCollector.php` | collect()（行39-80）でdata配列に格納される項目一覧、determineSymfonyState()によるバージョン状態判定 |

**読解のコツ**: data配列のキー名がテンプレート側の`collector.{key}`に直接対応する。例えば`data['symfony_version']`は`collector.symfonyversion`としてアクセスされる（キャメルケース/スネークケースの変換に注意）。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ConfigDataCollector.php | `src/Symfony/Component/HttpKernel/DataCollector/ConfigDataCollector.php` | collect()メソッドの全体構造（行39-80） |

**主要処理フロー**:
1. **行41-42**: Kernel::END_OF_MAINTENANCE/END_OF_LIFEからeom/eol日付算出
2. **行46-69**: data配列にSymfonyバージョン、PHP情報、環境情報、拡張機能状態を格納
3. **行51**: determineSymfonyState()でバージョンの状態判定（dev/stable/eom/eol）
4. **行71-75**: Bundleの一覧をClassStubとして格納
5. **行77-80**: PHPバージョンから追加情報を分離

#### Step 3: テンプレートレンダリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | config.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/config.html.twig` | 3セクション構成（Symfony Configuration / PHP Configuration / Enabled Bundles） |

**主要処理フロー**:
- **行49-170**: toolbarブロック - バージョン状態別カラー、Profiler token、Runner、PHP情報、外部リンク
- **行172-177**: menuブロック - symfonyState別ステータスラベル
- **行179-324**: panelブロック
  - **行182-250**: Symfony Configuration（バージョン、環境、バージョン状態、期限日）
  - **行252-303**: PHP Configuration（バージョン、アーキテクチャ、拡張機能）
  - **行305-323**: Enabled Bundles（ソート済みBundle一覧テーブル）

### プログラム呼び出し階層図

```
ProfilerController::panelAction()
    |
    +-- Profiler::loadProfile(token)
    |       +-- ConfigDataCollector
    |               +-- collect()
    |               |       +-- Kernel::VERSION / MAJOR_VERSION / MINOR_VERSION
    |               |       +-- Kernel::END_OF_MAINTENANCE / END_OF_LIFE
    |               |       +-- determineSymfonyState()
    |               |       +-- PHP関数 (phpversion, extension_loaded等)
    |               |       +-- KernelInterface::getBundles()
    |               +-- lateCollect() (runnerClass判定)
    |
    +-- Twig::render('config.html.twig')
            +-- Symfony Configuration セクション
            +-- PHP Configuration セクション
            +-- Enabled Bundles セクション
```

### データフロー図

```
[入力]                         [処理]                              [出力]

Kernel設定 -----------------> ConfigDataCollector ---------> 設定データ配列
PHP環境情報 -------->          (collect/lateCollect)          (version, state, php等)
拡張機能状態 ----->                    |
Bundle一覧 ------->                   v
                               config.html.twig -----------> HTML表示
                               (3セクション構成)              (パネル/ツールバー)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| config.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/config.html.twig` | テンプレート | パネルUI表示 |
| ConfigDataCollector.php | `src/Symfony/Component/HttpKernel/DataCollector/ConfigDataCollector.php` | ソース | 設定データの収集 |
| Kernel.php | `src/Symfony/Component/HttpKernel/Kernel.php` | ソース | VERSION, END_OF_MAINTENANCE, END_OF_LIFE定数 |
| config.svg | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Icon/config.svg` | リソース | メニューアイコン |
| symfony.svg | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Icon/symfony.svg` | リソース | ツールバーSymfonyロゴ |
| yes.svg / no.svg | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Icon/` | リソース | 有効/無効表示アイコン |
| layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | テンプレート | プロファイラーレイアウト |
