# 画面設計書 36-コマンドパネル

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供するコマンドパネル（Console Command Panel）の画面設計書である。Consoleコンポーネントで実行されたコンソールコマンドの詳細情報を表示するコレクターパネルである。

### 本画面の処理概要

本画面は、Symfony Consoleコンポーネントで実行されたコマンドの入出力情報、実行パフォーマンス、コマンドの構成情報を包括的に表示する。

**業務上の目的・背景**：バッチ処理やCLIコマンドの実行状況をプロファイラーで確認するために必要な画面である。コマンドの実行時間、メモリ使用量、引数・オプションの設定状況、シグナル処理の状態、サブコマンドの実行関係などを一元的に確認でき、CLIアプリケーションの開発・デバッグに活用できる。

**画面へのアクセス方法**：プロファイラーパネルの左メニューから「Console Command」を選択してアクセスする。URLは `/_profiler/{token}?panel=command` の形式となる。本パネルはCLIリクエスト（CliRequest）でのみデータが収集される。

**主要な操作・処理内容**：
1. コマンドの実行時間（Duration）、ピークメモリ使用量、出力レベル（Verbosity Level）をメトリクスで表示する
2. Signalable、Interactive、Validate Input、Enabled、Visibleの各フラグをアイコンで表示する
3. コマンドの引数（Arguments）とオプション（Options）をテーブル形式で表示する
4. Interactive Inputs（対話入力）を表示する
5. Application inputsを表示する
6. Input/Outputオブジェクトのダンプ表示を行う
7. Helper Setの一覧を表示する
8. サーバーパラメータ（.env定義・通常環境変数）を表示する
9. シグナル処理情報（対応シグナル・処理回数・時間・メモリ）を表示する
10. 親コマンド・サブコマンドへのリンクを提供する

**画面遷移**：プロファイラーパネルメイン画面からパネル切替で遷移する。親コマンド・サブコマンドのプロファイラーへのリンクで別プロファイルへ遷移できる。

**権限による表示制御**：プロファイラーは開発環境でのみ有効。CLIリクエスト以外ではデータが収集されないため、パネルが空になる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | コンソールコマンドの実行情報を表示するパネル |
| 18 | Console | 主機能 | Consoleコンポーネントで実行されたコマンドの入出力・実行結果の表示 |

## 画面種別

詳細（コレクターパネル）

## URL/ルーティング

- **URL**: `/_profiler/{token}?panel=command`
- **ルート名**: `_profiler`（パネルパラメータで切替）
- **HTTP メソッド**: GET

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|------|------|
| token | 入力（URLパラメータ） | string | プロファイラートークン |
| panel | 入力（クエリパラメータ） | string | パネル名（"command"） |

## 表示項目

### メニュー表示

| 項目名 | 型 | 説明 |
|--------|------|------|
| Console Commandラベル | string | メニュー項目名 |

### パネル本体 - Commandタブ

| 項目名 | 型 | 説明 |
|--------|------|------|
| コマンドクラス/executor | string | コマンドクラス名またはexecutor（ファイルリンク付き） |
| Duration | string | 実行時間 |
| Peak Memory Usage | string | ピークメモリ使用量 |
| Verbosity Level | string | silent/quiet/normal/verbose/very verbose/debug |
| Signalable | icon | シグナル対応可否 |
| Interactive | icon | 対話モード可否 |
| Validate Input | icon | 入力バリデーション有効/無効 |
| Enabled | icon | コマンド有効/無効 |
| Visible | icon | コマンド表示/非表示 |
| Arguments | table | コマンド引数のキー・値テーブル（maxDepth: 2） |
| Options | table | コマンドオプションのキー・値テーブル（maxDepth: 2） |
| Interactive Inputs | table | 対話入力のキー・値テーブル（maxDepth: 2、Interactiveモード時のみ） |
| Application inputs | table | アプリケーション入力のキー・値テーブル（maxDepth: 2） |

### パネル本体 - Input / Outputタブ

| 項目名 | 型 | 説明 |
|--------|------|------|
| Input | dump | Inputオブジェクトのprofiler_dump |
| Output | dump | Outputオブジェクトのprofiler_dump |

### パネル本体 - Helper Setタブ

| 項目名 | 型 | 説明 |
|--------|------|------|
| Helpers | dump | ヘルパーオブジェクトの一覧（profiler_dump） |

### パネル本体 - Server Parametersタブ

| 項目名 | 型 | 説明 |
|--------|------|------|
| Defined in .env | bag | .envで定義された環境変数 |
| Defined as regular env variables | table | 通常の環境変数 |

### パネル本体 - Signalsタブ（Signalable時のみ）

| 項目名 | 型 | 説明 |
|--------|------|------|
| Subscribed signals | string | 対応シグナルの一覧 |
| Signal | string | シグナル名 |
| Times handled | integer | 処理回数 |
| Total execution time | string | 合計実行時間（ms） |
| Memory peak | string | メモリピーク（MiB） |

### パネル本体 - 親コマンド/サブコマンド

| 項目名 | 型 | 説明 |
|--------|------|------|
| Parent Command | link | 親コマンドプロファイルへのリンク（存在する場合） |
| Sub Commands | link | サブコマンドプロファイルへのリンク一覧（存在する場合） |

## イベント仕様

### 1-パネル切替

プロファイラーレイアウトの左メニューから「Console Command」を選択すると、当パネルの内容が表示される。

### 2-タブ切替

Command / Input・Output / Helper Set / Server Parameters / Signals / Parent Command / Sub Commands の各タブを切り替える。

### 3-親コマンド/サブコマンドリンク

親コマンドやサブコマンドのプロファイラートークンリンクをクリックすると、対応するプロファイルのプロファイラー画面に遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パネル表示 | - | SELECT | Profilerストレージからプロファイルデータを読み込む |

### テーブル別更新項目詳細

データベースへの直接的な更新は行わない。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|---------|
| 情報 | "No arguments were set" | コマンド引数が空の場合 |
| 情報 | "No options were set" | コマンドオプションが空の場合 |
| 情報 | "No inputs were set" | Interactive Inputsが空の場合 |
| 情報 | "No application inputs are set" | Application inputsが空の場合 |
| 情報 | "No helpers" | Helper Setが空の場合 |
| 情報 | "No signals handled" | シグナルが処理されていない場合 |

## 例外処理

- CLIリクエスト（CliRequest）以外の場合、データが収集されない
- プロファイラートークンが不明な場合、プロファイラー情報画面にフォールバックする

## 備考

- テンプレートファイル: `@WebProfiler/Collector/command.html.twig`
- データコレクター: `CommandDataCollector`（コレクター名: "command"、internal）
- CliRequest経由でのみデータ収集が行われる
- Verbosity Levelはsilent/quiet/normal/verbose/very verbose/debugの6段階
- invokableCommandInfoが設定されている場合はexecutorメソッドを表示し、それ以外はコマンドクラスを表示する
- サーバーパラメータはRequestDataCollector（request_collector）のデータも参照する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

CommandDataCollectorがCliRequestから取得するコマンド情報の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CommandDataCollector.php | `src/Symfony/Component/Console/DataCollector/CommandDataCollector.php` | collect()（行30-80）でCliRequestからコマンド情報を収集するデータ構造 |
| 1-2 | CliRequest.php | `src/Symfony/Component/Console/Debug/CliRequest.php` | CLIリクエストオブジェクトの構造、commandプロパティの定義 |

**読解のコツ**: CommandDataCollectorはcollect()メソッドでCliRequestをチェックし、通常のHTTPリクエストでは何もしない（行32-34）。これによりCLI実行時のみデータが収集される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CommandDataCollector.php | `src/Symfony/Component/Console/DataCollector/CommandDataCollector.php` | collect()でコマンドの各種プロパティを格納する処理フロー |

**主要処理フロー**:
1. **行32-34**: CliRequestでない場合は早期リターン
2. **行39-63**: コマンド情報のdata配列格納（command, exit_code, duration, memory, verbosity, flags等）
3. **行65-80**: アプリケーション定義との差分で引数/オプションを分類（コマンド固有 vs アプリケーション共通）

#### Step 3: テンプレートレンダリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | command.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/command.html.twig` | 多数のタブ構成（Command/IO/Helper Set/Server Parameters/Signals/Parent/Sub Commands） |

**主要処理フロー**:
- **行3-8**: menuブロック - Console Commandラベル
- **行10-249**: panelブロック
  - **行11-19**: コマンドクラス/executorのヘッダー表示
  - **行27-69**: メトリクス（Duration, Peak Memory, Verbosity, Signalable等フラグ）
  - **行71-115**: Arguments/Options/Interactive Inputs/Application inputs
  - **行119-134**: Input / Outputタブ
  - **行136-161**: Helper Setタブ
  - **行163-178**: Server Parametersタブ（dotenvvars + 通常環境変数）
  - **行180-217**: Signalsタブ
  - **行219-248**: Parent Command / Sub Commandsタブ

### プログラム呼び出し階層図

```
ProfilerController::panelAction()
    |
    +-- Profiler::loadProfile(token)
    |       +-- CommandDataCollector
    |       |       +-- collect(CliRequest)
    |       |               +-- command.invokableCommandInfo / command.command
    |       |               +-- command.exitCode / duration / maxMemoryUsage
    |       |               +-- command.arguments / options
    |       |               +-- command.getSubscribedSignals()
    |       +-- RequestDataCollector (Server Parameters用)
    |               +-- dotenvvars / requestserver
    |
    +-- Twig::render('command.html.twig')
            +-- Commandタブ (メトリクス/引数/オプション)
            +-- Input/Outputタブ
            +-- Helper Setタブ
            +-- Server Parametersタブ
            +-- Signalsタブ
            +-- Parent/Sub Commandsタブ
```

### データフロー図

```
[入力]                         [処理]                              [出力]

コンソールコマンド実行 ------> CliRequest構築 ------------> CommandDataCollector
                               (コマンド情報保持)              (collect()でdata格納)
                                     |
                                     v
                               command.html.twig -----------> HTML表示
                               (タブ構成パネル)               (7タブ構成の詳細表示)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| command.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/command.html.twig` | テンプレート | パネルUI表示 |
| CommandDataCollector.php | `src/Symfony/Component/Console/DataCollector/CommandDataCollector.php` | ソース | コマンドデータの収集 |
| CliRequest.php | `src/Symfony/Component/Console/Debug/CliRequest.php` | ソース | CLIリクエストオブジェクト |
| command.svg | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Icon/command.svg` | リソース | メニューアイコン |
| table.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/table.html.twig` | テンプレート | テーブル表示用共通テンプレート |
| bag.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/bag.html.twig` | テンプレート | パラメータバッグ表示用テンプレート |
| layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | テンプレート | プロファイラーレイアウト |
