# 画面設計書 37-Dumpパネル

## 概要

本ドキュメントは、Symfony DebugBundleが提供するDumpパネルの画面設計書である。dump()関数で出力されたデバッグ情報をプロファイラー上で確認するためのコレクターパネルである。

### 本画面の処理概要

本画面は、アプリケーションコード内のdump()関数呼び出しで出力されたデバッグ情報の一覧を表示する。VarDumperコンポーネントにより収集されたデータを、呼び出し元のソースコード情報とともに表示する。

**業務上の目的・背景**：アプリケーション開発時にvar_dump()の代替として使用されるdump()関数の出力を、プロファイラー上で一元的に確認するために必要な画面である。各dump()の呼び出し元ファイル・行番号が特定でき、ソースコード抜粋も確認できるため、デバッグ作業を効率化できる。出力はHTMLフォーマットされたダンプ表示で、折り畳み可能な構造を持つ。

**画面へのアクセス方法**：Webデバッグツールバーのデバッグアイコンをクリックするか、プロファイラーパネルの左メニューから「Debug」を選択してアクセスする。URLは `/_profiler/{token}?panel=dump` の形式となる。

**主要な操作・処理内容**：
1. dump()の呼び出し回数をツールバーに表示する
2. ツールバーにはdump()呼び出しの概要（ファイル名、行番号、ダンプデータ）を表示する
3. パネル本体で各dump()出力を一覧表示する
4. 各dump()出力にはラベル、呼び出し元ファイル名・行番号を表示する
5. 行番号をクリックすると呼び出し元のソースコード抜粋をトグル表示する
6. ダンプデータはVarDumperのHTMLフォーマットで表示する

**画面遷移**：プロファイラーパネルメイン画面からパネル切替で遷移する。Webデバッグツールバーからも直接遷移可能。呼び出し元ファイルへのリンク（IDEリンク）が有効な場合はIDEで直接開ける。

**権限による表示制御**：プロファイラーは開発環境でのみ有効。dump()が1回も呼ばれていない場合はメニューがdisabled状態となり、空メッセージが表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 62 | DebugBundle | 主機能 | dump()で出力されたデバッグ情報を表示するパネル（DebugBundle提供テンプレート） |
| 61 | VarDumper | 主機能 | VarDumperコンポーネントによるdump()出力データの収集・表示 |
| 63 | WebProfilerBundle | 補助機能 | プロファイラーフレームワーク内でのパネルホスティング |

## 画面種別

一覧（コレクターパネル）

## URL/ルーティング

- **URL**: `/_profiler/{token}?panel=dump`
- **ルート名**: `_profiler`（パネルパラメータで切替）
- **HTTP メソッド**: GET

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|------|------|
| token | 入力（URLパラメータ） | string | プロファイラートークン |
| panel | 入力（クエリパラメータ） | string | パネル名（"dump"） |

## 表示項目

### ツールバー表示

| 項目名 | 型 | 説明 |
|--------|------|------|
| デバッグアイコン | SVG | DebugBundle提供のアイコン（icon.svg） |
| dump回数 | integer | dump()の呼び出し回数 |
| ラベル | string | dump()に設定されたラベル（存在する場合） |
| ファイル名 | string | 呼び出し元のファイル名（リンクまたはabbr） |
| 行番号 | integer | 呼び出し元の行番号 |
| ダンプデータ | HTML | dump()のHTML出力 |

### メニュー表示

| 項目名 | 型 | 説明 |
|--------|------|------|
| Debugラベル | string | メニュー項目名（dump0件の場合disabled） |

### パネル本体

| 項目名 | 型 | 説明 |
|--------|------|------|
| ラベル | string | dump()に設定されたラベル（bold表示、存在する場合） |
| ファイル名 | string | 呼び出し元のファイル名（リンクまたはabbr、titleにフルパス） |
| 行番号 | integer | 呼び出し元の行番号（トグルリンク） |
| ソースコード抜粋 | HTML | 呼び出し元のソースコード（fileExcerptまたはfile_excerpt フィルター） |
| ダンプデータ | HTML | dump()のHTMLフォーマット出力（raw） |

## イベント仕様

### 1-パネル切替

プロファイラーレイアウトの左メニューから「Debug」を選択すると、当パネルの内容が表示される。

### 2-ツールバーアイコンクリック

Webデバッグツールバーのデバッグアイコンをクリックすると、プロファイラーのDumpパネルに遷移する。

### 3-ソースコードトグル

パネル内の行番号リンクをクリックすると、呼び出し元のソースコード抜粋がトグル表示される。

### 4-ファイルリンク

呼び出し元のファイル名がリンクとして表示されている場合、クリックするとIDEで該当ファイルを開く（file_link設定に依存）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パネル表示 | - | SELECT | Profilerストレージからプロファイルデータを読み込む |

### テーブル別更新項目詳細

データベースへの直接的な更新は行わない。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|---------|
| 情報 | "No content was dumped." | dump()が一度も呼ばれていない場合 |

## 例外処理

- プロファイラートークンが不明な場合、プロファイラー情報画面にフォールバックする
- ファイルリンクが利用不可の場合、ファイル名はabbr要素（titleにフルパス）で表示される

## 備考

- テンプレートファイル: `@Debug/Profiler/dump.html.twig`（DebugBundle提供）
- データコレクター: `DumpDataCollector`（コレクター名: "dump"）
- DataDumperInterfaceを実装しており、dump()関数呼び出し時にリアルタイムでデータを収集する
- getDumps('html')メソッドでHTML形式のダンプデータを取得する
- 各ダンプエントリはname, file, line, fileExcerpt, data, labelの構造を持つ
- SourceContextProviderを通じて呼び出し元のファイル情報を取得する
- アイコンはDebugBundleの`@Debug/Profiler/icon.svg`を使用する（WebProfilerBundleとは別）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

DumpDataCollectorがDataDumperInterfaceを実装し、dump()呼び出し時にデータを収集する仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DumpDataCollector.php | `src/Symfony/Component/HttpKernel/DataCollector/DumpDataCollector.php` | dump()メソッド（行73-80）でデータ収集、SourceContextProviderから呼び出し元情報取得 |

**読解のコツ**: DumpDataCollectorはDataDumperInterfaceを実装しているため、dump()関数が呼ばれるたびにdump(Data $data)メソッドが実行される。これは通常のDataCollectorのcollect()パターンとは異なる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DumpDataCollector.php | `src/Symfony/Component/HttpKernel/DataCollector/DumpDataCollector.php` | dump()メソッド（行73）、getDumps()メソッド、dumpsCountプロパティ |

**主要処理フロー**:
1. **行73**: dump(Data $data)でStopwatchの開始
2. **行77**: SourceContextProviderからname, file, line, fileExcerptを取得
3. **行79-80**: Connection経由の送信が失敗した場合にローカル収集

#### Step 3: テンプレートレンダリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | dump.html.twig | `src/Symfony/Bundle/DebugBundle/Resources/views/Profiler/dump.html.twig` | toolbar/menu/panelブロック、getDumps('html')の利用 |

**主要処理フロー**:
- **行3-37**: toolbarブロック - dump回数とファイル名・ダンプデータの概要
- **行39-44**: menuブロック - Debugラベル（dump0件でdisabled）
- **行46-83**: panelブロック - 各dump出力の一覧（ラベル、ファイル、行番号、ソースコード抜粋、ダンプデータ）

### プログラム呼び出し階層図

```
dump() 関数呼び出し
    |
    +-- VarDumper::dump()
            +-- DumpDataCollector::dump(Data)
                    +-- SourceContextProvider::getContext()
                    |       (name, file, line, fileExcerpt)
                    +-- データ配列に格納

ProfilerController::panelAction()
    |
    +-- Profiler::loadProfile(token)
    |       +-- DumpDataCollector
    |               +-- getDumps('html')
    |               +-- dumpsCount
    |
    +-- Twig::render('dump.html.twig')
            +-- collector.getDumps('html')
            +-- dump.data|raw (HTML出力)
```

### データフロー図

```
[入力]                         [処理]                              [出力]

dump($var) 呼び出し ---------> VarCloner::cloneVar() -------> Data オブジェクト
                                     |
                                     v
                               DumpDataCollector::dump()
                               + SourceContextProvider
                               (name, file, line, data)
                                     |
                                     v
                               getDumps('html') ------------> HtmlDumper出力
                                     |
                                     v
                               dump.html.twig --------------> HTML表示
                               (一覧/ソース抜粋)              (パネル/ツールバー)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| dump.html.twig | `src/Symfony/Bundle/DebugBundle/Resources/views/Profiler/dump.html.twig` | テンプレート | パネルUI表示 |
| DumpDataCollector.php | `src/Symfony/Component/HttpKernel/DataCollector/DumpDataCollector.php` | ソース | dump()データの収集・HTML化 |
| icon.svg | `src/Symfony/Bundle/DebugBundle/Resources/views/Profiler/icon.svg` | リソース | ツールバー・メニュー用アイコン |
| SourceContextProvider.php | `src/Symfony/Component/VarDumper/Dumper/ContextProvider/SourceContextProvider.php` | ソース | 呼び出し元ファイル情報の取得 |
| HtmlDumper.php | `src/Symfony/Component/VarDumper/Dumper/HtmlDumper.php` | ソース | HTMLフォーマットのダンプ出力 |
| VarCloner.php | `src/Symfony/Component/VarDumper/Cloner/VarCloner.php` | ソース | 変数のクローン・Data化 |
| layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | テンプレート | プロファイラーレイアウト |
