# 画面設計書 38-例外詳細画面（開発環境）

## 概要

本ドキュメントは、Symfony ErrorHandlerコンポーネントが提供する例外詳細画面（開発環境用）の画面設計書である。アプリケーションで例外が発生した際に、スタックトレースやログ情報を含む詳細なデバッグ情報を表示する画面である。

### 本画面の処理概要

本画面は、開発環境（debug=true）でアプリケーション例外が発生した際に表示される詳細なエラーページである。例外のクラス階層、スタックトレース、ソースコード、ログメッセージ、出力内容など、デバッグに必要な情報を包括的に表示する。

**業務上の目的・背景**：開発時にアプリケーションで発生した例外の原因を迅速に特定するために必要な画面である。例外メッセージ、HTTPステータスコード、スタックトレースの詳細、例外チェーン（前の例外）、コードスニペット、ログメッセージなどを一画面で確認でき、デバッグ効率を大幅に向上させる。Symfonyのシンボル的な"ゴースト"イラストが表示される。

**画面へのアクセス方法**：開発環境でアプリケーション例外が発生すると自動的に表示される。ErrorController::__invoke()が呼ばれ、HtmlErrorRenderer::render()によりHTMLが生成される。debug=trueの場合にのみ詳細表示となる。

**主要な操作・処理内容**：
1. 例外のHTTPステータスコードとステータステキストをヘッダーに表示する
2. 例外のクラス階層をパンくずリスト形式で表示する（例外チェーン対応）
3. 例外メッセージを大きなフォントで表示する
4. 「Exceptions」タブで例外ごとのスタックトレースを詳細表示する（コードスニペット付き）
5. 「Logs」タブでリクエスト中のログメッセージを表示する（DebugLoggerがある場合）
6. 「Stack Traces」タブでテキスト形式のスタックトレースを表示する
7. 「Output content」タブで例外発生時の出力バッファ内容を表示する
8. ダークモード/ライトモードのテーマ切替に対応する

**画面遷移**：例外発生時に自動遷移する。例外チェーン内の各例外へのアンカーリンクで画面内ジャンプが可能。Symfonyドキュメントへの外部リンクが存在する。

**権限による表示制御**：debug=trueの場合のみ詳細表示。debug=falseの場合はシンプルなエラー画面（No.39）が表示される。レスポンスヘッダーにX-Debug-Exception、X-Debug-Exception-Fileが付与される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | ErrorHandler | 主機能 | HtmlErrorRendererによる例外詳細（スタックトレース、コードスニペット等）のHTML出力 |
| 2 | HttpKernel | 補助機能 | ErrorControllerおよびErrorListenerによるエラー処理パイプライン |

## 画面種別

エラー詳細（開発環境専用）

## URL/ルーティング

- **URL**: 例外発生時の元URLに対するレスポンスとして表示
- **ルート名**: なし（ErrorController::__invoke()経由）
- **HTTP メソッド**: 元リクエストのメソッド
- **HTTPステータスコード**: 例外に対応するステータスコード（404、500等）

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|------|------|
| exception | 入力 | \Throwable | 発生した例外オブジェクト |

## 表示項目

### ヘッダー部

| 項目名 | 型 | 説明 |
|--------|------|------|
| Symfonyロゴ | SVG | Symfony Exceptionヘッダー（Symfonyクラスが利用可能な場合） |
| Symfonyドキュメントリンク | link | 現在のバージョンのSymfonyドキュメントへのリンク |

### 例外サマリー部

| 項目名 | 型 | 説明 |
|--------|------|------|
| 例外クラス階層 | string | 例外チェーンのクラス名（チェブロン区切り、各例外へのアンカーリンク付き） |
| HTTPステータスコード | integer | 例外に対応するHTTPステータスコード |
| ステータステキスト | string | ステータスコードに対応するテキスト |
| 例外メッセージ | string | 例外メッセージ（長文の場合はlongクラスでフォント調整） |
| ゴーストイラスト | SVG | Symfonyゴーストイラスト（季節イベント対応：バレンタイン/ハロウィン等） |

### Exceptionsタブ

| 項目名 | 型 | 説明 |
|--------|------|------|
| 例外バッジ | integer | 例外の総数（複数例外時） |
| 各例外のトレース | HTML | 例外ごとのスタックトレース（traces.html.php） |

### Logsタブ

| 項目名 | 型 | 説明 |
|--------|------|------|
| エラー件数バッジ | integer | エラーログの件数 |
| ログメッセージ一覧 | HTML | リクエスト中のログメッセージ（logs.html.php） |

### Stack Tracesタブ

| 項目名 | 型 | 説明 |
|--------|------|------|
| テキスト形式トレース | HTML | 例外ごとのテキスト形式スタックトレース（traces_text.html.php） |

### Output contentタブ

| 項目名 | 型 | 説明 |
|--------|------|------|
| 出力バッファ内容 | HTML | 例外発生時の出力バッファ内容 |

## イベント仕様

### 1-例外チェーンナビゲーション

例外サマリー部の例外クラス名をクリックすると、対応する例外のトレースセクション（#trace-box-N）にジャンプする。

### 2-タブ切替

Exceptions / Logs / Stack Traces / Output content の各タブを切り替える。

### 3-スタックトレース展開

スタックトレースの各フレームを展開し、ソースコードスニペットを表示する。ユーザーコードを含む例外はデフォルトで展開される。

### 4-テーマ切替

localStorageの`symfony/profiler/theme`設定またはOSのprefers-color-schemeメディアクエリに基づいてダーク/ライトテーマを適用する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベースへのアクセスは行わない |

### テーブル別更新項目詳細

データベースへの更新は行わない。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|---------|
| 情報 | "No log messages" | DebugLoggerが有効だがログが空の場合 |

## 例外処理

- レンダリング自体が失敗した場合、最低限のプレーンテキストエラーが返される
- Content-Type: text/html; charset={charset}がレスポンスヘッダーに設定される
- X-Debug-Exception: rawurlencode(message)（最大2000文字）がデバッグヘッダーに含まれる
- X-Debug-Exception-File: rawurlencode(file):lineがデバッグヘッダーに含まれる

## 備考

- テンプレートファイル: `src/Symfony/Component/ErrorHandler/Resources/views/exception_full.html.php`（PHPテンプレート）
- レンダラー: `HtmlErrorRenderer`
- FlattenExceptionを使用して例外情報をシリアライズ可能な形式に変換する
- CSSとJavaScriptはインラインで含まれる（assets/css/exception.css, assets/css/exception_full.css, assets/js/exception.js）
- ゴーストイラストは季節イベント（2/14バレンタイン、2/29うるう年、10/18ハロウィン）に応じた特別装飾が追加される
- テーマはlocalStorageまたはprefers-color-schemeで決定される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

FlattenExceptionが例外情報のシリアライズ可能な表現を提供する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FlattenException.php | `src/Symfony/Component/ErrorHandler/Exception/FlattenException.php` | createWithDataRepresentation()でThrowableからの変換、toArray()でスタックトレース構造 |

**読解のコツ**: FlattenExceptionはThrowableオブジェクトをシリアライズ可能な形式に変換し、例外チェーン（getAllPrevious()）、スタックトレース（toArray()）、クラス名・メッセージ・コードなどのアクセサメソッドを提供する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ErrorController.php | `src/Symfony/Component/HttpKernel/Controller/ErrorController.php` | __invoke()（行35-40）でエラーレンダリングとResponse生成 |
| 2-2 | HtmlErrorRenderer.php | `src/Symfony/Component/ErrorHandler/ErrorRenderer/HtmlErrorRenderer.php` | render()（行62-73）でFlattenException生成、renderException()（行125-148）でdebug判定とテンプレート選択 |

**主要処理フロー**:
1. **ErrorController行35-40**: __invoke()でerrorRenderer.render()を呼び出し、Responseを返却
2. **HtmlErrorRenderer行62-73**: render()でFlattenException作成、デバッグヘッダー付与
3. **HtmlErrorRenderer行125-148**: renderException()でdebugフラグに応じてexception_full.html.phpまたはerror.html.phpを選択
4. **HtmlErrorRenderer行330-338**: include()でPHPテンプレートをob_start/ob_get_cleanでレンダリング

#### Step 3: テンプレートレンダリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | exception_full.html.php | `src/Symfony/Component/ErrorHandler/Resources/views/exception_full.html.php` | HTMLフルページ構造、CSS/JS読み込み、テーマ適用 |
| 3-2 | exception.html.php | `src/Symfony/Component/ErrorHandler/Resources/views/exception.html.php` | 例外サマリー、タブ構成（Exceptions/Logs/Stack Traces/Output content） |
| 3-3 | traces.html.php | `src/Symfony/Component/ErrorHandler/Resources/views/traces.html.php` | 各例外のスタックトレース詳細（ソースコードスニペット付き） |
| 3-4 | traces_text.html.php | `src/Symfony/Component/ErrorHandler/Resources/views/traces_text.html.php` | テキスト形式のスタックトレース |
| 3-5 | logs.html.php | `src/Symfony/Component/ErrorHandler/Resources/views/logs.html.php` | ログメッセージ一覧 |

**主要処理フロー**:
- **exception_full.html.php 行1-42**: HTMLフルページ（ヘッダー、テーマ設定、exception.html.phpインクルード、JS）
- **exception.html.php 行1-25**: 例外サマリー（クラス階層、HTTPステータス、メッセージ、ゴーストイラスト）
- **exception.html.php 行28-62**: Exceptionsタブ（ユーザーコード判定によるデフォルト展開制御）
- **exception.html.php 行64-81**: Logsタブ（DebugLoggerがある場合のみ）
- **exception.html.php 行83-103**: Stack Tracesタブ（テキスト形式）
- **exception.html.php 行105-113**: Output contentタブ（出力バッファがある場合のみ）

### プログラム呼び出し階層図

```
ErrorListener::onKernelException()
    |
    +-- ErrorController::__invoke(Throwable)
            |
            +-- HtmlErrorRenderer::render(Throwable)
            |       +-- FlattenException::createWithDataRepresentation()
            |       +-- renderException(FlattenException)
            |               +-- include('exception_full.html.php')
            |                       +-- include('exception.html.php')
            |                       |       +-- include('traces.html.php') x N
            |                       |       +-- include('logs.html.php')
            |                       |       +-- include('traces_text.html.php') x N
            |                       +-- include('assets/css/exception.css')
            |                       +-- include('assets/css/exception_full.css')
            |                       +-- include('assets/js/exception.js')
            |
            +-- new Response(html, statusCode, headers)
```

### データフロー図

```
[入力]                         [処理]                              [出力]

Throwable例外 ---------------> ErrorController -----------> HtmlErrorRenderer
                               (__invoke)                    (render)
                                     |                           |
                                     v                           v
                               FlattenException <---------- createWithDataRepresentation()
                               (シリアライズ形式)
                                     |
                                     v
                               exception_full.html.php ---> HTML完全ページ
                               + exception.html.php         (CSS/JSインライン)
                               + traces.html.php
                               + logs.html.php
                                     |
                                     v
                               Response(HTML, statusCode, headers)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| exception_full.html.php | `src/Symfony/Component/ErrorHandler/Resources/views/exception_full.html.php` | テンプレート | フルページHTML構造 |
| exception.html.php | `src/Symfony/Component/ErrorHandler/Resources/views/exception.html.php` | テンプレート | 例外サマリーとタブ構成 |
| traces.html.php | `src/Symfony/Component/ErrorHandler/Resources/views/traces.html.php` | テンプレート | スタックトレース詳細 |
| traces_text.html.php | `src/Symfony/Component/ErrorHandler/Resources/views/traces_text.html.php` | テンプレート | テキスト形式トレース |
| logs.html.php | `src/Symfony/Component/ErrorHandler/Resources/views/logs.html.php` | テンプレート | ログメッセージ一覧 |
| HtmlErrorRenderer.php | `src/Symfony/Component/ErrorHandler/ErrorRenderer/HtmlErrorRenderer.php` | ソース | HTMLレンダリングエンジン |
| ErrorController.php | `src/Symfony/Component/HttpKernel/Controller/ErrorController.php` | ソース | エラーコントローラー |
| FlattenException.php | `src/Symfony/Component/ErrorHandler/Exception/FlattenException.php` | ソース | 例外のシリアライズ表現 |
| exception.css | `src/Symfony/Component/ErrorHandler/Resources/assets/css/exception.css` | リソース | 例外画面スタイルシート |
| exception_full.css | `src/Symfony/Component/ErrorHandler/Resources/assets/css/exception_full.css` | リソース | フルページ用追加スタイル |
| exception.js | `src/Symfony/Component/ErrorHandler/Resources/assets/js/exception.js` | リソース | 画面操作用JavaScript |
| symfony-ghost.svg.php | `src/Symfony/Component/ErrorHandler/Resources/assets/images/symfony-ghost.svg.php` | リソース | ゴーストイラスト |
