# 画面設計書 39-エラー画面（本番環境）

## 概要

本ドキュメントは、Symfony ErrorHandlerコンポーネントが提供するエラー画面（本番環境用）の画面設計書である。本番環境でアプリケーション例外が発生した際に、ユーザー向けのシンプルなエラーメッセージを表示する画面である。

### 本画面の処理概要

本画面は、本番環境（debug=false）でアプリケーション例外が発生した際に表示されるシンプルなエラーページである。セキュリティ上の観点から、スタックトレースや内部情報を一切含まず、ユーザーフレンドリーなエラーメッセージのみを表示する。

**業務上の目的・背景**：本番環境でエラーが発生した場合に、エンドユーザーに対して適切なエラーメッセージを表示するために必要な画面である。スタックトレースやファイルパスなどの内部情報を隠蔽し、セキュリティを確保しつつ、ユーザーに状況を伝える最低限の情報を提供する。

**画面へのアクセス方法**：本番環境でアプリケーション例外が発生すると自動的に表示される。ErrorController::__invoke()が呼ばれ、HtmlErrorRenderer::render()によりHTMLが生成される。debug=falseの場合にシンプルなエラー画面が選択される。

**主要な操作・処理内容**：
1. HTTPステータスコードとステータステキストをタイトルに表示する
2. 「Oops! An Error Occurred」の汎用エラーメッセージを表示する
3. ステータスコードとステータステキストをサブタイトルに表示する
4. ユーザーへの謝罪メッセージと問い合わせ促進テキストを表示する

**画面遷移**：例外発生時に自動遷移する。この画面からの画面遷移リンクは存在しない。

**権限による表示制御**：debug=falseの場合に表示される。debug=trueの場合は詳細な例外画面（No.38）が表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | ErrorHandler | 主機能 | HtmlErrorRendererによるシンプルなエラーメッセージのHTML出力 |
| 2 | HttpKernel | 補助機能 | ErrorControllerおよびErrorListenerによるエラー処理パイプライン |

## 画面種別

エラー（本番環境用）

## URL/ルーティング

- **URL**: 例外発生時の元URLに対するレスポンスとして表示
- **ルート名**: なし（ErrorController::__invoke()経由）
- **HTTP メソッド**: 元リクエストのメソッド
- **HTTPステータスコード**: 例外に対応するステータスコード（404、500等）

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|------|------|
| exception | 入力 | \Throwable | 発生した例外オブジェクト |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|------|------|
| ページタイトル | string | "An Error Occurred: {ステータステキスト}" |
| ファビコン | SVG | エラーアイコン（インラインSVG） |
| メインヘッダー | string | "Oops! An Error Occurred"（固定テキスト） |
| ステータス表示 | string | 'The server returned a "{ステータスコード} {ステータステキスト}".' |
| 謝罪メッセージ | string | "Something is broken. Please let us know what you were doing when this error occurred. We will fix it as soon as possible. Sorry for any inconvenience caused." |

## イベント仕様

本画面にはインタラクティブなイベントは存在しない。静的なHTML表示のみ。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベースへのアクセスは行わない |

### テーブル別更新項目詳細

データベースへの更新は行わない。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|---------|
| エラー | "Oops! An Error Occurred" | 常に表示 |
| 説明 | 'The server returned a "{statusCode} {statusText}".' | 常に表示 |
| 案内 | "Something is broken. Please let us know what you were doing when this error occurred. We will fix it as soon as possible. Sorry for any inconvenience caused." | 常に表示 |

## 例外処理

- Content-Type: text/html; charset={charset}がレスポンスヘッダーに設定される
- debug=falseのため、X-Debug-Exception等のデバッグヘッダーは付与されない
- HtmlErrorRenderer::setTemplate()で別テンプレートに差し替え可能

## 備考

- テンプレートファイル: `src/Symfony/Component/ErrorHandler/Resources/views/error.html.php`（PHPテンプレート）
- レンダラー: `HtmlErrorRenderer`
- デフォルトテンプレートはHtmlErrorRendererのstatic $templateプロパティで設定されており、setTemplate()で上書き可能
- CSSはインラインで含まれる（assets/css/error.css）
- robots metaタグに"noindex,nofollow,noarchive"が設定される
- 非常にシンプルなHTMLで、外部リソースへの依存がない
- アプリケーション側でTwigベースのカスタムエラーテンプレート（templates/bundles/TwigBundle/Exception/error.html.twig等）で上書きすることが一般的

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

FlattenExceptionからstatusCode/statusTextが取得される最低限のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FlattenException.php | `src/Symfony/Component/ErrorHandler/Exception/FlattenException.php` | getStatusCode()/getStatusText()メソッド |

**読解のコツ**: 本番環境エラー画面ではFlattenExceptionの情報のうち、statusCodeとstatusTextのみが使用される。例外メッセージやスタックトレースは意図的に表示されない。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ErrorController.php | `src/Symfony/Component/HttpKernel/Controller/ErrorController.php` | __invoke()（行35-40） |
| 2-2 | HtmlErrorRenderer.php | `src/Symfony/Component/ErrorHandler/ErrorRenderer/HtmlErrorRenderer.php` | renderException()（行125-148）のdebug=false分岐（行131-135） |

**主要処理フロー**:
1. **ErrorController行35-40**: __invoke()でerrorRenderer.render()を呼び出し
2. **HtmlErrorRenderer行62-73**: render()でFlattenException作成（debug=falseなのでデバッグヘッダーなし）
3. **HtmlErrorRenderer行125-135**: renderException()でdebug=falseの場合、self::$template（views/error.html.php）をインクルード
4. **HtmlErrorRenderer行42**: static $template = 'views/error.html.php'（デフォルトテンプレート）
5. **HtmlErrorRenderer行345-348**: setTemplate()で別テンプレートに差し替え可能

#### Step 3: テンプレートレンダリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | error.html.php | `src/Symfony/Component/ErrorHandler/Resources/views/error.html.php` | 非常にシンプルなHTMLテンプレート（22行） |

**主要処理フロー**:
- **行1-9**: HTML head（charset、robots noindex、タイトル、ファビコン、CSS）
- **行10-19**: body（コンテナ、h1固定テキスト、h2ステータス表示、謝罪文）

### プログラム呼び出し階層図

```
ErrorListener::onKernelException()
    |
    +-- ErrorController::__invoke(Throwable)
            |
            +-- HtmlErrorRenderer::render(Throwable)
            |       +-- FlattenException::createWithDataRepresentation()
            |       +-- renderException(FlattenException)
            |               +-- include('views/error.html.php')
            |                       (statusCode, statusText のみ使用)
            |               +-- include('assets/css/error.css')
            |
            +-- new Response(html, statusCode, headers)
```

### データフロー図

```
[入力]                         [処理]                              [出力]

Throwable例外 ---------------> ErrorController -----------> HtmlErrorRenderer
                               (__invoke)                    (render, debug=false)
                                     |                           |
                                     v                           v
                               FlattenException <---------- createWithDataRepresentation()
                               (statusCode/statusText)
                                     |
                                     v
                               error.html.php -------------> シンプルなHTML
                               (statusCode, statusText      (22行の最小HTML)
                                のみをテンプレートに渡す)
                                     |
                                     v
                               Response(HTML, statusCode, headers)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| error.html.php | `src/Symfony/Component/ErrorHandler/Resources/views/error.html.php` | テンプレート | シンプルなエラーページHTML |
| HtmlErrorRenderer.php | `src/Symfony/Component/ErrorHandler/ErrorRenderer/HtmlErrorRenderer.php` | ソース | HTMLレンダリングエンジン |
| ErrorController.php | `src/Symfony/Component/HttpKernel/Controller/ErrorController.php` | ソース | エラーコントローラー |
| FlattenException.php | `src/Symfony/Component/ErrorHandler/Exception/FlattenException.php` | ソース | 例外のシリアライズ表現 |
| error.css | `src/Symfony/Component/ErrorHandler/Resources/assets/css/error.css` | リソース | エラー画面スタイルシート |
| ErrorRendererInterface.php | `src/Symfony/Component/ErrorHandler/ErrorRenderer/ErrorRendererInterface.php` | ソース | エラーレンダラーインターフェース |
