# 画面設計書 4-プロファイラー検索バー

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する「プロファイラー検索バー」画面の設計書である。本画面はプロファイラーの検索フォーム（検索バー）を表示するサブ画面であり、プロファイラー検索結果画面のサイドバーにインクルードされる。

### 本画面の処理概要

本画面は、プロファイリングデータの検索条件を入力するためのフォームを提供する画面である。

**業務上の目的・背景**：開発者がIPアドレス、HTTPメソッド、ステータスコード、URL、トークン、日付範囲、結果件数などの条件を指定してプロファイリングデータを検索できるようにするための検索フォームを提供する。セッションに保存された前回の検索条件を復元して表示する機能も持ち、繰り返し検索を効率的に行えるようにする。プロファイルタイプ（HTTPリクエスト/コンソールコマンド）に応じてラベルが動的に変化する。

**画面へのアクセス方法**：プロファイラー検索結果画面（No.5）のサイドバーから`render(controller(...))`ディレクティブにより埋め込みレンダリングされる。直接URLアクセスも可能（`/_profiler/search_bar`）。

**主要な操作・処理内容**：
1. リクエストのクエリパラメータまたはセッションから検索条件の初期値を取得
2. 各フォームフィールドに検索条件を設定してsearch.html.twigをレンダリング
3. プロファイルタイプに応じてフォームラベルを動的切り替え（例: IP/Application、Method/Mode、Status/Exit code、URL/Command）
4. フォーム送信時はGETメソッドで`_profiler_search`ルートへ遷移

**画面遷移**：
- 遷移元：プロファイラー検索結果画面（No.5）からの埋め込みレンダリング
- 遷移先：プロファイラー検索（No.3）へフォーム送信

**権限による表示制御**：プロファイラーが有効な環境でのみ動作する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | ProfilerController::searchBarActionによる検索フォームのレンダリング |
| 35 | TwigBundle | 補助機能 | Twig Environmentによるsearch.html.twigテンプレートのレンダリング |
| 1 | HttpFoundation | 補助機能 | RequestおよびSessionから検索条件の取得 |

## 画面種別

検索フォーム（サブ画面・埋め込み）

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| ルート名 | `_profiler_search_bar` |
| URLパターン | `/_profiler/search_bar` |
| HTTPメソッド | GET |
| コントローラー | `web_profiler.controller.profiler::searchBarAction` |

## 入出力項目

### 入力（クエリパラメータ / セッション）

| 項目名 | 入出力 | 型 | 必須 | 説明 | セッションキー |
|--------|--------|-----|------|------|--------------|
| token | 入力 | string | いいえ | プロファイルトークン | `_profiler_search_token` |
| ip | 入力 | string | いいえ | IPアドレスまたはApplication名 | `_profiler_search_ip` |
| method | 入力 | string | いいえ | HTTPメソッドまたはコマンドモード | `_profiler_search_method` |
| status_code | 入力 | string | いいえ | ステータスコードまたは終了コード | `_profiler_search_status_code` |
| url | 入力 | string | いいえ | URLまたはコマンド名 | `_profiler_search_url` |
| start | 入力 | string | いいえ | 検索開始日 | `_profiler_search_start` |
| end | 入力 | string | いいえ | 検索終了日 | `_profiler_search_end` |
| limit | 入力 | string | いいえ | 結果件数上限 | `_profiler_search_limit` |
| type | 入力 | string | いいえ | プロファイルタイプ（デフォルト: request） | `_profiler_search_type` |

## 表示項目

### フォームフィールド一覧

| フィールド名 | ラベル（requestタイプ） | ラベル（commandタイプ） | 入力型 | 選択肢 |
|-------------|----------------------|----------------------|--------|--------|
| ip | IP | Application | text | - |
| method | Method | Mode | select | request: Any/DELETE/GET/HEAD/PATCH/POST/PUT/QUERY、command: Any/BATCH/INTERACTIVE |
| status_code | Status | Exit code | number | request: min=100, max=599、command: min=0, max=255 |
| url | URL | Command | text | - |
| token | Token | Token | text（size=8） | - |
| start | From | From | date | - |
| end | Until | Until | date | - |
| limit | Results | Results | select | 10/50/100 |
| type | (hidden) | (hidden) | hidden | profile_type値 |

### ボタン

| ボタン名 | 種別 | 動作 |
|---------|------|------|
| Search | submit | フォームをGETメソッドで`_profiler_search`へ送信 |

## イベント仕様

### 1-検索フォーム表示

1. `denyAccessIfProfilerDisabled()`でプロファイラー有効性を確認
2. CSPを無効化
3. セッションが利用可能な場合はセッションオブジェクトを取得
4. クエリパラメータ優先、セッション値をフォールバックとして各フォームフィールドの初期値を設定
5. search.html.twigテンプレートをレンダリング

### 2-検索ボタン押下

フォームがGETメソッドで`/_profiler/search`（`_profiler_search`ルート）に送信され、プロファイラー検索（No.3）画面の処理が実行される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 検索フォーム表示 | なし | なし | フォーム表示のみでデータベース操作は発生しない |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| profiler_disabled | エラー | "The profiler must be enabled." | プロファイラーが無効な場合 |

## 例外処理

| 例外クラス | 発生条件 | ユーザーへの影響 |
|-----------|---------|----------------|
| `NotFoundHttpException` | プロファイラーが無効な場合 | HTTP 404エラーページが表示される |

## 備考

- 本画面は通常、検索結果画面のサイドバーに`render(controller(...))`で埋め込みレンダリングされる
- クエリパラメータが指定されていない場合、セッションに保存された前回の検索条件がフォールバック値として使用される
- `_stateless`リクエスト属性がtrueの場合はセッションにアクセスしない
- profile_typeパラメータのセッションキー`_profiler_search_type`のデフォルト値は`request`

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | profiler.php | `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` | `_profiler_search_bar`ルート（21-23行目）の定義を確認 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | `searchBarAction`メソッド（191-218行目）がエントリーポイント。セッションからのフォールバック値取得とテンプレート変数の構築を把握する |

**主要処理フロー**:
1. **193行目**: プロファイラー有効性の確認
2. **195行目**: CSP無効化
3. **197-200行目**: セッションの取得（_stateless属性がfalseかつセッション存在時）
4. **202-214行目**: テンプレート変数の構築（クエリパラメータ優先、セッション値フォールバック）
5. **202-217行目**: search.html.twigのレンダリングとレスポンス返却

#### Step 3: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | search.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/search.html.twig` | 検索フォームの構造。profile_typeに応じたラベルの動的切り替え（5-9行目: IP/Application、17-19行目: Method/Mode等）、フォームフィールドの定義を確認 |

**主要処理フロー**:
- **2行目**: フォームのaction属性が`_profiler_search`ルートを指定
- **5-9行目**: profile_typeに応じたIPフィールドのラベル切り替え
- **23-29行目**: HTTPメソッド/コマンドモードの選択肢の切り替え
- **38-44行目**: ステータスコード/終了コードのmin/max値の切り替え
- **79-83行目**: 結果件数の選択肢（10/50/100）
- **86行目**: profile_typeをhiddenフィールドとして送信

### プログラム呼び出し階層図

```
ProfilerController::searchBarAction($request)
    |
    +-- denyAccessIfProfilerDisabled()
    |       +-- Profiler::disable()
    |
    +-- ContentSecurityPolicyHandler::disableCsp()
    |
    +-- Request::hasSession() / Request::getSession()
    |
    +-- Request::query->get() [各検索条件の取得]
    +-- Session::get() [セッションからのフォールバック値取得]
    |
    +-- Environment::render('@WebProfiler/Profiler/search.html.twig', $variables)
    |
    +-- new Response($html, 200, ['Content-Type' => 'text/html'])
```

### データフロー図

```
[入力]                    [処理]                          [出力]

HTTPリクエスト         --> ProfilerController             --> HTMLレスポンス
(GET /_profiler/           ::searchBarAction()                (search.html.twig)
 search_bar)                    |
    |                      +-- Query params (優先)
    +-- query params       +-- Session values (フォールバック)
    +-- session values          |
                           +-- Twig::render()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | ソース | searchBarActionメソッドを含むコントローラー |
| search.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/search.html.twig` | テンプレート | 検索フォームのテンプレート |
| profiler.php | `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` | 設定 | ルーティング定義（_profiler_search_barルート） |
| results.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/results.html.twig` | テンプレート | 検索結果画面（本画面を埋め込みレンダリングする側） |
