# 画面設計書 40-エラープレビュー

## 概要

本ドキュメントは、Symfony ErrorControllerが提供するエラープレビュー機能の画面設計書である。HTTPステータスコードに対応するエラーページのプレビューを表示するための画面である。

### 本画面の処理概要

本画面は、開発時にHTTPステータスコードに対応するエラーページの見た目を確認するためのプレビュー機能を提供する。実際にエラーを発生させることなく、指定したHTTPステータスコードのエラーページをサブリクエストでレンダリングして表示する。

**業務上の目的・背景**：本番環境で表示されるエラーページのデザイン・内容を、開発環境で事前に確認するために必要な機能である。Twigで作成したカスタムエラーテンプレートの確認や、HTTPステータスコードごとの表示内容の検証に使用される。通常、開発環境ではデバッグ用の詳細エラーページ（No.38）が表示されるため、本番用エラーページを確認する手段として本プレビュー機能が用意されている。

**画面へのアクセス方法**：ブラウザで `/_error/{statusCode}` にアクセスする。例えば `/_error/404` で404エラーページのプレビューを表示する。`/_error/{statusCode}.{format}` の形式でフォーマット（html, json等）を指定することも可能。

**主要な操作・処理内容**：
1. 指定されたHTTPステータスコードに対応するHttpExceptionを生成する
2. サブリクエストを作成し、showException=falseフラグを設定する
3. エラー処理コントローラー（通常はTwigBundleのPreviewErrorController等）を通じてエラーページをレンダリングする
4. レンダリング結果をHTTPレスポンスとして返却する

**画面遷移**：直接URLアクセスにより表示される。画面遷移図ではErrorController -> エラープレビューの流れで示される。表示されるエラーページの内容は、設定されたエラー処理コントローラーに依存する。

**権限による表示制御**：開発環境でのみルーティングが登録される。本番環境ではアクセスできない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | ErrorHandler | 主機能 | ErrorRendererを使用したエラーページのレンダリング |
| 2 | HttpKernel | 主機能 | ErrorController::previewによるサブリクエストを使用したエラーページプレビュー |

## 画面種別

プレビュー（エラーページ確認用）

## URL/ルーティング

- **URL**: `/_error/{code}` または `/_error/{code}.{_format}`
- **ルート名**: `_preview_error`
- **HTTP メソッド**: GET
- **パラメータ**:
  - `code` (integer): HTTPステータスコード（例: 404, 500, 403）
  - `_format` (string, optional): レスポンスフォーマット（例: html, json, xml）

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|------|------|
| code | 入力（URLパラメータ） | integer | プレビューするHTTPステータスコード |
| _format | 入力（URLパラメータ、任意） | string | レスポンスフォーマット（デフォルト: html） |

## 表示項目

表示内容は設定されたエラー処理コントローラーに依存する。デフォルト（HtmlErrorRenderer）の場合は以下の通り。

| 項目名 | 型 | 説明 |
|--------|------|------|
| エラーページ全体 | HTML | 指定されたステータスコードに対応するエラーページ（showException=false） |

カスタムTwigテンプレートが設定されている場合は、そのテンプレートの内容が表示される。

## イベント仕様

### 1-プレビューリクエスト

`/_error/{code}` にアクセスすると、ErrorController::preview()が呼び出される。サブリクエストが生成され、設定されたエラー処理コントローラーで処理される。

### 2-サブリクエスト処理

HttpKernelInterface::SUB_REQUESTとして処理され、ErrorListenerのduplicateRequestと同等のパラメータが設定される。showException=falseにより、本番環境と同じエラーページがレンダリングされる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベースへのアクセスは行わない |

### テーブル別更新項目詳細

データベースへの更新は行わない。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|---------|
| 例外メッセージ | "This is a sample exception." | HttpExceptionに設定されるサンプルメッセージ |

## 例外処理

- 指定されたステータスコードが不正な場合、HttpException内のデフォルト処理に委ねられる
- サブリクエスト処理中に発生した例外は通常のエラー処理パイプラインで処理される

## 備考

- コントローラー: `ErrorController::preview()`
- テンプレートファイル: 設定されたエラー処理コントローラーに依存
- サブリクエストでは`showException: false`が設定されるため、開発環境でも本番用エラーページが表示される
- `_controller`パラメータにはErrorControllerのコンストラクタで注入されたコントローラーが設定される
- `exception`パラメータにはHttpException(code, 'This is a sample exception.')が設定される
- `logger`パラメータにはnullが設定される
- FrameworkBundleのルーティング設定（`_preview_error`）で開発環境にのみ登録されることが一般的

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

HttpExceptionがサンプル例外として生成され、サブリクエストの属性として渡される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | HttpException.php | `src/Symfony/Component/HttpKernel/Exception/HttpException.php` | ステータスコードとメッセージを保持する例外クラス |

**読解のコツ**: プレビュー機能では実際のアプリケーション例外ではなく、HttpException(code, 'This is a sample exception.')というサンプル例外が使われる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ErrorController.php | `src/Symfony/Component/HttpKernel/Controller/ErrorController.php` | preview()メソッド（行42-57） |

**主要処理フロー**:
1. **行28-33**: コンストラクタでHttpKernelInterface、コントローラー、ErrorRendererInterfaceを注入
2. **行42**: preview(Request $request, int $code)でプレビュー処理開始
3. **行49-54**: サブリクエストを生成し、_controller、exception、logger、showExceptionを設定
4. **行51**: HttpException($code, 'This is a sample exception.')でサンプル例外生成
5. **行53**: showException: falseで本番環境と同じ表示を強制
6. **行56**: kernel->handle(subRequest, SUB_REQUEST)でサブリクエスト処理

#### Step 3: サブリクエスト処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ErrorController.php | `src/Symfony/Component/HttpKernel/Controller/ErrorController.php` | $this->controller（行30）に設定されたエラー処理コントローラーがサブリクエストで呼ばれる |

**主要処理フロー**:
- **行30**: コンストラクタのcontrollerパラメータ - string|object|array|null型。通常はTwigBundleのPreviewErrorControllerやErrorController自身の__invoke()が設定される
- **行56**: HttpKernelInterface::SUB_REQUESTとして処理される

### プログラム呼び出し階層図

```
ブラウザ: /_error/{code}
    |
    +-- Router: _preview_error ルートマッチ
            |
            +-- ErrorController::preview(Request, code)
                    |
                    +-- Request::duplicate() でサブリクエスト生成
                    |       _controller: $this->controller
                    |       exception: new HttpException(code, 'This is a sample exception.')
                    |       logger: null
                    |       showException: false
                    |
                    +-- HttpKernelInterface::handle(subRequest, SUB_REQUEST)
                            |
                            +-- 設定されたエラー処理コントローラー
                            |       (例: TwigBundle PreviewErrorController)
                            |       (例: ErrorController::__invoke())
                            |
                            +-- エラーページHTMLレンダリング
                                    +-- Response
```

### データフロー図

```
[入力]                         [処理]                              [出力]

/_error/{code} URL ---------> ErrorController::preview() --> HttpException生成
                               (code=HTTPステータスコード)    (サンプルメッセージ)
                                     |
                                     v
                               Request::duplicate() -------> サブリクエスト
                               (_controller, exception,      (showException=false)
                                showException=false)
                                     |
                                     v
                               HttpKernel::handle() -------> エラー処理コントローラー
                               (SUB_REQUEST)                  (エラーページレンダリング)
                                     |
                                     v
                               Response --------------------> エラーページHTML表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ErrorController.php | `src/Symfony/Component/HttpKernel/Controller/ErrorController.php` | ソース | プレビュー機能の実装 |
| HttpException.php | `src/Symfony/Component/HttpKernel/Exception/HttpException.php` | ソース | サンプル例外クラス |
| HtmlErrorRenderer.php | `src/Symfony/Component/ErrorHandler/ErrorRenderer/HtmlErrorRenderer.php` | ソース | デフォルトのHTMLレンダラー |
| ErrorRendererInterface.php | `src/Symfony/Component/ErrorHandler/ErrorRenderer/ErrorRendererInterface.php` | ソース | エラーレンダラーインターフェース |
| error.html.php | `src/Symfony/Component/ErrorHandler/Resources/views/error.html.php` | テンプレート | デフォルトエラーテンプレート |
| ErrorListener.php | `src/Symfony/Component/HttpKernel/EventListener/ErrorListener.php` | ソース | エラーイベントリスナー（duplicateRequestの参照元） |
