# 画面設計書 41-テンプレート表示

## 概要

本ドキュメントは、Symfony FrameworkBundleが提供する汎用テンプレート表示コントローラー（TemplateController）の画面設計書である。ルーティング設定で指定された任意のTwigテンプレートをレンダリングして表示する汎用的な仕組みを提供する。

### 本画面の処理概要

**業務上の目的・背景**：Webアプリケーション開発において、静的ページやシンプルな表示のみのページを作成する際に、専用のコントローラークラスを作成する手間を省くために存在する。ルーティング設定だけで任意のTwigテンプレートを表示できるため、開発効率が大幅に向上する。特に、利用規約ページ、Aboutページ、ランディングページなど、ビジネスロジックを伴わない静的コンテンツの表示に適している。

**画面へのアクセス方法**：ルーティング設定（YAML/XML/PHP/アトリビュート）でTemplateControllerを指定し、`template`パラメータに表示したいTwigテンプレートのパスを設定する。ユーザーは設定されたURLパスにHTTPリクエストを送信することでアクセスする。

**主要な操作・処理内容**：
1. ルーティング設定で指定されたTwigテンプレートをTwig Environmentを使用してレンダリングする
2. `context`パラメータで指定されたテンプレート変数をテンプレートに渡す
3. キャッシュ制御パラメータ（maxAge、sharedAge、private）に基づいてHTTPレスポンスヘッダーを設定する
4. カスタムHTTPステータスコードおよびカスタムヘッダーの設定が可能
5. レンダリング結果をHTTPレスポンスとして返却する

**画面遷移**：本コントローラーは汎用的なテンプレート表示機能であるため、遷移元・遷移先はルーティング設定に依存する。レンダリングされたテンプレート内のリンクやフォームによって任意のページへ遷移可能である。

**権限による表示制御**：TemplateController自体には権限制御機能は組み込まれていない。権限制御が必要な場合は、Symfonyのセキュリティコンポーネント（ファイアウォール設定やアクセス制御リスト）をルーティングレベルで設定する必要がある。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | FrameworkBundle | 主機能 | TemplateControllerによる任意のTwigテンプレートのレンダリング |
| 35 | TwigBundle | 主機能 | Twig Environmentによるテンプレートのレンダリング処理 |
| 45 | Cache | 補助機能 | レスポンスキャッシュ設定（maxAge、sharedAge）の管理 |

## 画面種別

汎用テンプレート表示（テンプレートレンダリング）

## URL/ルーティング

ルーティング設定により任意のURLを割り当て可能。以下はルーティング設定例：

```yaml
# config/routes.yaml
app_about:
    path: /about
    controller: Symfony\Bundle\FrameworkBundle\Controller\TemplateController
    defaults:
        template: 'static/about.html.twig'
        maxAge: 86400
        sharedAge: 86400
```

TemplateControllerは`__invoke()`メソッドを実装しているため、呼び出し可能なコントローラー（invokable controller）として直接指定できる。

## 入出力項目

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|------|------|-------------|------|
| template | string | はい | - | レンダリングするTwigテンプレートのパス |
| maxAge | int\|null | いいえ | null | クライアントキャッシュの最大有効期間（秒） |
| sharedAge | int\|null | いいえ | null | 共有（プロキシ）キャッシュの最大有効期間（秒） |
| private | bool\|null | いいえ | null | キャッシュをクライアントのみに限定するかどうか |
| context | array | いいえ | [] | テンプレートに渡すコンテキスト変数の配列 |
| statusCode | int | いいえ | 200 | HTTPステータスコード |
| headers | array | いいえ | [] | レスポンスに追加するHTTPヘッダー |

## 表示項目

指定されたTwigテンプレートの内容に依存する。TemplateController自体は表示項目を定義しない。

## イベント仕様

### 1-テンプレートレンダリング

ルーティングで設定されたURLへのHTTPリクエスト受信時に以下の処理が実行される：

1. `__invoke()`メソッドが呼び出され、`templateAction()`に処理を委譲する
2. Twig Environmentの存在を確認し、存在しない場合は`LogicException`をスローする
3. `$this->twig->render($template, $context)`でテンプレートをレンダリングする
4. レンダリング結果から`Response`オブジェクトを生成する
5. キャッシュ制御パラメータに基づいてレスポンスヘッダーを設定する
6. カスタムヘッダーを設定してレスポンスを返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| テンプレートレンダリング | なし | なし | データベースへのアクセスは発生しない |

TemplateControllerはデータベースアクセスを行わない。テンプレート内でデータベースアクセスが必要な場合は、`context`パラメータを通じてデータを渡すか、Twigエクステンションを利用する。

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|-------------|------|-------------|
| エラー | TwigBundleが未インストール | "You cannot use the TemplateController if the Twig Bundle is not available. Try running \"composer require symfony/twig-bundle\"." |

## 例外処理

| 例外クラス | 発生条件 | 処理内容 |
|-----------|---------|---------|
| \LogicException | Twig Environmentが注入されていない（TwigBundleが未インストール） | エラーメッセージを表示し、composer requireコマンドを案内する |
| Twig\Error\LoaderError | 指定されたテンプレートが見つからない | Twigのテンプレートローダーエラーが発生する |
| Twig\Error\RuntimeError | テンプレートのレンダリング中にエラーが発生 | Twigランタイムエラーが発生する |
| Twig\Error\SyntaxError | テンプレートの構文エラー | Twig構文エラーが発生する |

## 備考

- TemplateControllerは`final`クラスとして宣言されており、継承による拡張は不可である
- `__invoke()`メソッドが実装されているため、ルーティング設定でアクション名を省略できる
- キャッシュ制御のロジック：`private`がtrue→プライベートキャッシュ、`private`がfalse→パブリックキャッシュ、`private`がnullかつmaxAgeまたはsharedAgeが設定されている→パブリックキャッシュ
- テンプレートのコンテキスト変数はルーティング設定の`defaults`セクションで定義可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

TemplateControllerが受け取るパラメータとレスポンスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Response.php | `src/Symfony/Component/HttpFoundation/Response.php` | HTTPレスポンスの構造、キャッシュ制御メソッド（setMaxAge, setSharedMaxAge, setPublic, setPrivate）の仕様を理解する |

**読解のコツ**: Symfonyのコントローラーは必ずResponseオブジェクトを返す。キャッシュ制御はResponseオブジェクトのメソッドを通じて行われる。

#### Step 2: エントリーポイントを理解する

TemplateControllerの処理フローを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TemplateController.php | `src/Symfony/Bundle/FrameworkBundle/Controller/TemplateController.php` | コントローラー全体の処理フローを理解する |

**主要処理フロー**:
1. **L26-29**: コンストラクタでTwig Environmentをオプショナルに受け取る
2. **L42**: `templateAction()`メソッドのシグネチャ - 全パラメータの定義
3. **L44-46**: TwigBundleの存在チェック、未インストール時のLogicException
4. **L48**: TwigテンプレートのレンダリングとResponseオブジェクトの生成
5. **L50-52**: maxAgeの設定
6. **L54-56**: sharedMaxAgeの設定
7. **L58-62**: private/publicキャッシュの設定ロジック
8. **L64-66**: カスタムHTTPヘッダーの設定
9. **L68**: Responseの返却
10. **L74-77**: `__invoke()`メソッドから`templateAction()`への委譲

#### Step 3: Twigレンダリング処理を理解する

テンプレートが実際にどのようにレンダリングされるかを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Environment.php | `vendor/twig/twig/src/Environment.php` | `render()`メソッドの処理フロー、テンプレートのロードとレンダリングの流れを理解する |

**主要処理フロー**:
- `Environment::render()`: テンプレート名からテンプレートオブジェクトをロードし、コンテキスト変数とともにレンダリングする

### プログラム呼び出し階層図

```
TemplateController::__invoke()
    |
    +-- TemplateController::templateAction()
            |
            +-- Environment::render($template, $context)
            |       |
            |       +-- Environment::load($template)
            |       |       +-- テンプレートファイルの読み込み
            |       |
            |       +-- Template::render($context)
            |               +-- テンプレートのレンダリング実行
            |
            +-- new Response($content, $statusCode)
            |
            +-- Response::setMaxAge($maxAge)
            |
            +-- Response::setSharedMaxAge($sharedAge)
            |
            +-- Response::setPrivate() / Response::setPublic()
            |
            +-- Response::headers->set($key, $value)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

HTTPリクエスト -------> ルーティング解決 -------> TemplateController
                        (template, context,       |
                         maxAge, sharedAge,       |
                         private, statusCode,     v
                         headers)          Twig::render()
                                                  |
                                                  v
                                           Response生成
                                           (HTML + キャッシュヘッダー)
                                                  |
                                                  v
                                           HTTPレスポンス -------> クライアント
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TemplateController.php | `src/Symfony/Bundle/FrameworkBundle/Controller/TemplateController.php` | ソース | 汎用テンプレート表示コントローラー本体（全78行） |
| Response.php | `src/Symfony/Component/HttpFoundation/Response.php` | ソース | HTTPレスポンスクラス、キャッシュ制御メソッドを提供 |
| Environment.php | `vendor/twig/twig/src/Environment.php` | ソース（外部ライブラリ） | Twigテンプレートエンジンの環境クラス |
