# 画面設計書 43-フォームレイアウト（div）

## 概要

本ドキュメントは、Symfony Twig Bridgeが提供するdiv要素ベースの標準フォームレイアウトテーマ（form_div_layout.html.twig）の画面設計書である。Symfonyフォームコンポーネントのフォーム要素をHTML div要素を使用してレンダリングするための基盤テンプレートである。

### 本画面の処理概要

**業務上の目的・背景**：Webアプリケーションにおけるフォーム入力画面は最も基本的なUI要素の一つである。form_div_layoutは、Symfonyフォームコンポーネントが生成するフォーム要素を、セマンティックなHTML構造（div要素ベース）でレンダリングするためのデフォルトテーマである。CSSフレームワークに依存しない汎用的なHTML出力を提供し、すべてのBootstrapテーマやFoundationテーマの基盤となっている。

**画面へのアクセス方法**：Symfonyのフォーム設定（`twig.form_themes`）でこのテーマを指定するか、デフォルトのまま使用する。フォームを含むTwigテンプレートで`{{ form(form) }}`や`{{ form_widget(form) }}`などのフォームヘルパー関数を呼び出すことでレンダリングされる。

**主要な操作・処理内容**：
1. フォームウィジェットの描画（テキスト入力、セレクト、チェックボックス、ラジオボタン等の各種入力要素）
2. フォームラベルの描画（label要素の生成、翻訳対応、required属性の付与）
3. フォームエラーの描画（バリデーションエラーメッセージのul/li構造での表示）
4. フォーム行（row）の描画（label + widget + error + helpの組み合わせをdivでラップ）
5. フォームヘルプテキストの描画（補足説明テキストの表示）
6. フォームの開始/終了タグの生成（form要素、CSRFトークン、_methodフィールド）
7. コレクションウィジェット（動的フォームフィールド）のプロトタイプ対応
8. 日付/時刻/金額/パーセント等の複合ウィジェットの描画

**画面遷移**：本テーマファイル自体は画面遷移を定義しない。フォームのsubmitアクションにより、フォームを含むページのルーティング設定に基づいて遷移する。

**権限による表示制御**：テーマファイル自体には権限制御機能はない。フォーム要素のdisabled属性やrequired属性はフォームビルダーの設定に基づいて制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | Form | 主機能 | div要素ベースの標準フォームレイアウトテーマによるフォームレンダリング |
| 36 | Twig Bridge | 主機能 | Twig Bridgeのフォームレンダリング拡張によるフォームブロック定義 |

## 画面種別

フォームテーマ（Twigテンプレート断片）

## URL/ルーティング

本テーマファイルは直接URLに紐づかない。Symfonyの設定で指定されるフォームテーマテンプレートとして機能する。

```yaml
# config/packages/twig.yaml
twig:
    form_themes: ['form_div_layout.html.twig']  # デフォルト
```

## 入出力項目

### フォームウィジェット共通変数

| 変数名 | 型 | 説明 |
|--------|------|------|
| id | string | フォーム要素のID属性 |
| name | string | フォーム要素の名前 |
| full_name | string | フォーム要素の完全な名前（ネスト対応） |
| value | mixed | フォーム要素の値 |
| type | string | input要素のtype属性 |
| disabled | bool | 無効化フラグ |
| required | bool | 必須フラグ |
| attr | array | 追加HTML属性 |
| label | string\|false | ラベルテキスト |
| label_attr | array | ラベルの追加HTML属性 |
| help | string | ヘルプテキスト |
| help_attr | array | ヘルプテキストの追加HTML属性 |
| errors | FormErrorIterator | バリデーションエラー |
| compound | bool | 複合フォーム（子要素を持つ）かどうか |
| translation_domain | string\|false | 翻訳ドメイン |
| row_attr | array | 行ラッパー要素の追加HTML属性 |

## 表示項目

### 定義されているTwigブロック一覧

| ブロック名 | 説明 | 出力HTML構造 |
|-----------|------|-------------|
| form_widget | ウィジェットの振り分け（compound/simple） | compound→form_widget_compound、それ以外→form_widget_simple |
| form_widget_simple | 単純な入力要素 | `<input type="..." />` |
| form_widget_compound | 複合ウィジェット | `<div>...子要素...</div>` |
| textarea_widget | テキストエリア | `<textarea>...</textarea>` |
| choice_widget | 選択要素の振り分け | expanded→choice_widget_expanded、それ以外→choice_widget_collapsed |
| choice_widget_expanded | 展開選択（チェックボックス/ラジオ群） | `<div>...<input>...<label>...</div>` |
| choice_widget_collapsed | 折りたたみ選択 | `<select>...<option>...</select>` |
| checkbox_widget | チェックボックス | `<input type="checkbox" />` |
| radio_widget | ラジオボタン | `<input type="radio" />` |
| datetime_widget | 日時入力 | 単一テキストまたは日付+時刻の複合 |
| date_widget | 日付入力 | 単一テキストまたはyear/month/dayの複合 |
| time_widget | 時刻入力 | 単一テキストまたはhour/minute/secondの複合 |
| number_widget | 数値入力 | `<input type="text" />` |
| integer_widget | 整数入力 | `<input type="number" />` |
| money_widget | 金額入力 | 通貨記号付きinput |
| percent_widget | パーセント入力 | `%`記号付きinput |
| password_widget | パスワード入力 | `<input type="password" />` |
| hidden_widget | 隠しフィールド | `<input type="hidden" />` |
| email_widget | メール入力 | `<input type="email" />` |
| url_widget | URL入力 | `<input type="url" />` |
| search_widget | 検索入力 | `<input type="search" />` |
| tel_widget | 電話番号入力 | `<input type="tel" />` |
| color_widget | カラー入力 | `<input type="color" />` |
| range_widget | レンジ入力 | `<input type="range" />` |
| button_widget | ボタン | `<button type="button">...</button>` |
| submit_widget | 送信ボタン | `<button type="submit">...</button>` |
| reset_widget | リセットボタン | `<button type="reset">...</button>` |
| form_label | フォームラベル | `<label for="...">...</label>` |
| form_help | ヘルプテキスト | `<div class="help-text">...</div>` |
| form_row | フォーム行 | `<div>label + errors + widget + help</div>` |
| form_errors | エラー表示 | `<ul><li>...</li></ul>` |
| form_start | フォーム開始タグ | `<form ...>` |
| form_end | フォーム終了タグ | `</form>` |
| form_rest | 未レンダリングフィールドの出力 | 残りのフォーム行を出力 |

## イベント仕様

### 1-フォームレンダリング

Twigテンプレート内でフォームヘルパー関数が呼ばれた際に、対応するブロックが実行される：

1. `{{ form(form) }}` → `form`ブロック（form_start + form_widget + form_end）
2. `{{ form_start(form) }}` → `form_start`ブロック（formタグ生成、_methodフィールド挿入）
3. `{{ form_row(form.field) }}` → `form_row`ブロック（aria属性の計算 → form_row_render）
4. `{{ form_widget(form.field) }}` → 型に応じたwidgetブロックが選択される
5. `{{ form_label(form.field) }}` → `form_label`ブロック（ラベル生成、翻訳処理）
6. `{{ form_errors(form.field) }}` → `form_errors`ブロック（エラーメッセージリスト生成）
7. `{{ form_help(form.field) }}` → `form_help`ブロック（ヘルプテキスト生成）
8. `{{ form_end(form) }}` → `form_end`ブロック（未レンダリングフィールド出力 + formタグ閉じ）
9. `{{ form_rest(form) }}` → `form_rest`ブロック（未レンダリング子要素の一括出力）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フォームレンダリング | なし | なし | テンプレートはHTMLレンダリングのみ。データベース操作は含まない |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|-------------|------|-------------|
| バリデーションエラー | errors が存在する場合 | `error.message`（FormErrorオブジェクトのメッセージ） |

## 例外処理

テーマテンプレート自体は例外をスローしない。フォームのバリデーションエラーは`form_errors`ブロックで表示される。

## 備考

- form_div_layoutは他のすべてのフォームテーマ（bootstrap_base_layout, form_table_layout等）の基盤テンプレートである
- Twigの`use`タグにより継承・オーバーライドが可能
- `translation_domain`が`false`の場合、翻訳処理はスキップされる
- `label_html`が`true`の場合、ラベルテキストはHTMLエスケープされずにそのまま出力される（`|raw`フィルター）
- form_rowブロックではaria-describedby属性とaria-invalid属性をアクセシビリティのために自動生成する
- `_method`隠しフィールドは、GET/POST以外のHTTPメソッド（PUT, DELETE等）をシミュレートするために使用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フォームビューの変数（FormView）の構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FormView.php | `src/Symfony/Component/Form/FormView.php` | フォームビューの構造（vars, children, parent等）を理解する |

**読解のコツ**: Twigテンプレート内でアクセスされるフォーム変数（id, name, value, attr等）はすべてFormView::varsに格納されている。

#### Step 2: エントリーポイントを理解する

form_div_layoutテンプレートの全体構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | テンプレート全体の構造とブロック定義の階層を理解する |

**主要処理フロー**:
1. **L1-9**: `form_widget`ブロック - compound/simpleの振り分け
2. **L11-18**: `form_widget_simple`ブロック - input要素の生成
3. **L20-28**: `form_widget_compound`ブロック - div要素による複合ウィジェット
4. **L41-47**: `choice_widget`ブロック - expanded/collapsedの振り分け
5. **L58-82**: `choice_widget_collapsed`ブロック - select要素の生成（preferred_choices対応）
6. **L267-279**: `form_label`ブロック - label要素の生成
7. **L311-318**: `form_help`ブロック - ヘルプテキストの生成
8. **L346-363**: `form_row`ブロック - aria属性の計算
9. **L365-372**: `form_row_render`ブロック - label + errors + widget + helpの配置
10. **L386-411**: `form_start`/`form_end`ブロック - formタグの生成
11. **L413-421**: `form_errors`ブロック - エラーメッセージのul/li出力
12. **L453-458**: `widget_attributes`ブロック - 共通属性（id, name, disabled, required）の出力
13. **L470-481**: `attributes`ブロック - 任意のHTML属性の出力

#### Step 3: フォームレンダリングエンジンを理解する

Twigのフォームレンダリング拡張がどのようにブロックを解決するかを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | FormExtension.php | `src/Symfony/Bridge/Twig/Extension/FormExtension.php` | Twigフォーム関数（form_widget, form_label等）の登録を理解する |
| 3-2 | TwigRendererEngine.php | `src/Symfony/Bridge/Twig/Form/TwigRendererEngine.php` | ブロック名の解決ルール（型名ベースの階層的ブロック検索）を理解する |

### プログラム呼び出し階層図

```
{{ form_widget(form.field) }}
    |
    +-- FormExtension::form_widget()
            |
            +-- FormRenderer::searchAndRenderBlock()
                    |
                    +-- TwigRendererEngine::renderBlock()
                            |
                            +-- [型名に基づくブロック解決]
                            |   例: text_widget → form_widget_simple
                            |
                            +-- Twig::render(ブロック名, FormView::vars)
                                    |
                                    +-- form_widget_simple ブロック実行
                                            |
                                            +-- widget_attributes ブロック
                                            +-- attributes ブロック
```

### データフロー図

```
[入力]                          [処理]                              [出力]

FormView ---------> TwigRendererEngine ---------> ブロック解決
(vars: id, name,    (テーマテンプレート検索)           |
 value, attr,                                        v
 errors, ...)                                  form_div_layout.html.twig
                                               (該当ブロック実行)
                                                      |
                                                      v
                                               HTML文字列
                                               (<div>, <input>, <label>,
                                                <ul class="errors">, ...)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | テンプレート | div要素ベースの標準フォームレイアウトテーマ（全482行） |
| FormView.php | `src/Symfony/Component/Form/FormView.php` | ソース | フォームビューデータ構造 |
| FormExtension.php | `src/Symfony/Bridge/Twig/Extension/FormExtension.php` | ソース | Twigフォームヘルパー関数の定義 |
| TwigRendererEngine.php | `src/Symfony/Bridge/Twig/Form/TwigRendererEngine.php` | ソース | Twigベースのフォームレンダリングエンジン |
| FormRenderer.php | `src/Symfony/Component/Form/FormRenderer.php` | ソース | フォームレンダリングのメインロジック |
