# 画面設計書 44-フォームレイアウト（table）

## 概要

本ドキュメントは、Symfony Twig Bridgeが提供するtable要素ベースのフォームレイアウトテーマ（form_table_layout.html.twig）の画面設計書である。form_div_layoutを基盤として、フォーム要素をHTMLテーブル構造でレンダリングするテーマである。

### 本画面の処理概要

**業務上の目的・背景**：テーブルレイアウトは、ラベルと入力フィールドを規則正しく整列させたい場合に有効なレイアウト手法である。特にデータ入力が中心の業務アプリケーションや管理画面において、フォーム要素を視覚的に整列させるために使用される。form_div_layoutのTwigの`use`タグを用いた継承により、テーブル構造に変更される4つのブロック（form_row_render, button_row, hidden_row, form_widget_compound）のみをオーバーライドし、それ以外はform_div_layoutのブロックをそのまま利用する。

**画面へのアクセス方法**：Symfonyの設定で`twig.form_themes`にこのテーマを指定する。フォームを含むTwigテンプレートで`{{ form(form) }}`等のフォームヘルパー関数を呼び出すことでテーブルレイアウトでレンダリングされる。

**主要な操作・処理内容**：
1. フォーム行をtr/td要素でレンダリング（左列：ラベル、右列：ウィジェット+エラー+ヘルプ）
2. ボタン行は左列を空セル、右列にボタンウィジェットを配置
3. 隠しフィールド行はdisplay:noneスタイルでcolspan=2のtr/tdに配置
4. 複合ウィジェットのルートをtable要素でラップし、エラーはcolspan=2のtr/tdに配置
5. form_div_layoutの全ウィジェットブロック（input, select, checkbox等）をそのまま継承

**画面遷移**：本テーマファイル自体は画面遷移を定義しない。

**権限による表示制御**：テーマファイル自体には権限制御機能はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | Form | 主機能 | table要素ベースのフォームレイアウトテーマによるフォームレンダリング |
| 36 | Twig Bridge | 主機能 | Twig Bridgeのフォームレンダリング拡張によるフォームブロック定義 |

## 画面種別

フォームテーマ（Twigテンプレート断片）

## URL/ルーティング

本テーマファイルは直接URLに紐づかない。

```yaml
# config/packages/twig.yaml
twig:
    form_themes: ['form_table_layout.html.twig']
```

## 入出力項目

form_div_layoutと同一。No.43「フォームレイアウト（div）」を参照。

## 表示項目

### オーバーライドされたTwigブロック一覧

| ブロック名 | 説明 | 出力HTML構造 |
|-----------|------|-------------|
| form_row_render | フォーム行 | `<tr><td>label</td><td>errors + widget + help</td></tr>` |
| button_row | ボタン行 | `<tr><td></td><td>button_widget</td></tr>` |
| hidden_row | 隠しフィールド行 | `<tr style="display:none"><td colspan="2">hidden_widget</td></tr>` |
| form_widget_compound | 複合ウィジェット | `<table>...<tr><td colspan="2">errors</td></tr>...rows...rest...</table>` |

その他のブロック（form_widget_simple, choice_widget, form_label, form_errors, form_help等）はすべてform_div_layoutから継承される。

## イベント仕様

### 1-テーブルレイアウトでのフォームレンダリング

form_div_layoutと同一のフォームヘルパー関数呼び出しにより、テーブル構造のHTMLが生成される。

主な構造の違い：
- `form_row_render`: div → tr/td（左列ラベル、右列入力フィールド）
- `form_widget_compound`: div → table（複合フォームのルート要素）
- `hidden_row`: divなし → tr/td（display:none）
- `button_row`: div → tr/td（左列空、右列ボタン）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フォームレンダリング | なし | なし | テンプレートはHTMLレンダリングのみ |

## メッセージ仕様

form_div_layoutと同一。バリデーションエラーはform_errorsブロック（div_layoutから継承）で表示される。

## 例外処理

テーマテンプレート自体は例外をスローしない。

## 備考

- `{% use 'form_div_layout.html.twig' %}`により、form_div_layoutの全ブロックを基盤として利用
- テーブルレイアウトは4ブロック（47行）のみのオーバーライドで実現されている非常に小規模なテーマ
- hidden_rowではrow_attr.styleが存在する場合、既存スタイルに`display: none`を追加する
- HTML5ではtable要素をレイアウト目的で使用することは推奨されないため、Bootstrap等のCSSフレームワーク対応テーマの使用が推奨される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

form_div_layoutと同一のFormView構造。No.43のStep 1を参照。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FormView.php | `src/Symfony/Component/Form/FormView.php` | フォームビューの構造を理解する |

#### Step 2: 基盤テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | 基盤テンプレートの全ブロック定義を理解する |

#### Step 3: テーブルレイアウトのオーバーライドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | form_table_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_table_layout.html.twig` | 4つのオーバーライドブロックの内容を理解する |

**主要処理フロー**:
1. **L1**: `{% use 'form_div_layout.html.twig' %}` - 基盤テンプレートの読み込み
2. **L3-14**: `form_row_render`ブロック - tr/td構造（左列label、右列errors+widget+help）
3. **L16-23**: `button_row`ブロック - tr/td構造（左列空、右列ボタン）
4. **L25-32**: `hidden_row`ブロック - display:noneスタイル付きtr/td
5. **L34-46**: `form_widget_compound`ブロック - table要素によるルートラッパー

### プログラム呼び出し階層図

```
{{ form_widget(form) }}
    |
    +-- form_widget [form_div_layoutから継承]
            |
            +-- [compound] form_widget_compound [tableレイアウト オーバーライド]
            |       |
            |       +-- <table>
            |       +-- [rootform] form_errors [form_div_layoutから継承]
            |       +-- form_rows → form_row → form_row_render [tableレイアウト オーバーライド]
            |       |       |
            |       |       +-- <tr><td>form_label</td><td>form_errors + form_widget + form_help</td></tr>
            |       |
            |       +-- form_rest [form_div_layoutから継承]
            |       +-- </table>
            |
            +-- [simple] form_widget_simple [form_div_layoutから継承]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

FormView ---------> TwigRendererEngine ---------> ブロック解決
                    (form_table_layoutを検索)        |
                                                    v
                                    [オーバーライドブロック] form_table_layout.html.twig
                                    [継承ブロック] form_div_layout.html.twig
                                                    |
                                                    v
                                             HTML文字列
                                             (<table>, <tr>, <td>, <input>, ...)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| form_table_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_table_layout.html.twig` | テンプレート | table要素ベースのフォームレイアウトテーマ（全47行） |
| form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | テンプレート | 基盤となるdiv要素ベースのフォームレイアウトテーマ（全482行） |
| FormView.php | `src/Symfony/Component/Form/FormView.php` | ソース | フォームビューデータ構造 |
