# 画面設計書 6-プロファイラー情報

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する「プロファイラー情報」画面の設計書である。本画面は、指定されたトークンのプロファイルが見つからない場合に情報メッセージを表示するエラー情報画面である。

### 本画面の処理概要

本画面は、プロファイラーパネル（No.2）の表示処理において、指定されたトークンに対応するプロファイルデータが存在しない場合にフォールバックとして表示される情報画面である。

**業務上の目的・背景**：開発者がプロファイラーパネルにアクセスした際に、指定したトークンのプロファイルデータが見つからない場合（古いプロファイルの期限切れ、無効なトークンの指定など）、エラー内容を分かりやすく表示し、次のアクションを促すことを目的とする。`latest`トークン指定時にプロファイルが一切存在しない場合にも表示される。

**画面へのアクセス方法**：プロファイラーパネル（No.2）の表示処理（`panelAction`）において、`Profiler::loadProfile()`がfalseを返した場合に本画面のテンプレートが使用される。直接URLアクセスではなく、panelActionの内部分岐で表示される。

**主要な操作・処理内容**：
1. panelAction内でプロファイルが見つからない場合にinfo.html.twigがレンダリングされる
2. `about`パラメータに基づいてメッセージを切り替え（現在は`no_token`のみ）
3. `latest`トークン指定時は「There are no profiles」/「No profiles found.」を表示
4. それ以外のトークン指定時は「Token not found」/「Token "{token}" not found.」を表示
5. ステータスバーにエラー状態を表示

**画面遷移**：
- 遷移元：プロファイラーパネル（No.2）- トークン不明時の内部遷移
- 遷移先：プロファイラーホーム（ヘッダーリンク）、検索（サイドバーリンク）

**権限による表示制御**：プロファイラーが有効な環境でのみ動作する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | ProfilerController::panelActionでトークン不明時にinfo.html.twigを表示 |
| 35 | TwigBundle | 補助機能 | Twig Environmentによるinfo.html.twigテンプレートのレンダリング |

## 画面種別

情報表示（エラー情報）

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| ルート名 | `_profiler`（パネル表示の一部として） |
| URLパターン | `/_profiler/{token}` |
| HTTPメソッド | GET |
| コントローラー | `web_profiler.controller.profiler::panelAction`（内部分岐） |

## 入出力項目

### 入力（テンプレート変数）

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| about | 入力 | string | メッセージタイプ（`no_token`） |
| token | 入力 | string | リクエストされたトークン |
| request | 入力 | Request | HTTPリクエストオブジェクト |
| profile_type | 入力 | string | プロファイルタイプ |

## 表示項目

### メッセージ定義

| about値 | status | title（latestトークン時） | message（latestトークン時） |
|---------|--------|--------------------------|---------------------------|
| no_token | error | There are no profiles | No profiles found. |

| about値 | status | title（その他トークン時） | message（その他トークン時） |
|---------|--------|--------------------------|---------------------------|
| no_token | error | Token not found | Token "{token}" not found. |

### レイアウト構成

| 領域 | 表示内容 |
|------|---------|
| サマリー | エラーステータス表示（赤色バー）、ステータスタイトル |
| パネル | メッセージタイトル（h2）、メッセージ本文（p） |

## イベント仕様

### 1-情報画面表示

panelAction内で`Profiler::loadProfile($token)`がfalseを返した場合に以下が実行される：
1. about=`no_token`としてinfo.html.twigがレンダリングされる
2. テンプレート内でトークン値に基づいてメッセージが切り替わる（`latest`かそれ以外か）
3. サマリー領域にエラーステータスが表示される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 情報画面表示 | なし | なし | 表示のみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| no_profiles_title | エラー | "There are no profiles" | latestトークン指定時にプロファイルが存在しない場合 |
| no_profiles_msg | エラー | "No profiles found." | 同上 |
| token_not_found_title | エラー | "Token not found" | 指定トークンのプロファイルが見つからない場合 |
| token_not_found_msg | エラー | 'Token "{token}" not found.' | 同上 |

## 例外処理

| 例外クラス | 発生条件 | ユーザーへの影響 |
|-----------|---------|----------------|
| なし | - | 本画面自体がエラー情報の表示画面であり、例外はスローしない |

## 備考

- 本画面はlayout.html.twigを継承しているため、プロファイラー共通のヘッダー・サイドバーが表示される
- メッセージの定義はTwigテンプレート内の`messages`変数（連想配列）で管理されている
- `about`パラメータはpanelActionから`no_token`固定で渡される
- サマリー領域のCSSクラスは`status-{messages[about].status}`で動的に設定される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | info.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/info.html.twig` | メッセージ定義の連想配列（3-9行目）。`no_token`キーに対応するstatus/title/messageの構造を確認 |

**読解のコツ**: Twigの`set`ディレクティブで定義されたmessages変数は、about値をキーとした連想配列で、各エントリにstatus/title/messageのプロパティを持つ。tokenの値に基づいて三項演算子でメッセージが切り替わる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | panelActionメソッドの79-81行目で、プロファイルが見つからない場合にinfo.html.twigが呼び出される分岐を確認 |

**主要処理フロー**:
1. **79行目**: `$this->profiler->loadProfile($token)` - プロファイル読み込み試行
2. **80行目**: 読み込み失敗時に`renderWithCspNonces`で`info.html.twig`をレンダリング（about='no_token', token, request, profile_typeを渡す）

#### Step 3: テンプレートの描画ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | info.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/info.html.twig` | layout.html.twigを継承し、summaryブロックとpanelブロックをオーバーライドしている。12-17行目でサマリー、19-22行目でパネル内容を定義 |

### プログラム呼び出し階層図

```
ProfilerController::panelAction($request, $token)
    |
    +-- Profiler::loadProfile($token) --> false (プロファイル不存在)
    |
    +-- renderWithCspNonces($request, '@WebProfiler/Profiler/info.html.twig', [...])
            +-- ContentSecurityPolicyHandler::getNonces()
            +-- Environment::render('info.html.twig', $variables)
                    +-- layout.html.twig (継承)
                    +-- base.html.twig (継承)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

HTTPリクエスト         --> ProfilerController            --> HTMLレスポンス
(GET /_profiler/{token})    ::panelAction()                  (info.html.twig)
    |                           |
    +-- token (URL)         +-- loadProfile() --> false       メッセージ表示
                            +-- renderWithCspNonces()         - "Token not found"
                                    |                         または
                                    +-- about = 'no_token'    - "There are no profiles"
                                    +-- token
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | ソース | panelAction内でinfo.html.twigを呼び出す |
| info.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/info.html.twig` | テンプレート | 情報メッセージの表示 |
| layout.html.twig | `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` | テンプレート | 共通レイアウト（継承元） |
