# 画面設計書 8-PHP情報表示

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する「PHP情報表示」画面の設計書である。本画面はPHPの設定情報（phpinfo()の出力）をブラウザ上に表示する画面である。

### 本画面の処理概要

本画面は、PHPの組み込み関数`phpinfo()`の出力をそのままHTMLレスポンスとして返却する画面である。

**業務上の目的・背景**：開発者がアプリケーションの実行環境で使用されているPHPの詳細な設定情報を、プロファイラーの一部として確認できるようにすることが目的である。PHPバージョン、拡張モジュール、php.ini設定値、コンパイルオプションなど、環境固有の情報をブラウザ上で直接確認できる。通常の`phpinfo()`と同様の情報が表示されるが、プロファイラーのアクセス制御が適用される。

**画面へのアクセス方法**：プロファイラーパネル（No.2）の設定パネル（No.35）やその他のパネル内に表示されるPHP情報リンクからアクセスする。URLは`/_profiler/phpinfo`。

**主要な操作・処理内容**：
1. プロファイラーの有効性確認
2. CSPを無効化
3. PHPの出力バッファリングを開始
4. `phpinfo()`関数を実行
5. 出力バッファの内容を取得しクリア
6. 取得したHTMLをそのままレスポンスとして返却

**画面遷移**：
- 遷移元：プロファイラーパネル（No.2）のPHP情報リンク
- 遷移先：特になし（単独の表示画面）

**権限による表示制御**：プロファイラーが有効な環境でのみ動作する。プロファイラーが無効な場合は404エラーが返される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | ProfilerController::phpinfoActionによるphpinfo()出力の表示 |
| 1 | HttpFoundation | 補助機能 | phpinfo()の出力をResponseとして返却 |

## 画面種別

情報表示（phpinfo出力）

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| ルート名 | `_profiler_phpinfo` |
| URLパターン | `/_profiler/phpinfo` |
| HTTPメソッド | GET |
| コントローラー | `web_profiler.controller.profiler::phpinfoAction` |

## 入出力項目

本画面は入力パラメータを受け取らない。

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| なし | - | - | phpinfo()の出力がそのまま表示される |

## 表示項目

`phpinfo()`関数が生成する標準的なPHP情報ページ。主な表示セクション：

| セクション | 表示内容 |
|-----------|---------|
| PHP Version | PHPバージョン情報 |
| System | OS情報、コンパイラ情報 |
| Configuration | php.ini設定ファイルのパス |
| Core | PHPコア設定値 |
| 各拡張モジュール | 有効な拡張モジュールとその設定 |
| Environment | 環境変数 |
| PHP Variables | PHP変数（$_SERVER等） |

## イベント仕様

### 1-PHP情報表示

1. `denyAccessIfProfilerDisabled()`でプロファイラー有効性を確認（プロファイラー計測も無効化）
2. `ContentSecurityPolicyHandler::disableCsp()`でCSPを無効化
3. `ob_start()`で出力バッファリングを開始
4. `phpinfo()`を実行（HTMLが出力バッファに書き込まれる）
5. `ob_get_clean()`でバッファ内容を取得しバッファをクリア
6. 取得したHTMLを`new Response($phpinfo, 200, ['Content-Type' => 'text/html'])`としてレスポンスを返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| PHP情報表示 | なし | なし | phpinfo()の出力のみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| profiler_disabled | エラー | "The profiler must be enabled." | プロファイラーが無効な場合 |

## 例外処理

| 例外クラス | 発生条件 | ユーザーへの影響 |
|-----------|---------|----------------|
| `NotFoundHttpException` | プロファイラーが無効な場合 | HTTP 404エラーページが表示される |

## 備考

- 本画面はプロファイラーの共通レイアウト（layout.html.twig）を使用せず、phpinfo()のHTML出力をそのまま返却する
- phpinfo()の出力は完全なHTMLドキュメント（DOCTYPE, html, head, body）を含むため、独自のスタイルで表示される
- CSPを無効化するのは、phpinfo()の出力にインラインスタイルやスクリプトが含まれる可能性があるため
- `ob_start()`/`ob_get_clean()`パターンによりphpinfo()の出力を変数にキャプチャしている
- 本画面はセキュリティ上重要な情報を含むため、開発環境でのみ利用可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | profiler.php | `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` | `_profiler_phpinfo`ルート（24-26行目）の定義を確認 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | `phpinfoAction`メソッド（316-327行目）がエントリーポイント。シンプルな出力バッファリングパターンを把握する |

**主要処理フロー**:
1. **318行目**: `denyAccessIfProfilerDisabled()` - プロファイラー有効性確認
2. **320行目**: `$this->cspHandler?->disableCsp()` - CSP無効化
3. **322行目**: `ob_start()` - 出力バッファリング開始
4. **323行目**: `phpinfo()` - PHP情報出力
5. **324行目**: `$phpinfo = ob_get_clean()` - バッファ取得・クリア
6. **326行目**: `new Response($phpinfo, 200, ['Content-Type' => 'text/html'])` - レスポンス返却

### プログラム呼び出し階層図

```
ProfilerController::phpinfoAction()
    |
    +-- denyAccessIfProfilerDisabled()
    |       +-- Profiler::disable()
    |
    +-- ContentSecurityPolicyHandler::disableCsp()
    |
    +-- ob_start()
    +-- phpinfo()
    +-- ob_get_clean()
    |
    +-- new Response($phpinfo, 200, ['Content-Type' => 'text/html'])
```

### データフロー図

```
[入力]                 [処理]                       [出力]

HTTPリクエスト      --> ProfilerController          --> HTMLレスポンス
(GET /_profiler/        ::phpinfoAction()               (phpinfo() HTML)
 phpinfo)                    |
                         +-- ob_start()
                         +-- phpinfo()
                         +-- ob_get_clean()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | ソース | phpinfoActionメソッドを含むコントローラー |
| profiler.php | `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` | 設定 | ルーティング定義（_profiler_phpinfoルート） |
