# 画面設計書 9-Xdebug情報表示

## 概要

本ドキュメントは、Symfony WebProfilerBundleが提供する「Xdebug情報表示」画面の設計書である。本画面はXdebugの設定情報（xdebug_info()の出力）をブラウザ上に表示する画面である。

### 本画面の処理概要

本画面は、PHPデバッグ拡張であるXdebugの`xdebug_info()`関数の出力をHTMLレスポンスとして返却する画面である。

**業務上の目的・背景**：開発者がデバッグ環境で使用されているXdebugの設定情報を確認できるようにすることが目的である。Xdebugのバージョン、動作モード、リモートデバッグ設定、カバレッジ設定、プロファイリング設定など、Xdebug固有の詳細な情報をブラウザ上で直接確認できる。Xdebugのトラブルシューティングや設定の検証に利用される。Xdebug 3以降のxdebug_info()関数が必要であり、インストールされていない場合はエラーが返される。

**画面へのアクセス方法**：プロファイラーパネル（No.2）のXdebug情報リンクからアクセスする。URLは`/_profiler/xdebug`。

**主要な操作・処理内容**：
1. プロファイラーの有効性確認
2. `xdebug_info()`関数の存在確認（Xdebug 3がインストールされているか）
3. 関数が存在しない場合はNotFoundHttpExceptionをスロー
4. CSPを無効化
5. 出力バッファリングで`xdebug_info()`の出力をキャプチャ
6. キャプチャしたHTMLをそのままレスポンスとして返却

**画面遷移**：
- 遷移元：プロファイラーパネル（No.2）のXdebugリンク
- 遷移先：特になし（単独の表示画面）

**権限による表示制御**：プロファイラーが有効な環境でのみ動作する。Xdebug 3以降がインストールされていない場合は404エラーが返される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | WebProfilerBundle | 主機能 | ProfilerController::xdebugActionによるxdebug_info()出力の表示 |
| 1 | HttpFoundation | 補助機能 | xdebug_info()の出力をResponseとして返却 |

## 画面種別

情報表示（xdebug_info出力）

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| ルート名 | `_profiler_xdebug` |
| URLパターン | `/_profiler/xdebug` |
| HTTPメソッド | GET |
| コントローラー | `web_profiler.controller.profiler::xdebugAction` |

## 入出力項目

本画面は入力パラメータを受け取らない。

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| なし | - | - | xdebug_info()の出力がそのまま表示される |

## 表示項目

`xdebug_info()`関数が生成するXdebug情報ページ。主な表示セクション：

| セクション | 表示内容 |
|-----------|---------|
| Version | Xdebugバージョン情報 |
| Support | サポート情報とリンク |
| Debugger | デバッガー設定（リモートデバッグ設定等） |
| Coverage | コードカバレッジ設定 |
| Profiler | Xdebugプロファイラー設定 |
| Settings | 全設定値一覧 |

## イベント仕様

### 1-Xdebug情報表示

1. `denyAccessIfProfilerDisabled()`でプロファイラー有効性を確認
2. `function_exists('xdebug_info')`でXdebug 3の存在を確認
3. Xdebugが未インストールの場合はNotFoundHttpException（'Xdebug must be installed in version 3.'）をスロー
4. `ContentSecurityPolicyHandler::disableCsp()`でCSPを無効化
5. `ob_start()`で出力バッファリングを開始
6. `xdebug_info()`を実行
7. `ob_get_clean()`でバッファ内容を取得しクリア
8. 取得したHTMLを`new Response($xdebugInfo, 200, ['Content-Type' => 'text/html'])`としてレスポンスを返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Xdebug情報表示 | なし | なし | xdebug_info()の出力のみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| profiler_disabled | エラー | "The profiler must be enabled." | プロファイラーが無効な場合 |
| xdebug_not_installed | エラー | "Xdebug must be installed in version 3." | xdebug_info()関数が存在しない場合 |

## 例外処理

| 例外クラス | 発生条件 | ユーザーへの影響 |
|-----------|---------|----------------|
| `NotFoundHttpException` | プロファイラーが無効な場合 | HTTP 404エラーページが表示される |
| `NotFoundHttpException` | `xdebug_info()`関数が存在しない場合（Xdebug 3未インストール） | HTTP 404エラーページが表示される |

## 備考

- 本画面はphpinfo画面（No.8）と同様のパターンで実装されているが、Xdebug 3の存在確認が追加されている
- プロファイラーの共通レイアウトを使用せず、xdebug_info()のHTML出力をそのまま返却する
- `xdebug_info()`はXdebug 3.0以降で追加された関数であり、Xdebug 2以前ではNotFoundHttpExceptionがスローされる
- CSP無効化はxdebug_info()の出力にインラインスタイルが含まれるため
- Xdebugのバージョン確認は`function_exists()`で行われ、Xdebug拡張自体の存在ではなく特定関数の存在で判定する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | profiler.php | `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` | `_profiler_xdebug`ルート（27-29行目）の定義を確認 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | `xdebugAction`メソッド（334-349行目）がエントリーポイント。Xdebug存在確認と出力バッファリングパターンを把握する |

**主要処理フロー**:
1. **336行目**: `denyAccessIfProfilerDisabled()` - プロファイラー有効性確認
2. **338-340行目**: `function_exists('xdebug_info')` - Xdebug 3の存在確認。存在しない場合NotFoundHttpException
3. **342行目**: `$this->cspHandler?->disableCsp()` - CSP無効化
4. **344行目**: `ob_start()` - 出力バッファリング開始
5. **345行目**: `xdebug_info()` - Xdebug情報出力
6. **346行目**: `$xdebugInfo = ob_get_clean()` - バッファ取得・クリア
7. **348行目**: `new Response($xdebugInfo, 200, ['Content-Type' => 'text/html'])` - レスポンス返却

### プログラム呼び出し階層図

```
ProfilerController::xdebugAction()
    |
    +-- denyAccessIfProfilerDisabled()
    |       +-- Profiler::disable()
    |
    +-- function_exists('xdebug_info')
    |       +-- [false] NotFoundHttpException('Xdebug must be installed in version 3.')
    |
    +-- ContentSecurityPolicyHandler::disableCsp()
    |
    +-- ob_start()
    +-- xdebug_info()
    +-- ob_get_clean()
    |
    +-- new Response($xdebugInfo, 200, ['Content-Type' => 'text/html'])
```

### データフロー図

```
[入力]                 [処理]                       [出力]

HTTPリクエスト      --> ProfilerController          --> HTMLレスポンス
(GET /_profiler/        ::xdebugAction()                (xdebug_info() HTML)
 xdebug)                     |
                         +-- function_exists()チェック
                         +-- ob_start()
                         +-- xdebug_info()
                         +-- ob_get_clean()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ProfilerController.php | `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` | ソース | xdebugActionメソッドを含むコントローラー |
| profiler.php | `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` | 設定 | ルーティング定義（_profiler_xdebugルート） |
